import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * An experimental extension that deletes all contents of the referenced bucket when the stack is deleted. Use with caution!
 *
 * @schema CfnDeleteBucketContentsProps
 */
export interface CfnDeleteBucketContentsProps {
    /**
     * The name of the bucket
     *
     * @schema CfnDeleteBucketContentsProps#BucketName
     */
    readonly bucketName: string;
}
/**
 * Converts an object of type 'CfnDeleteBucketContentsProps' to JSON representation.
 */
export declare function toJson_CfnDeleteBucketContentsProps(obj: CfnDeleteBucketContentsProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AwsCommunity::S3::DeleteBucketContents`
 *
 * @cloudformationResource AwsCommunity::S3::DeleteBucketContents
 * @stability external
 * @link https://github.com/aws-cloudformation/community-registry-extensions.git
 */
export declare class CfnDeleteBucketContents extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "AwsCommunity::S3::DeleteBucketContents";
    /**
     * Resource props.
     */
    readonly props: CfnDeleteBucketContentsProps;
    /**
     * Create a new `AwsCommunity::S3::DeleteBucketContents`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnDeleteBucketContentsProps);
}
