from enum import Enum


class Params(Enum):
    def get_by_id(pid):
        return Params._value2member_map_.get(pid, None)

    def __repr__(self):
        return f"{self.__class__.__name__}.{self._name_}"

    LIGHTER = "1"
    POKER = "3"
    FUEL_LEVEL = "110"
    CAUTION_FUEL_LEVEL = "113"
    CAUTION_LOAD_THE_TANK = "114"
    LAMBDA_SENSOR_CALIBRATION_IN_PROGRESS = "116"
    LAMBDA_ERROR = "117"
    DAMAGED_FUEL_SUPPLY_SYSTEM = "118"
    UNSEAL = "122"
    BOILER_THERMOSTAT = "131"
    ROOM_THERMOSTAT_MIXER_1 = "132"
    ROOM_THERMOSTAT_MIXER_2 = "133"
    ROOM_THERMOSTAT_MIXER_3 = "134"
    ROOM_THERMOSTAT_MIXER_4 = "135"
    VALVE_MIXER_1 = "150"
    VALVE_MIXER_2 = "151"
    VALVE_MIXER_3 = "152"
    VALVE_MIXER_4 = "153"
    SERVO_MIXER_1 = "154"
    SERVO_MIXER_2 = "155"
    SERVO_MIXER_3 = "156"
    SERVO_MIXER_4 = "157"
    VALVE_MIXER_1_2 = "158"
    VALVE_MIXER_2_2 = "159"
    VALVE_MIXER_3_2 = "160"
    VALVE_MIXER_4_2 = "161"
    OXYGEN = "162"
    OXYGEN_2 = "165"
    WORK_AT_100 = "166"
    WORK_AT_50 = "167"
    WORK_AT_30 = "168"
    FEEDER_WORK = "169"
    FIRING_UP_COUNT = "170"
    NUMBER_OF_RESETS = "171"
    ETH_IP = "172"
    ETH_MASK = "173"
    ETH_GATEWAY = "174"
    ETH_SERVER_CONNECTED = "175"
    WIFI_IP = "176"
    WIFI_MASK = "177"
    WIFI_GATEWAY = "178"
    WIFI_SERVER_CONNECTED = "179"
    WIFI_ENCRYPTION = "180"
    WIFI_SIGNAL_STRENGHT = "181"
    WIFI_STATUS = "182"
    WIFI_SSID = "184"
    BOILER_TEMPERATURE = "1024"
    HUW_TEMPERATURE = "1025"
    FEEDER_TEMPERATURE = "1026"
    WEATHER_TEMPERATURE = "1027"
    UPPER_BUFFER_TEMPERATURE = "1028"
    LOWER_BUFFER_TEMPERATURE = "1029"
    EMISSION_TEMPERATURE = "1030"
    TEMP_MIXER_1 = "1031"
    TEMP_MIXER_2 = "1032"
    TEMP_MIXER_3 = "1033"
    TEMP_MIXER_4 = "1034"
    PRESET_BOILER_TEMPERATURE = "1280"
    HUW_PRESET_TEMPERATURE = "1281"
    PRESET_TEMP_MIXER_1 = "1287"
    PRESET_TEMP_MIXER_2 = "1288"
    PRESET_TEMP_MIXER_3 = "1289"
    PRESET_TEMP_MIXER_4 = "1290"
    FAN = "1536"
    FEEDER = "1538"
    ADDITIONAL_FEEDER = "1540"
    BOILER_PUMP = "1541"
    HUW_PUMP = "1542"
    CIRCULATING_PUMP = "1543"
    PUMP_MIXER_1 = "1544"
    PUMP_MIXER_2 = "1547"
    PUMP_MIXER_3 = "1550"
    PUMP_MIXER_4 = "1553"
    OPERATION_MODE = "1792"
    BURNER_OUTPUT = "1794"
    EDIT_PRESET_BOILER_TEMPERATURE = 0
    MIN_BOILER_TEMPERATURE = 1
    MAX_BOILER_TEMPERATURE = 2
    BOILER_INC_BY_HUW_MIXER = 3
    CH_PUMP_ACTIVATION_TEMPERATURE = 4
    DHW_PUMP = 5
    HUW_PUMP_MODE = 8
    BLOW_IN_OUTPUT_100 = 10
    FEEDER_OPERATION_100 = 11
    FEEDER_INTERVAL_100 = 12
    FEEDER_WORK_CORRECTION_50 = 13
    FEEDER_OPERATION_50 = 14
    FEEDER_INTERVAL_50 = 15
    BLOW_IN_OUTPUT_30 = 16
    FEEDER_OPERATION_30 = 17
    FEEDER_INTERVAL_30 = 18
    H2_HYSTERESIS_50 = 19
    H1_HYSTERESIS_30 = 20
    BOILER_HYSTERESIS = 21
    FIRING_UP_AIRFLOW = 22
    IGNITION_TEST_TIME = 23
    IGNITION_TEST_TIME_2 = 24
    FEEDING_TIME = 25
    FIRING_UP_TIME = 26
    EX_TEMP_DELTA = 27
    EX_TEMP_DELTA_2 = 28
    EX_TEMP_AT_THE_END_OF_FIRING_UP = 29
    TEST_DOSE = 30
    SUPERVISION_TIME = 31
    FEED_INTERVAL = 32
    AIRFLOW_OPER_EXTEND = 33
    MINIMUM_AIRFLOW_OUTPUT = 34
    STABILIZATION_TIME = 35
    BURNING_OFF_TIME = 36
    AIR_FLUSH_INTENSITY = 37
    OXYGEN_100 = 38
    OXYGEN_50 = 39
    OXYGEN_30 = 40
    AIRFLOW_CORRECTION_RANGE = 41
    POKER_CYCLE_TIME = 42
    EX_TEMP_W_NO_FUEL = 43
    EDIT_HUW_PRESET_TEMPERATURE = 47
    MINIMUM_HUW_TEMPERATURE = 48
    MAXIMUM_HUW_TEMPERATURE = 49
    HUW_CONT_HYSTERESIS = 50
    HUW_DISINFECTION = 52
    SUMMER_MODE = 56
    CH_PUMP_STANDSTILL_WHEN_LOADING_HUW = 59
    EXTENDING_HUW_PUMP_OPERATION_TIME = 60
    EXCHANGER = 61
    PRESET_MIXER_1 = 62
    MIN_MIXER_1_TEMP = 66
    MAX_MIXER_1_TEMP = 70
    MIXER_1_ROOM_THERM = 74
    MIXER_1_SUPPORT = 86
    PROPORTIONAL_RANGE = 90
    INTEGRATION_TIME_CONSTANT = 94
    OFF_BY_THERMOSTAT = 98
    VALVE_FULL_OPENING_TIME = 102
    MIXER_1_INPUT_DEAD_ZONE = 106
    BOILER_COOLING_TEMPERATURE = 111
    AIRFLOW_POWER_CORRECTION_100 = 129
    FEEDER_WORK_CORRECTION_100 = 130
    AIRFLOW_POWER_CORRECTION_50 = 131
    FEEDER_WORK_CORRECTIN_50 = 132
    AIRFLOW_POWER_CORRECTION_30 = 133
    FEEDER_WORK_CORRECTION_30 = 134
    BURNER_CLEANING = 135
    CLEANING_SYSTEM_OPERATION_TIME = 136
    ALARM_LEVEL = 137
    NO_FUEL_DETECTION_TIME = 138
    FEEDER_OPERAT_TIME_2 = 140
    FEEDER_INTERVAL_2 = 141
    FEEDER_2_MESSAGE = 142
    MAX_BURNER_TEMP = 143
    OPERATION_WITH_LAMBDA_SENSOR = 144
    FEEDER_LOCK = 145
    FUEL_DETECTION_OXYGEN = 146
    FUEL_DETECTION_TIME = 147
    PARAMETER_A = 148
    PARAMETER_B = 149
    PARAMETER_C = 150
    OUTPUT_H1 = 152
    H2_OUTPUT = 153
    HEAT_SOURCE = 157
    THERMOSTAT_LOCK = 159
    BOILER_PUMP_LOCK = 160
    SHOW_ADVANCED_SETUP = 164
    ALARMS = 165
