"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.ClassificationString = exports.SerializationLibrary = exports.OutputFormat = exports.InputFormat = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Absolute class name of the Hadoop `InputFormat` to use when reading table files.
 */
class InputFormat {
    constructor(className) {
        this.className = className;
    }
}
exports.InputFormat = InputFormat;
_a = JSII_RTTI_SYMBOL_1;
InputFormat[_a] = { fqn: "@aws-cdk/aws-glue.InputFormat", version: "1.164.0" };
/**
 * InputFormat for Avro files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerInputFormat.html
 */
InputFormat.AVRO = new InputFormat('org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat');
/**
 * InputFormat for Cloudtrail Logs.
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
 */
InputFormat.CLOUDTRAIL = new InputFormat('com.amazon.emr.cloudtrail.CloudTrailInputFormat');
/**
 * InputFormat for Orc files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcInputFormat.html
 */
InputFormat.ORC = new InputFormat('org.apache.hadoop.hive.ql.io.orc.OrcInputFormat');
/**
 * InputFormat for Parquet files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetInputFormat.html
 */
InputFormat.PARQUET = new InputFormat('org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat');
/**
 * An InputFormat for plain text files. Files are broken into lines. Either linefeed or
 * carriage-return are used to signal end of line. Keys are the position in the file, and
 * values are the line of text.
 * JSON & CSV files are examples of this InputFormat
 *
 * @see https://hadoop.apache.org/docs/stable/api/org/apache/hadoop/mapred/TextInputFormat.html
 */
InputFormat.TEXT = new InputFormat('org.apache.hadoop.mapred.TextInputFormat');
/**
 * Absolute class name of the Hadoop `OutputFormat` to use when writing table files.
 */
class OutputFormat {
    constructor(className) {
        this.className = className;
    }
}
exports.OutputFormat = OutputFormat;
_b = JSII_RTTI_SYMBOL_1;
OutputFormat[_b] = { fqn: "@aws-cdk/aws-glue.OutputFormat", version: "1.164.0" };
/**
 * Writes text data with a null key (value only).
 *
 * @see https://hive.apache.org/javadocs/r2.2.0/api/org/apache/hadoop/hive/ql/io/HiveIgnoreKeyTextOutputFormat.html
 */
OutputFormat.HIVE_IGNORE_KEY_TEXT = new OutputFormat('org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat');
/**
 * OutputFormat for Avro files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/avro/AvroContainerOutputFormat.html
 */
OutputFormat.AVRO = new InputFormat('org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat');
/**
 * OutputFormat for Orc files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcOutputFormat.html
 */
OutputFormat.ORC = new InputFormat('org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat');
/**
 * OutputFormat for Parquet files.
 *
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/MapredParquetOutputFormat.html
 */
OutputFormat.PARQUET = new OutputFormat('org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat');
/**
 * Serialization library to use when serializing/deserializing (SerDe) table records.
 *
 * @see https://cwiki.apache.org/confluence/display/Hive/SerDe
 */
class SerializationLibrary {
    constructor(className) {
        this.className = className;
    }
}
exports.SerializationLibrary = SerializationLibrary;
_c = JSII_RTTI_SYMBOL_1;
SerializationLibrary[_c] = { fqn: "@aws-cdk/aws-glue.SerializationLibrary", version: "1.164.0" };
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/avro/AvroSerDe.html
 */
SerializationLibrary.AVRO = new SerializationLibrary('org.apache.hadoop.hive.serde2.avro.AvroSerDe');
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
 */
SerializationLibrary.CLOUDTRAIL = new SerializationLibrary('com.amazon.emr.hive.serde.CloudTrailSerde');
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
 */
SerializationLibrary.GROK = new SerializationLibrary('com.amazonaws.glue.serde.GrokSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hive/hcatalog/data/JsonSerDe.html
 */
SerializationLibrary.HIVE_JSON = new SerializationLibrary('org.apache.hive.hcatalog.data.JsonSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/lazy/LazySimpleSerDe.html
 */
SerializationLibrary.LAZY_SIMPLE = new SerializationLibrary('org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/OpenCSVSerde.html
 */
SerializationLibrary.OPEN_CSV = new SerializationLibrary('org.apache.hadoop.hive.serde2.OpenCSVSerde');
/**
 * @see https://github.com/rcongiu/Hive-JSON-Serde
 */
SerializationLibrary.OPENX_JSON = new SerializationLibrary('org.openx.data.jsonserde.JsonSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html
 */
SerializationLibrary.ORC = new SerializationLibrary('org.apache.hadoop.hive.ql.io.orc.OrcSerde');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html
 */
SerializationLibrary.PARQUET = new SerializationLibrary('org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe');
/**
 * @see https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/serde2/RegexSerDe.html
 */
SerializationLibrary.REGEXP = new SerializationLibrary('org.apache.hadoop.hive.serde2.RegexSerDe');
/**
 * Classification string given to tables with this data format.
 *
 * @see https://docs.aws.amazon.com/glue/latest/dg/add-classifier.html#classifier-built-in
 */
class ClassificationString {
    constructor(value) {
        this.value = value;
    }
}
exports.ClassificationString = ClassificationString;
_d = JSII_RTTI_SYMBOL_1;
ClassificationString[_d] = { fqn: "@aws-cdk/aws-glue.ClassificationString", version: "1.164.0" };
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-avro
 */
ClassificationString.AVRO = new ClassificationString('avro');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-csv
 */
ClassificationString.CSV = new ClassificationString('csv');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-json
 */
ClassificationString.JSON = new ClassificationString('json');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-xml
 */
ClassificationString.XML = new ClassificationString('xml');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-parquet
 */
ClassificationString.PARQUET = new ClassificationString('parquet');
/**
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-format.html#aws-glue-programming-etl-format-orc
 */
ClassificationString.ORC = new ClassificationString('orc');
/**
 * Defines the input/output formats and ser/de for a single DataFormat.
 */
class DataFormat {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_DataFormatProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DataFormat);
            }
            throw error;
        }
        this.inputFormat = props.inputFormat;
        this.outputFormat = props.outputFormat;
        this.serializationLibrary = props.serializationLibrary;
        this.classificationString = props.classificationString;
    }
}
exports.DataFormat = DataFormat;
_e = JSII_RTTI_SYMBOL_1;
DataFormat[_e] = { fqn: "@aws-cdk/aws-glue.DataFormat", version: "1.164.0" };
/**
 * DataFormat for Apache Web Server Logs. Also works for CloudFront logs
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/apache.html
 */
DataFormat.APACHE_LOGS = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.REGEXP,
});
/**
 * DataFormat for Apache Avro
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/avro.html
 */
DataFormat.AVRO = new DataFormat({
    inputFormat: InputFormat.AVRO,
    outputFormat: OutputFormat.AVRO,
    serializationLibrary: SerializationLibrary.AVRO,
    classificationString: ClassificationString.AVRO,
});
/**
 * DataFormat for CloudTrail logs stored on S3
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html
 */
DataFormat.CLOUDTRAIL_LOGS = new DataFormat({
    inputFormat: InputFormat.CLOUDTRAIL,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.CLOUDTRAIL,
});
/**
 * DataFormat for CSV Files
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/csv.html
 */
DataFormat.CSV = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.OPEN_CSV,
    classificationString: ClassificationString.CSV,
});
/**
 * Stored as plain text files in JSON format.
 * Uses OpenX Json SerDe for serialization and deseralization.
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/json.html
 */
DataFormat.JSON = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.OPENX_JSON,
    classificationString: ClassificationString.JSON,
});
/**
 * DataFormat for Logstash Logs, using the GROK SerDe
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/grok.html
 */
DataFormat.LOGSTASH = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.GROK,
});
/**
 * DataFormat for Apache ORC (Optimized Row Columnar)
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/orc.html
 */
DataFormat.ORC = new DataFormat({
    inputFormat: InputFormat.ORC,
    outputFormat: OutputFormat.ORC,
    serializationLibrary: SerializationLibrary.ORC,
    classificationString: ClassificationString.ORC,
});
/**
 * DataFormat for Apache Parquet
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/parquet.html
 */
DataFormat.PARQUET = new DataFormat({
    inputFormat: InputFormat.PARQUET,
    outputFormat: OutputFormat.PARQUET,
    serializationLibrary: SerializationLibrary.PARQUET,
    classificationString: ClassificationString.PARQUET,
});
/**
 * DataFormat for TSV (Tab-Separated Values)
 *
 * @see https://docs.aws.amazon.com/athena/latest/ug/lazy-simple-serde.html
 */
DataFormat.TSV = new DataFormat({
    inputFormat: InputFormat.TEXT,
    outputFormat: OutputFormat.HIVE_IGNORE_KEY_TEXT,
    serializationLibrary: SerializationLibrary.LAZY_SIMPLE,
});
//# sourceMappingURL=data:application/json;base64,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