# DataWeave Python Wrapper [![Build Status](https://travis-ci.com/tetrascience/ts-dataweave-python.svg?token=uzw5KFZps3QXT9bqRDHY&branch=main)](https://travis-ci.com/tetrascience/ts-dataweave-python)

Python wrapper around MuleSoft's DataWeave data transformation engine.

## Installation

Add this package to your project using `pip` or `pipenv`:

```sh
# using pip
pip install ts-dataweave

# using pipenv
pipenv install ts-dataweave
```

The post-install script will download and extract the correct DataWeave command-line binary from [MuleSoft's DataWeave CLI repository](https://github.com/mulesoft-labs/data-weave-native/).

## Usage

To use DataWeave, import `ts_dataweave`:

```python
import ts_dataweave
```

### ts_dataweave.run(_payload_, _script_, \[_timeout_\])

Runs a DataWeave script with the specified payloads. The input payloads and script are written to temporary files and then removed when the execution is complete.

The _payload_ parameter should be a dictionary of `ts_dataweave.DataWeavePayload` instances with _string_ keys. The payloads will be added to DataWeave with the corresponding key as the name of the payload.

The _script_ parameter should be a _string_, _bytes_, or _file-like_ object containing the DataWeave script.

The _timeout_ parameter is optional and should be the number of seconds that the script is allowed to run before an error is raised. The default timeout is 30 seconds.

The `ts_dataweave.run()` function returns a _bytes_ object containing the output of the DataWeave script execution.

> A _bytes_ object can easily be converted to a UTF-8 string by using `.decode("utf-8")`.

### ts_dataweave.Payload

The `dataweave.Payload` object contains information about a DataWeave payload. Use the constructor:

```py
ts_dataweave.Payload(payloadType, data)
```

The _payloadType_ parameter should be either `"json"`, `"csv"`, or `"xml"`. Alternatively, the enumeration `dataweave.PayloadType` can also be used. Additional input types are not recognized at this time.

The _data_ parameter should be a _string_, _bytes_, or _file-like_ object containing the content of the payload.

## Full Example

```python
import ts_dataweave

print(ts_dataweave.run({
    "doc1": ts_dataweave.Payload(
        "xml", # can also use ts_dataweave.XML
        """<root>
            <firstname>Mike</firstname>
            <lastname>Foo</lastname>
        </root>"""
    ),
    "doc2": ts_dataweave.Payload(
        "json", # can also use ts_dataweave.JSON
        """{
            "birthday": "yesterday",
            "favoriteFood": "salami"
        }"""
    ),        
}, """contact: {
    firstname: doc1.root.firstname,
    lastname: doc1.root.lastname,
    food: doc2.favoriteFood,
    bday: doc2.birthday
}""").decode("utf-8"))
```

## Tests

The repository includes a test suite.

```sh
cd src
python -m pytest
```

## Compatibility

This package has been specifically developed and tested with Python 3.7 on Darwin (macOS) x86_64 and Linux x86_64 platforms.

## Changelog

### 1.0.1

- Use temporary file to capture DataWeave output instead of the standard output stream.

### 1.0.0

- Initial implementation.