# SKFeatureLLM

<div align="center">
  <img src="docs/_static/logo.png" alt="SKFeatureLLM Logo" width="200"/>
</div>

SKFeatureLLM is a Python library that brings the power of Large Language Models (LLMs) to feature engineering for tabular data, wrapped in a familiar scikit-learn–style API. The library aims to leverage LLMs' capabilities to automatically generate and implement meaningful features for your machine learning tasks.

## 🌟 Key Features

- 🤖 LLM-powered feature engineering
- 🔌 Model-agnostic: works with any LLM provider (OpenAI, Anthropic, etc.)
- 🛠 Scikit-learn compatible API
- 📊 Comprehensive feature evaluation and reporting
- 🎯 Support for both supervised and unsupervised feature engineering


## 🛠 Development

1. Clone the repository
```bash
git clone https://github.com/yourusername/skfeaturellm.git
cd skfeaturellm
```

2. Install dependencies
```bash
poetry install
```

3. Activate the virtual environment
```bash
poetry env use python3 && poetry install && source $(poetry env info --path)/bin/activate
```

### ✅ Running Tests

To run the test suite, ensure pytest is installed and execute:

```bash
poetry run pytest
```

Tests are located in the `tests/` directory and cover the core functionality of SKFeatureLLM.


## 📄 License

This project is licensed under the MIT License - see the LICENSE file for details.

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## 👤 Author

- **Roberto Corti** - [GitHub](https://github.com/RobertoCorti)
- **Stefano Polo** - [GitHub](https://github.com/stefano-polo)

## Example Usage

```python
from skfeaturellm.feature_engineer import LLMFeatureEngineer

# Initialize the feature engineer
llm_feature_engineer = LLMFeatureEngineer()

# Fit and transform the data
llm_feature_engineer.fit(X)
X_transformed = llm_feature_engineer.transform(X)

print(X_transformed)
```

This snippet demonstrates how to initialize the `LLMFeatureEngineer`, fit it to a DataFrame `X`, and transform the data to include new features generated by the LLM.
