from typing import Union, List, Optional

from pyspark.sql.types import StructType, StructField, StringType, BooleanType, DataType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class CodingSchema:
    """
    A reference to a code defined by a terminology system.
    If the element is present, it must have a value for at least one of the
    defined elements, an @id referenced from the Narrative, or extensions
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        A reference to a code defined by a terminology system.
        If the element is present, it must have a value for at least one of the
        defined elements, an @id referenced from the Narrative, or extensions


            id: None
            extension: May be used to represent additional information that is not part of the basic
        definition of the element. In order to make the use of extensions safe and
        manageable, there is a strict set of governance  applied to the definition and
        use of extensions. Though any implementer is allowed to define an extension,
        there is a set of requirements that SHALL be met as part of the definition of
        the extension.
            system: The identification of the code system that defines the meaning of the symbol
        in the code.
            version: The version of the code system which was used when choosing this code. Note
        that a well-maintained code system does not need the version reported, because
        the meaning of codes is consistent across versions. However this cannot
        consistently be assured. and when the meaning is not guaranteed to be
        consistent, the version SHOULD be exchanged.
            code: A symbol in syntax defined by the system. The symbol may be a predefined code
        or an expression in a syntax defined by the coding system (e.g. post-
        coordination).
            display: A representation of the meaning of the code in the system, following the rules
        of the system.
            userSelected: Indicates that this coding was chosen by a user directly - i.e. off a pick
        list of available items (codes or displays).
        """
        # id
        from spark_fhir_schemas.dstu2.simple_types.id import idSchema

        # extension
        from spark_fhir_schemas.dstu2.complex_types.extension import ExtensionSchema

        # system
        from spark_fhir_schemas.dstu2.simple_types.uri import uriSchema

        # code
        # type = code
        if (
            max_recursion_limit and nesting_list.count("Coding") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Coding"]
        schema = StructType(
            [
                # None
                StructField(
                    "id",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The identification of the code system that defines the meaning of the symbol
                # in the code.
                StructField(
                    "system",
                    uriSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The version of the code system which was used when choosing this code. Note
                # that a well-maintained code system does not need the version reported, because
                # the meaning of codes is consistent across versions. However this cannot
                # consistently be assured. and when the meaning is not guaranteed to be
                # consistent, the version SHOULD be exchanged.
                StructField("version", StringType(), True),
                # A symbol in syntax defined by the system. The symbol may be a predefined code
                # or an expression in a syntax defined by the coding system (e.g. post-
                # coordination).
                StructField("code", StringType(), True),
                # A representation of the meaning of the code in the system, following the rules
                # of the system.
                StructField("display", StringType(), True),
                # Indicates that this coding was chosen by a user directly - i.e. off a pick
                # list of available items (codes or displays).
                StructField("userSelected", BooleanType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
