from typing import Union, List, Optional

from pyspark.sql.types import StructType, StructField, StringType, BooleanType, DataType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class QuestionnaireGroupSchema:
    """
    A structured set of questions intended to guide the collection of answers. The
    questions are ordered and grouped into coherent subsets, corresponding to the
    structure of the grouping of the underlying questions.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        A structured set of questions intended to guide the collection of answers. The
        questions are ordered and grouped into coherent subsets, corresponding to the
        structure of the grouping of the underlying questions.


            id: None
            extension: May be used to represent additional information that is not part of the basic
        definition of the element. In order to make the use of extensions safe and
        manageable, there is a strict set of governance  applied to the definition and
        use of extensions. Though any implementer is allowed to define an extension,
        there is a set of requirements that SHALL be met as part of the definition of
        the extension.
            modifierExtension: May be used to represent additional information that is not part of the basic
        definition of the element, and that modifies the understanding of the element
        that contains it. Usually modifier elements provide negation or qualification.
        In order to make the use of extensions safe and manageable, there is a strict
        set of governance applied to the definition and use of extensions. Though any
        implementer is allowed to define an extension, there is a set of requirements
        that SHALL be met as part of the definition of the extension. Applications
        processing a resource are required to check for modifier extensions.
            linkId: An identifier that is unique within the Questionnaire allowing linkage to the
        equivalent group in a QuestionnaireResponse resource.
            title: The human-readable name for this section of the questionnaire.
            concept: Identifies a how this group of questions is known in a particular terminology
        such as LOINC.
            text: Additional text for the group, used for display purposes.
            required: If true, indicates that the group must be present and have required questions
        within it answered.  If false, the group may be skipped when answering the
        questionnaire.
            repeats: Whether the group may occur multiple times in the instance, containing
        multiple sets of answers.
            group: A sub-group within a group. The ordering of groups within this group is
        relevant.
            question: Set of questions within this group. The order of questions within the group is
        relevant.
        """
        # id
        from spark_fhir_schemas.dstu2.simple_types.id import idSchema

        # extension
        from spark_fhir_schemas.dstu2.complex_types.extension import ExtensionSchema

        # concept
        from spark_fhir_schemas.dstu2.complex_types.coding import CodingSchema

        # question
        from spark_fhir_schemas.dstu2.backbone_elements.questionnairequestion import (
            QuestionnaireQuestionSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("QuestionnaireGroup") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["QuestionnaireGroup"]
        schema = StructType(
            [
                # None
                StructField(
                    "id",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element, and that modifies the understanding of the element
                # that contains it. Usually modifier elements provide negation or qualification.
                # In order to make the use of extensions safe and manageable, there is a strict
                # set of governance applied to the definition and use of extensions. Though any
                # implementer is allowed to define an extension, there is a set of requirements
                # that SHALL be met as part of the definition of the extension. Applications
                # processing a resource are required to check for modifier extensions.
                StructField(
                    "modifierExtension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # An identifier that is unique within the Questionnaire allowing linkage to the
                # equivalent group in a QuestionnaireResponse resource.
                StructField("linkId", StringType(), True),
                # The human-readable name for this section of the questionnaire.
                StructField("title", StringType(), True),
                # Identifies a how this group of questions is known in a particular terminology
                # such as LOINC.
                StructField(
                    "concept",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Additional text for the group, used for display purposes.
                StructField("text", StringType(), True),
                # If true, indicates that the group must be present and have required questions
                # within it answered.  If false, the group may be skipped when answering the
                # questionnaire.
                StructField("required", BooleanType(), True),
                # Whether the group may occur multiple times in the instance, containing
                # multiple sets of answers.
                StructField("repeats", BooleanType(), True),
                # A sub-group within a group. The ordering of groups within this group is
                # relevant.
                StructField(
                    "group",
                    QuestionnaireGroupSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Set of questions within this group. The order of questions within the group is
                # relevant.
                StructField(
                    "question",
                    QuestionnaireQuestionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
