from typing import Union, List, Optional

from pyspark.sql.types import StructType, StructField, StringType, BooleanType, DataType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ElementDefinitionSlicingSchema:
    """
    Captures constraints on each element within the resource, profile, or
    extension.
    If the element is present, it must have a value for at least one of the
    defined elements, an @id referenced from the Narrative, or extensions
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        Captures constraints on each element within the resource, profile, or
        extension.
        If the element is present, it must have a value for at least one of the
        defined elements, an @id referenced from the Narrative, or extensions


            id: None
            extension: May be used to represent additional information that is not part of the basic
        definition of the element. In order to make the use of extensions safe and
        manageable, there is a strict set of governance  applied to the definition and
        use of extensions. Though any implementer is allowed to define an extension,
        there is a set of requirements that SHALL be met as part of the definition of
        the extension.
            discriminator: Designates which child elements are used to discriminate between the slices
        when processing an instance. If one or more discriminators are provided, the
        value of the child elements in the instance data SHALL completely distinguish
        which slice the element in the resource matches based on the allowed values
        for those elements in each of the slices.
            description: A human-readable text description of how the slicing works. If there is no
        discriminator, this is required to be present to provide whatever information
        is possible about how the slices can be differentiated.
            ordered: If the matching elements have to occur in the same order as defined in the
        profile.
            rules: Whether additional slices are allowed or not. When the slices are ordered,
        profile authors can also say that additional slices are only allowed at the
        end.
        """
        # id
        from spark_fhir_schemas.dstu2.simple_types.id import idSchema

        # extension
        from spark_fhir_schemas.dstu2.complex_types.extension import ExtensionSchema

        # rules
        # type = code
        if (
            max_recursion_limit
            and nesting_list.count("ElementDefinitionSlicing") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ElementDefinitionSlicing"]
        schema = StructType(
            [
                # None
                StructField(
                    "id",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Designates which child elements are used to discriminate between the slices
                # when processing an instance. If one or more discriminators are provided, the
                # value of the child elements in the instance data SHALL completely distinguish
                # which slice the element in the resource matches based on the allowed values
                # for those elements in each of the slices.
                StructField("discriminator", StringType(), True),
                # A human-readable text description of how the slicing works. If there is no
                # discriminator, this is required to be present to provide whatever information
                # is possible about how the slices can be differentiated.
                StructField("description", StringType(), True),
                # If the matching elements have to occur in the same order as defined in the
                # profile.
                StructField("ordered", BooleanType(), True),
                # Whether additional slices are allowed or not. When the slices are ordered,
                # profile authors can also say that additional slices are only allowed at the
                # end.
                StructField("rules", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
