from typing import Union, List, Optional

from pyspark.sql.types import StructType, StructField, StringType, DataType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ConformanceSearchParamSchema:
    """
    A conformance statement is a set of capabilities of a FHIR Server that may be
    used as a statement of actual server functionality or a statement of required
    or desired server implementation.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        A conformance statement is a set of capabilities of a FHIR Server that may be
        used as a statement of actual server functionality or a statement of required
        or desired server implementation.


            id: None
            extension: May be used to represent additional information that is not part of the basic
        definition of the element. In order to make the use of extensions safe and
        manageable, there is a strict set of governance  applied to the definition and
        use of extensions. Though any implementer is allowed to define an extension,
        there is a set of requirements that SHALL be met as part of the definition of
        the extension.
            modifierExtension: May be used to represent additional information that is not part of the basic
        definition of the element, and that modifies the understanding of the element
        that contains it. Usually modifier elements provide negation or qualification.
        In order to make the use of extensions safe and manageable, there is a strict
        set of governance applied to the definition and use of extensions. Though any
        implementer is allowed to define an extension, there is a set of requirements
        that SHALL be met as part of the definition of the extension. Applications
        processing a resource are required to check for modifier extensions.
            name: The name of the search parameter used in the interface.
            definition: An absolute URI that is a formal reference to where this parameter was first
        defined, so that a client can be confident of the meaning of the search
        parameter (a reference to [[[SearchParameter.url]]]).
            type: The type of value a search parameter refers to, and how the content is
        interpreted.
            documentation: This allows documentation of any distinct behaviors about how the search
        parameter is used.  For example, text matching algorithms.
            target: Types of resource (if a resource is referenced).
            modifier: A modifier supported for the search parameter.
            chain: Contains the names of any search parameters which may be chained to the
        containing search parameter. Chained parameters may be added to search
        parameters of type reference, and specify that resources will only be returned
        if they contain a reference to a resource which matches the chained parameter
        value. Values for this field should be drawn from
        Conformance.rest.resource.searchParam.name on the target resource type.
        """
        # id
        from spark_fhir_schemas.dstu2.simple_types.id import idSchema

        # extension
        from spark_fhir_schemas.dstu2.complex_types.extension import ExtensionSchema

        # definition
        from spark_fhir_schemas.dstu2.simple_types.uri import uriSchema

        # type
        # type = code
        if (
            max_recursion_limit
            and nesting_list.count("ConformanceSearchParam") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ConformanceSearchParam"]
        schema = StructType(
            [
                # None
                StructField(
                    "id",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element, and that modifies the understanding of the element
                # that contains it. Usually modifier elements provide negation or qualification.
                # In order to make the use of extensions safe and manageable, there is a strict
                # set of governance applied to the definition and use of extensions. Though any
                # implementer is allowed to define an extension, there is a set of requirements
                # that SHALL be met as part of the definition of the extension. Applications
                # processing a resource are required to check for modifier extensions.
                StructField(
                    "modifierExtension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The name of the search parameter used in the interface.
                StructField("name", StringType(), True),
                # An absolute URI that is a formal reference to where this parameter was first
                # defined, so that a client can be confident of the meaning of the search
                # parameter (a reference to [[[SearchParameter.url]]]).
                StructField(
                    "definition",
                    uriSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The type of value a search parameter refers to, and how the content is
                # interpreted.
                StructField("type", StringType(), True),
                # This allows documentation of any distinct behaviors about how the search
                # parameter is used.  For example, text matching algorithms.
                StructField("documentation", StringType(), True),
                # Types of resource (if a resource is referenced).
                StructField("target", StringType(), True),
                # A modifier supported for the search parameter.
                StructField("modifier", StringType(), True),
                # Contains the names of any search parameters which may be chained to the
                # containing search parameter. Chained parameters may be added to search
                # parameters of type reference, and specify that resources will only be returned
                # if they contain a reference to a resource which matches the chained parameter
                # value. Values for this field should be drawn from
                # Conformance.rest.resource.searchParam.name on the target resource type.
                StructField("chain", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
