from typing import Union, List, Optional

from pyspark.sql.types import StructType, StructField, StringType, DataType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ConformanceRestSchema:
    """
    A conformance statement is a set of capabilities of a FHIR Server that may be
    used as a statement of actual server functionality or a statement of required
    or desired server implementation.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        A conformance statement is a set of capabilities of a FHIR Server that may be
        used as a statement of actual server functionality or a statement of required
        or desired server implementation.


            id: None
            extension: May be used to represent additional information that is not part of the basic
        definition of the element. In order to make the use of extensions safe and
        manageable, there is a strict set of governance  applied to the definition and
        use of extensions. Though any implementer is allowed to define an extension,
        there is a set of requirements that SHALL be met as part of the definition of
        the extension.
            modifierExtension: May be used to represent additional information that is not part of the basic
        definition of the element, and that modifies the understanding of the element
        that contains it. Usually modifier elements provide negation or qualification.
        In order to make the use of extensions safe and manageable, there is a strict
        set of governance applied to the definition and use of extensions. Though any
        implementer is allowed to define an extension, there is a set of requirements
        that SHALL be met as part of the definition of the extension. Applications
        processing a resource are required to check for modifier extensions.
            mode: Identifies whether this portion of the statement is describing ability to
        initiate or receive restful operations.
            documentation: Information about the system's restful capabilities that apply across all
        applications, such as security.
            security: Information about security implementation from an interface perspective - what
        a client needs to know.
            resource: A specification of the restful capabilities of the solution for a specific
        resource type.
            interaction: A specification of restful operations supported by the system.
            transactionMode: A code that indicates how transactions are supported.
            searchParam: Search parameters that are supported for searching all resources for
        implementations to support and/or make use of - either references to ones
        defined in the specification, or additional ones defined for/by the
        implementation.
            operation: Definition of an operation or a named query and with its parameters and their
        meaning and type.
            compartment: An absolute URI which is a reference to the definition of a compartment hosted
        by the system.
        """
        # id
        from spark_fhir_schemas.dstu2.simple_types.id import idSchema

        # extension
        from spark_fhir_schemas.dstu2.complex_types.extension import ExtensionSchema

        # mode
        # type = code
        # security
        from spark_fhir_schemas.dstu2.backbone_elements.conformancesecurity import (
            ConformanceSecuritySchema,
        )

        # resource
        from spark_fhir_schemas.dstu2.backbone_elements.conformanceresource import (
            ConformanceResourceSchema,
        )

        # interaction
        from spark_fhir_schemas.dstu2.backbone_elements.conformanceinteraction1 import (
            ConformanceInteraction1Schema,
        )

        # searchParam
        from spark_fhir_schemas.dstu2.backbone_elements.conformancesearchparam import (
            ConformanceSearchParamSchema,
        )

        # operation
        from spark_fhir_schemas.dstu2.backbone_elements.conformanceoperation import (
            ConformanceOperationSchema,
        )

        # compartment
        from spark_fhir_schemas.dstu2.simple_types.uri import uriSchema

        if (
            max_recursion_limit
            and nesting_list.count("ConformanceRest") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ConformanceRest"]
        schema = StructType(
            [
                # None
                StructField(
                    "id",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element, and that modifies the understanding of the element
                # that contains it. Usually modifier elements provide negation or qualification.
                # In order to make the use of extensions safe and manageable, there is a strict
                # set of governance applied to the definition and use of extensions. Though any
                # implementer is allowed to define an extension, there is a set of requirements
                # that SHALL be met as part of the definition of the extension. Applications
                # processing a resource are required to check for modifier extensions.
                StructField(
                    "modifierExtension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Identifies whether this portion of the statement is describing ability to
                # initiate or receive restful operations.
                StructField("mode", StringType(), True),
                # Information about the system's restful capabilities that apply across all
                # applications, such as security.
                StructField("documentation", StringType(), True),
                # Information about security implementation from an interface perspective - what
                # a client needs to know.
                StructField(
                    "security",
                    ConformanceSecuritySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A specification of the restful capabilities of the solution for a specific
                # resource type.
                StructField(
                    "resource",
                    ConformanceResourceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A specification of restful operations supported by the system.
                StructField(
                    "interaction",
                    ConformanceInteraction1Schema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A code that indicates how transactions are supported.
                StructField("transactionMode", StringType(), True),
                # Search parameters that are supported for searching all resources for
                # implementations to support and/or make use of - either references to ones
                # defined in the specification, or additional ones defined for/by the
                # implementation.
                StructField(
                    "searchParam",
                    ConformanceSearchParamSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Definition of an operation or a named query and with its parameters and their
                # meaning and type.
                StructField(
                    "operation",
                    ConformanceOperationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # An absolute URI which is a reference to the definition of a compartment hosted
                # by the system.
                StructField(
                    "compartment",
                    uriSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
