# This code is part of Qiskit.
#
# (C) Copyright IBM 2017, 2018.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.
# Copyright 2021 Dell (www.dell.com)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


import os

from setuptools import find_packages, setup

here = os.path.dirname(os.path.realpath(__file__))
readme_path = os.path.join(here, "README.md")
requirements_path = os.path.join(here, "requirements.txt")
test_requirements_path = os.path.join(here, "requirements-test.txt")
with open(readme_path, "r") as _fp:
    long_description = _fp.read()

with open(requirements_path) as _fp:
    REQUIREMENTS = _fp.readlines()

with open(test_requirements_path) as _fp:
    TEST_REQUIREMENTS = _fp.readlines()

setup(
    name="qiskit-dell-runtime",
    version="0.1.2",
    author="DellTechnologies",
    author_email="v.fong@dell.com",
    url="https://github.com/Qiskit-Partners/qiskit-dell-runtime/",
    packages=find_packages(exclude=["*test*"]),
    description="Dell provider for Qiskit Runtime backends",
    long_description=long_description,
    long_description_content_type="text/markdown",
    license="Apache 2.0",
    classifiers=[
        "Environment :: Console",
        "License :: OSI Approved :: Apache Software License",
        "Intended Audience :: Developers",
        "Intended Audience :: Science/Research",
        "Operating System :: Microsoft :: Windows",
        "Operating System :: MacOS",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Topic :: Scientific/Engineering",
    ],
    keywords="qiskit sdk quantum",
    python_requires=">=3.7",
    setup_requires=["pytest-runner"],
    install_requires=REQUIREMENTS,
    tests_require=TEST_REQUIREMENTS,
    zip_safe=False,
    include_package_data=True,
)
