"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Semver = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
/**
 * @deprecated This class will be removed in upcoming releases. if you wish to
 * specify semver requirements in `deps`, `devDeps`, etc, specify them like so
 * `express@^2.1`.
 */
class Semver {
    constructor(spec) {
        this.spec = spec;
    }
    static of(spec) {
        return new Semver(spec);
    }
    /**
     * Latest version.
     */
    static latest() {
        return new Semver("*");
    }
    /**
     * Accept only an exact version
     */
    static pinned(version) {
        return new Semver(version);
    }
    /**
     * Accept any minor version.
     *
     * >= version
     * < next major version
     */
    static caret(version) {
        return new Semver(`^${version}`);
    }
    /**
     * Accept patches.
     *
     * >= version
     * < next minor version
     */
    static tilde(version) {
        return new Semver(`~${version}`);
    }
    get version() {
        return semver.minVersion(this.spec)?.version;
    }
}
exports.Semver = Semver;
_a = JSII_RTTI_SYMBOL_1;
Semver[_a] = { fqn: "projen.Semver", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,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