"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Setuptools = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const setuppy_1 = require("./setuppy");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
/**
 * Manages packaging through setuptools with a setup.py script.
 */
class Setuptools extends component_1.Component {
    constructor(project, 
    //moduleName: string,
    options) {
        super(project);
        project.deps.addDependency("wheel@0.36.2", dependencies_1.DependencyType.DEVENV);
        project.deps.addDependency("twine@3.3.0", dependencies_1.DependencyType.DEVENV);
        project.packageTask.exec("python setup.py sdist bdist_wheel");
        this.publishTestTask = project.addTask("publish:test", {
            description: "Uploads the package against a test PyPI endpoint.",
            exec: "twine upload --repository-url https://test.pypi.org/legacy/ dist/*",
        });
        this.publishTask = project.addTask("publish", {
            description: "Uploads the package against a test PyPI endpoint.",
            exec: "twine upload dist/*",
        });
        const packages = options.packageName ? [options.packageName] : undefined;
        new setuppy_1.SetupPy(project, {
            name: project.name,
            packages: packages,
            authorName: options.authorName,
            authorEmail: options.authorEmail,
            version: options.version,
            description: options.description,
            license: options.license,
            homepage: options.homepage,
            classifiers: options.classifiers,
            ...options.setupConfig,
        });
    }
}
exports.Setuptools = Setuptools;
_a = JSII_RTTI_SYMBOL_1;
Setuptools[_a] = { fqn: "projen.python.Setuptools", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,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