import { GitHub } from ".";
import { Component } from "../component";
/**
 * Options for PullRequestLint
 */
export interface PullRequestLintOptions {
    /**
     * Validate that pull request titles follow Conventional Commits.
     *
     * @default true
     * @see https://www.conventionalcommits.org/
     */
    readonly semanticTitle?: boolean;
    /**
     * Options for validating the conventional commit title linter.
     * @default - title must start with "feat", "fix", or "chore"
     */
    readonly semanticTitleOptions?: SemanticTitleOptions;
    /**
     * Github Runner selection labels
     * @default ["ubuntu-latest"]
     */
    readonly runsOn?: string[];
}
/**
 * Options for linting that PR titles follow Conventional Commits.
 * @see https://www.conventionalcommits.org/
 */
export interface SemanticTitleOptions {
    /**
     * Configure a list of commit types that are allowed.
     * @default ["feat", "fix", "chore"]
     */
    readonly types?: string[];
    /**
     * Configure that a scope must always be provided.
     * e.g. feat(ui), fix(core)
     * @default false
     */
    readonly requireScope?: boolean;
}
/**
 * Configure validations to run on GitHub pull requests.
 * Only generates a file if at least one linter is configured.
 */
export declare class PullRequestLint extends Component {
    constructor(github: GitHub, options?: PullRequestLintOptions);
}
