import { GitHub } from "./github";
import { Component } from "../component";
export interface AutoMergeOptions {
    /**
     * Number of approved code reviews.
     * @default 1
     */
    readonly approvedReviews?: number;
    /**
     * List of labels that will prevent auto-merging.
     * @default ['do-not-merge']
     */
    readonly blockingLabels?: string[];
}
/**
 * Sets up mergify to merging approved pull requests.
 *
 * If `buildJob` is specified, the specified GitHub workflow job ID is required
 * to succeed in order for the PR to be merged.
 *
 * `approvedReviews` specified the number of code review approvals required for
 * the PR to be merged.
 */
export declare class AutoMerge extends Component {
    private readonly lazyConditions;
    constructor(github: GitHub, options?: AutoMergeOptions);
    /**
     * Adds conditions to the auto merge rule.
     * @param conditions The conditions to add (mergify syntax)
     */
    addConditions(...conditions: string[]): void;
    /**
     * Adds conditions that will be rendered only during synthesis.
     * @param later The later
     */
    addConditionsLater(later: IAddConditionsLater): void;
    private renderConditions;
}
export interface IAddConditionsLater {
    render(): string[];
}
