import * as spec from '@jsii/spec';
import * as ts from 'typescript';
export declare type TSCompilerOptions = Partial<Pick<ts.CompilerOptions, 'outDir' | 'rootDir' | 'baseUrl' | 'paths' | 'forceConsistentCasingInFileNames' | 'declarationMap' | 'inlineSourceMap' | 'inlineSources' | 'sourceMap' | 'types'>>;
export interface ProjectInfo {
    readonly projectRoot: string;
    readonly packageJson: any;
    readonly name: string;
    readonly version: string;
    readonly author: spec.Person;
    readonly deprecated?: string;
    readonly stability?: spec.Stability;
    readonly license: string;
    readonly repository: {
        readonly type: string;
        readonly url: string;
        readonly directory?: string;
    };
    readonly keywords?: string[];
    readonly main: string;
    readonly types: string;
    readonly dependencies: {
        readonly [name: string]: string;
    };
    readonly peerDependencies: {
        readonly [name: string]: string;
    };
    readonly dependencyClosure: readonly spec.Assembly[];
    readonly bundleDependencies?: {
        readonly [name: string]: string;
    };
    readonly targets: spec.AssemblyTargets;
    readonly metadata?: {
        [key: string]: any;
    };
    readonly jsiiVersionFormat: 'short' | 'full';
    readonly diagnostics?: {
        readonly [code: string]: ts.DiagnosticCategory;
    };
    readonly description?: string;
    readonly homepage?: string;
    readonly contributors?: readonly spec.Person[];
    readonly excludeTypescript: string[];
    readonly projectReferences?: boolean;
    readonly tsc?: TSCompilerOptions;
    readonly bin?: {
        readonly [name: string]: string;
    };
    readonly exports?: {
        readonly [name: string]: string | {
            readonly [name: string]: string;
        };
    };
}
export interface ProjectInfoResult {
    readonly projectInfo: ProjectInfo;
    readonly diagnostics: readonly ts.Diagnostic[];
}
export declare function loadProjectInfo(projectRoot: string): ProjectInfoResult;
//# sourceMappingURL=project-info.d.ts.map