export interface IReflectable {
    readonly entries: ReflectableEntry[];
}
export interface ReflectableEntry {
    readonly key: string;
    readonly value: unknown;
}
export declare class Reflector {
    asMap(reflectable: IReflectable): Record<string, unknown>;
}
/**
 * This class is here to show we can use nested classes across module boundaries.
 */
export declare class NestingClass {
    private constructor();
}
export declare namespace NestingClass {
    /**
     * This class is here to show we can use nested classes across module boundaries.
     */
    class NestedClass {
        readonly property: string;
    }
    /**
     * This is a struct, nested within a class. Normal.
     */
    interface NestedStruct {
        readonly name: string;
    }
}
