"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.classifyDiagnostics = exports.hasErrors = exports.formatDiagnostic = exports.DiagLevel = void 0;
const spec_1 = require("@jsii/spec");
var DiagLevel;
(function (DiagLevel) {
    DiagLevel[DiagLevel["Error"] = 0] = "Error";
    DiagLevel[DiagLevel["Warning"] = 1] = "Warning";
    DiagLevel[DiagLevel["Skipped"] = 2] = "Skipped";
})(DiagLevel = exports.DiagLevel || (exports.DiagLevel = {}));
const LEVEL_PREFIX = {
    [DiagLevel.Error]: 'err ',
    [DiagLevel.Warning]: 'warn',
    [DiagLevel.Skipped]: 'skip',
};
function formatDiagnostic(diag, includeSuppressionKey = false) {
    return [
        LEVEL_PREFIX[diag.level],
        '-',
        diag.message,
        ...(includeSuppressionKey ? [`[${diag.suppressionKey}]`] : []),
    ].join(' ');
}
exports.formatDiagnostic = formatDiagnostic;
function hasErrors(diags) {
    return diags.some((diag) => diag.level === DiagLevel.Error);
}
exports.hasErrors = hasErrors;
/**
 * Classify API mismatches into a set of warnings and errors
 */
function classifyDiagnostics(mismatches, experimentalErrors, skipFilter) {
    const ret = mismatches.mismatches.map((mis) => ({
        level: level(mis),
        message: mis.message,
        suppressionKey: mis.violationKey,
    }));
    ret.sort((a, b) => a.level - b.level);
    return ret;
    function level(mis) {
        if (skipFilter.has(mis.violationKey)) {
            return DiagLevel.Skipped;
        }
        if (mis.stability === spec_1.Stability.Stable ||
            (mis.stability === spec_1.Stability.Experimental && experimentalErrors)) {
            return DiagLevel.Error;
        }
        return DiagLevel.Warning;
    }
}
exports.classifyDiagnostics = classifyDiagnostics;
//# sourceMappingURL=diagnostics.js.map