"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_autoscaling_1 = require("aws-cdk-lib/aws-autoscaling");
const nag_rules_1 = require("../../nag-rules");
/**
 * Auto Scaling Groups have notifications for all scaling events configured
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        if (node.notificationConfigurations == undefined) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        const notificationConfigurations = aws_cdk_lib_1.Stack.of(node).resolve(node.notificationConfigurations);
        const requiredEvents = [
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH,
            aws_autoscaling_1.ScalingEvent.INSTANCE_LAUNCH_ERROR,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE,
            aws_autoscaling_1.ScalingEvent.INSTANCE_TERMINATE_ERROR,
        ];
        const compliant = requiredEvents.every((req) => {
            return notificationConfigurations.some((config) => {
                return config.notificationTypes?.includes(req);
            });
        });
        if (compliant !== true) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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