"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SimpleSynthAction=void 0;const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),crypto=require("crypto"),path=require("path"),codebuild=require("../../../../aws-codebuild"),codepipeline=require("../../../../aws-codepipeline"),codepipeline_actions=require("../../../../aws-codepipeline-actions"),ec2=require("../../../../aws-ec2"),core_1=require("../../../../core"),_util_1=require("./_util"),docker_credentials_1=require("../../docker-credentials"),default_codebuild_image_1=require("../../private/default-codebuild-image"),fs_1=require("../../private/fs"),DEFAULT_OUTPUT_DIR="cdk.out";class SimpleSynthAction{constructor(props){if(this.props=props,this._actionProperties={actionName:props.actionName??"Synth",category:codepipeline.ActionCategory.BUILD,provider:"CodeBuild",artifactBounds:{minInputs:0,maxInputs:5,minOutputs:0,maxOutputs:5},inputs:[props.sourceArtifact],outputs:[props.cloudAssemblyArtifact,...(props.additionalArtifacts??[]).map(a=>a.artifact)]},this.props.installCommand&&this.props.installCommands)throw new Error("Pass either 'installCommand' or 'installCommands', but not both");if(this.props.buildCommand&&this.props.buildCommands)throw new Error("Pass either 'buildCommand' or 'buildCommands', but not both");const addls=props.additionalArtifacts??[];if(Object.keys(addls).length>0){if(!props.cloudAssemblyArtifact.artifactName)throw new Error("You must give all output artifacts, including the 'cloudAssemblyArtifact', names when using 'additionalArtifacts'");for(const addl of addls)if(!addl.artifact.artifactName)throw new Error("You must give all output artifacts passed to SimpleSynthAction names when using 'additionalArtifacts'")}}static standardNpmSynth(options){return new SimpleSynthAction({...options,installCommand:options.installCommand??"npm ci",synthCommand:options.synthCommand??"npx cdk synth",vpc:options.vpc,subnetSelection:options.subnetSelection,environment:{...options.environment,environmentVariables:{NPM_CONFIG_UNSAFE_PERM:{value:"true"},...options.environment?.environmentVariables}}})}static standardYarnSynth(options){return new SimpleSynthAction({...options,installCommand:options.installCommand??"yarn install --frozen-lockfile",synthCommand:options.synthCommand??"npx cdk synth",vpc:options.vpc,subnetSelection:options.subnetSelection,environment:{...options.environment,environmentVariables:{NPM_CONFIG_UNSAFE_PERM:{value:"true"},...options.environment?.environmentVariables}}})}get actionProperties(){return this._actionProperties}get project(){if(!this._project)throw new Error("Project becomes available after SimpleSynthAction has been bound to a stage");return this._project}bind(scope,stage,options){const buildCommands=this.props.buildCommands??[this.props.buildCommand],installCommands=this.props.installCommands??[this.props.installCommand],testCommands=this.props.testCommands??[],synthCommand=this.props.synthCommand,environment={buildImage:default_codebuild_image_1.CDKP_DEFAULT_CODEBUILD_IMAGE,...this.props.environment},osType=environment.buildImage instanceof codebuild.WindowsBuildImage?ec2.OperatingSystemType.WINDOWS:ec2.OperatingSystemType.LINUX,buildSpec=codebuild.BuildSpec.fromObject({version:"0.2",phases:{pre_build:{commands:_util_1.filterEmpty([this.props.subdirectory?`cd ${this.props.subdirectory}`:"",...installCommands,...docker_credentials_1.dockerCredentialsInstallCommands(docker_credentials_1.DockerCredentialUsage.SYNTH,this._dockerCredentials,osType)])},build:{commands:_util_1.filterEmpty([...buildCommands,...testCommands,synthCommand])}},artifacts:renderArtifacts(this)}),environmentVariables={..._util_1.copyEnvironmentVariables(...this.props.copyEnvironmentVariables||[])},mergedBuildSpec=this.props.buildSpec?codebuild.mergeBuildSpecs(this.props.buildSpec,buildSpec):buildSpec,projectConfigHash=hash(core_1.Stack.of(scope).resolve({environment:serializeBuildEnvironment(environment),buildSpecString:mergedBuildSpec.toBuildSpec(),environmentVariables})),project=new codebuild.PipelineProject(scope,"CdkBuildProject",{projectName:this.props.projectName,environment,vpc:this.props.vpc,subnetSelection:this.props.subnetSelection,buildSpec:mergedBuildSpec,environmentVariables});return this.props.rolePolicyStatements!==void 0&&this.props.rolePolicyStatements.forEach(policyStatement=>{project.addToRolePolicy(policyStatement)}),this._project=project,this._dockerCredentials?.forEach(reg=>reg.grantRead(project.grantPrincipal,docker_credentials_1.DockerCredentialUsage.SYNTH)),this._action=new codepipeline_actions.CodeBuildAction({actionName:this.actionProperties.actionName,input:this.props.sourceArtifact,outputs:[this.props.cloudAssemblyArtifact,...(this.props.additionalArtifacts??[]).map(a=>a.artifact)],environmentVariables:{...this.props.environmentVariables,_PROJECT_CONFIG_HASH:{value:projectConfigHash}},project}),this._actionProperties=this._action.actionProperties,this._action.bind(scope,stage,options);function renderArtifacts(self){const cloudAsmArtifactSpec={"base-directory":fs_1.toPosixPath(path.join(self.props.subdirectory??".",DEFAULT_OUTPUT_DIR)),files:"**/*"};if(self.props.additionalArtifacts){const secondary={};if(!self.props.cloudAssemblyArtifact.artifactName)throw new Error("When using additional output artifacts, you must also name the CloudAssembly artifact");return secondary[self.props.cloudAssemblyArtifact.artifactName]=cloudAsmArtifactSpec,self.props.additionalArtifacts.forEach(art=>{if(!art.artifact.artifactName)throw new Error("You must give the output artifact a name");secondary[art.artifact.artifactName]={"base-directory":fs_1.toPosixPath(path.join(self.props.subdirectory??".",art.directory)),files:"**/*"}}),{"secondary-artifacts":secondary}}return cloudAsmArtifactSpec}}get grantPrincipal(){return this.project.grantPrincipal}onStateChange(name,target,options){if(!this._action)throw new Error("Need bind() first");return this._action.onStateChange(name,target,options)}_addDockerCredentials(dockerCredentials){this._dockerCredentials=dockerCredentials}}exports.SimpleSynthAction=SimpleSynthAction,_a=JSII_RTTI_SYMBOL_1,SimpleSynthAction[_a]={fqn:"aws-cdk-lib.pipelines.SimpleSynthAction",version:"2.69.0"};function hash(obj){const d=crypto.createHash("sha256");return d.update(JSON.stringify(obj)),d.digest("hex")}function serializeBuildEnvironment(env){return{privileged:env.privileged,environmentVariables:env.environmentVariables,type:env.buildImage?.type,imageId:env.buildImage?.imageId,computeType:env.computeType,imagePullPrincipalType:env.buildImage?.imagePullPrincipalType,secretsManagerArn:env.buildImage?.secretsManagerCredentials?.secretArn}}
