"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnTable=exports.CfnScheduledQuery=exports.CfnDatabase=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnDatabasePropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("databaseName",cdk.validateString)(properties.databaseName)),errors.collect(cdk.propertyValidator("kmsKeyId",cdk.validateString)(properties.kmsKeyId)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnDatabaseProps"')}function cfnDatabasePropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatabasePropsValidator(properties).assertSuccess(),{DatabaseName:cdk.stringToCloudFormation(properties.databaseName),KmsKeyId:cdk.stringToCloudFormation(properties.kmsKeyId),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnDatabasePropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("databaseName","DatabaseName",properties.DatabaseName!=null?cfn_parse.FromCloudFormation.getString(properties.DatabaseName):void 0),ret.addPropertyResult("kmsKeyId","KmsKeyId",properties.KmsKeyId!=null?cfn_parse.FromCloudFormation.getString(properties.KmsKeyId):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnDatabase extends cdk.CfnResource{constructor(scope,id,props={}){super(scope,id,{type:CfnDatabase.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_timestream_CfnDatabaseProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnDatabase),error}this.attrArn=cdk.Token.asString(this.getAtt("Arn",cdk.ResolutionTypeHint.STRING)),this.databaseName=props.databaseName,this.kmsKeyId=props.kmsKeyId,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::Timestream::Database",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnDatabasePropsFromCloudFormation(resourceProperties),ret=new CfnDatabase(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnDatabase.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{databaseName:this.databaseName,kmsKeyId:this.kmsKeyId,tags:this.tags.renderTags()}}renderProperties(props){return cfnDatabasePropsToCloudFormation(props)}}exports.CfnDatabase=CfnDatabase,_a=JSII_RTTI_SYMBOL_1,CfnDatabase[_a]={fqn:"aws-cdk-lib.aws_timestream.CfnDatabase",version:"2.69.0"},CfnDatabase.CFN_RESOURCE_TYPE_NAME="AWS::Timestream::Database";function CfnScheduledQueryPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("clientToken",cdk.validateString)(properties.clientToken)),errors.collect(cdk.propertyValidator("errorReportConfiguration",cdk.requiredValidator)(properties.errorReportConfiguration)),errors.collect(cdk.propertyValidator("errorReportConfiguration",CfnScheduledQuery_ErrorReportConfigurationPropertyValidator)(properties.errorReportConfiguration)),errors.collect(cdk.propertyValidator("kmsKeyId",cdk.validateString)(properties.kmsKeyId)),errors.collect(cdk.propertyValidator("notificationConfiguration",cdk.requiredValidator)(properties.notificationConfiguration)),errors.collect(cdk.propertyValidator("notificationConfiguration",CfnScheduledQuery_NotificationConfigurationPropertyValidator)(properties.notificationConfiguration)),errors.collect(cdk.propertyValidator("queryString",cdk.requiredValidator)(properties.queryString)),errors.collect(cdk.propertyValidator("queryString",cdk.validateString)(properties.queryString)),errors.collect(cdk.propertyValidator("scheduleConfiguration",cdk.requiredValidator)(properties.scheduleConfiguration)),errors.collect(cdk.propertyValidator("scheduleConfiguration",CfnScheduledQuery_ScheduleConfigurationPropertyValidator)(properties.scheduleConfiguration)),errors.collect(cdk.propertyValidator("scheduledQueryExecutionRoleArn",cdk.requiredValidator)(properties.scheduledQueryExecutionRoleArn)),errors.collect(cdk.propertyValidator("scheduledQueryExecutionRoleArn",cdk.validateString)(properties.scheduledQueryExecutionRoleArn)),errors.collect(cdk.propertyValidator("scheduledQueryName",cdk.validateString)(properties.scheduledQueryName)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("targetConfiguration",CfnScheduledQuery_TargetConfigurationPropertyValidator)(properties.targetConfiguration)),errors.wrap('supplied properties not correct for "CfnScheduledQueryProps"')}function cfnScheduledQueryPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQueryPropsValidator(properties).assertSuccess(),{ErrorReportConfiguration:cfnScheduledQueryErrorReportConfigurationPropertyToCloudFormation(properties.errorReportConfiguration),NotificationConfiguration:cfnScheduledQueryNotificationConfigurationPropertyToCloudFormation(properties.notificationConfiguration),QueryString:cdk.stringToCloudFormation(properties.queryString),ScheduleConfiguration:cfnScheduledQueryScheduleConfigurationPropertyToCloudFormation(properties.scheduleConfiguration),ScheduledQueryExecutionRoleArn:cdk.stringToCloudFormation(properties.scheduledQueryExecutionRoleArn),ClientToken:cdk.stringToCloudFormation(properties.clientToken),KmsKeyId:cdk.stringToCloudFormation(properties.kmsKeyId),ScheduledQueryName:cdk.stringToCloudFormation(properties.scheduledQueryName),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),TargetConfiguration:cfnScheduledQueryTargetConfigurationPropertyToCloudFormation(properties.targetConfiguration)}):properties}function CfnScheduledQueryPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("errorReportConfiguration","ErrorReportConfiguration",CfnScheduledQueryErrorReportConfigurationPropertyFromCloudFormation(properties.ErrorReportConfiguration)),ret.addPropertyResult("notificationConfiguration","NotificationConfiguration",CfnScheduledQueryNotificationConfigurationPropertyFromCloudFormation(properties.NotificationConfiguration)),ret.addPropertyResult("queryString","QueryString",cfn_parse.FromCloudFormation.getString(properties.QueryString)),ret.addPropertyResult("scheduleConfiguration","ScheduleConfiguration",CfnScheduledQueryScheduleConfigurationPropertyFromCloudFormation(properties.ScheduleConfiguration)),ret.addPropertyResult("scheduledQueryExecutionRoleArn","ScheduledQueryExecutionRoleArn",cfn_parse.FromCloudFormation.getString(properties.ScheduledQueryExecutionRoleArn)),ret.addPropertyResult("clientToken","ClientToken",properties.ClientToken!=null?cfn_parse.FromCloudFormation.getString(properties.ClientToken):void 0),ret.addPropertyResult("kmsKeyId","KmsKeyId",properties.KmsKeyId!=null?cfn_parse.FromCloudFormation.getString(properties.KmsKeyId):void 0),ret.addPropertyResult("scheduledQueryName","ScheduledQueryName",properties.ScheduledQueryName!=null?cfn_parse.FromCloudFormation.getString(properties.ScheduledQueryName):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addPropertyResult("targetConfiguration","TargetConfiguration",properties.TargetConfiguration!=null?CfnScheduledQueryTargetConfigurationPropertyFromCloudFormation(properties.TargetConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnScheduledQuery extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnScheduledQuery.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_timestream_CfnScheduledQueryProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnScheduledQuery),error}cdk.requireProperty(props,"errorReportConfiguration",this),cdk.requireProperty(props,"notificationConfiguration",this),cdk.requireProperty(props,"queryString",this),cdk.requireProperty(props,"scheduleConfiguration",this),cdk.requireProperty(props,"scheduledQueryExecutionRoleArn",this),this.attrArn=cdk.Token.asString(this.getAtt("Arn",cdk.ResolutionTypeHint.STRING)),this.attrSqErrorReportConfiguration=cdk.Token.asString(this.getAtt("SQErrorReportConfiguration",cdk.ResolutionTypeHint.STRING)),this.attrSqKmsKeyId=cdk.Token.asString(this.getAtt("SQKmsKeyId",cdk.ResolutionTypeHint.STRING)),this.attrSqName=cdk.Token.asString(this.getAtt("SQName",cdk.ResolutionTypeHint.STRING)),this.attrSqNotificationConfiguration=cdk.Token.asString(this.getAtt("SQNotificationConfiguration",cdk.ResolutionTypeHint.STRING)),this.attrSqQueryString=cdk.Token.asString(this.getAtt("SQQueryString",cdk.ResolutionTypeHint.STRING)),this.attrSqScheduleConfiguration=cdk.Token.asString(this.getAtt("SQScheduleConfiguration",cdk.ResolutionTypeHint.STRING)),this.attrSqScheduledQueryExecutionRoleArn=cdk.Token.asString(this.getAtt("SQScheduledQueryExecutionRoleArn",cdk.ResolutionTypeHint.STRING)),this.attrSqTargetConfiguration=cdk.Token.asString(this.getAtt("SQTargetConfiguration",cdk.ResolutionTypeHint.STRING)),this.errorReportConfiguration=props.errorReportConfiguration,this.notificationConfiguration=props.notificationConfiguration,this.queryString=props.queryString,this.scheduleConfiguration=props.scheduleConfiguration,this.scheduledQueryExecutionRoleArn=props.scheduledQueryExecutionRoleArn,this.clientToken=props.clientToken,this.kmsKeyId=props.kmsKeyId,this.scheduledQueryName=props.scheduledQueryName,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::Timestream::ScheduledQuery",props.tags,{tagPropertyName:"tags"}),this.targetConfiguration=props.targetConfiguration}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnScheduledQueryPropsFromCloudFormation(resourceProperties),ret=new CfnScheduledQuery(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnScheduledQuery.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{errorReportConfiguration:this.errorReportConfiguration,notificationConfiguration:this.notificationConfiguration,queryString:this.queryString,scheduleConfiguration:this.scheduleConfiguration,scheduledQueryExecutionRoleArn:this.scheduledQueryExecutionRoleArn,clientToken:this.clientToken,kmsKeyId:this.kmsKeyId,scheduledQueryName:this.scheduledQueryName,tags:this.tags.renderTags(),targetConfiguration:this.targetConfiguration}}renderProperties(props){return cfnScheduledQueryPropsToCloudFormation(props)}}exports.CfnScheduledQuery=CfnScheduledQuery,_b=JSII_RTTI_SYMBOL_1,CfnScheduledQuery[_b]={fqn:"aws-cdk-lib.aws_timestream.CfnScheduledQuery",version:"2.69.0"},CfnScheduledQuery.CFN_RESOURCE_TYPE_NAME="AWS::Timestream::ScheduledQuery";function CfnScheduledQuery_DimensionMappingPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("dimensionValueType",cdk.requiredValidator)(properties.dimensionValueType)),errors.collect(cdk.propertyValidator("dimensionValueType",cdk.validateString)(properties.dimensionValueType)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.wrap('supplied properties not correct for "DimensionMappingProperty"')}function cfnScheduledQueryDimensionMappingPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_DimensionMappingPropertyValidator(properties).assertSuccess(),{DimensionValueType:cdk.stringToCloudFormation(properties.dimensionValueType),Name:cdk.stringToCloudFormation(properties.name)}):properties}function CfnScheduledQueryDimensionMappingPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("dimensionValueType","DimensionValueType",cfn_parse.FromCloudFormation.getString(properties.DimensionValueType)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_ErrorReportConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("s3Configuration",cdk.requiredValidator)(properties.s3Configuration)),errors.collect(cdk.propertyValidator("s3Configuration",CfnScheduledQuery_S3ConfigurationPropertyValidator)(properties.s3Configuration)),errors.wrap('supplied properties not correct for "ErrorReportConfigurationProperty"')}function cfnScheduledQueryErrorReportConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_ErrorReportConfigurationPropertyValidator(properties).assertSuccess(),{S3Configuration:cfnScheduledQueryS3ConfigurationPropertyToCloudFormation(properties.s3Configuration)}):properties}function CfnScheduledQueryErrorReportConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("s3Configuration","S3Configuration",CfnScheduledQueryS3ConfigurationPropertyFromCloudFormation(properties.S3Configuration)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_MixedMeasureMappingPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("measureName",cdk.validateString)(properties.measureName)),errors.collect(cdk.propertyValidator("measureValueType",cdk.requiredValidator)(properties.measureValueType)),errors.collect(cdk.propertyValidator("measureValueType",cdk.validateString)(properties.measureValueType)),errors.collect(cdk.propertyValidator("multiMeasureAttributeMappings",cdk.listValidator(CfnScheduledQuery_MultiMeasureAttributeMappingPropertyValidator))(properties.multiMeasureAttributeMappings)),errors.collect(cdk.propertyValidator("sourceColumn",cdk.validateString)(properties.sourceColumn)),errors.collect(cdk.propertyValidator("targetMeasureName",cdk.validateString)(properties.targetMeasureName)),errors.wrap('supplied properties not correct for "MixedMeasureMappingProperty"')}function cfnScheduledQueryMixedMeasureMappingPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_MixedMeasureMappingPropertyValidator(properties).assertSuccess(),{MeasureName:cdk.stringToCloudFormation(properties.measureName),MeasureValueType:cdk.stringToCloudFormation(properties.measureValueType),MultiMeasureAttributeMappings:cdk.listMapper(cfnScheduledQueryMultiMeasureAttributeMappingPropertyToCloudFormation)(properties.multiMeasureAttributeMappings),SourceColumn:cdk.stringToCloudFormation(properties.sourceColumn),TargetMeasureName:cdk.stringToCloudFormation(properties.targetMeasureName)}):properties}function CfnScheduledQueryMixedMeasureMappingPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("measureName","MeasureName",properties.MeasureName!=null?cfn_parse.FromCloudFormation.getString(properties.MeasureName):void 0),ret.addPropertyResult("measureValueType","MeasureValueType",cfn_parse.FromCloudFormation.getString(properties.MeasureValueType)),ret.addPropertyResult("multiMeasureAttributeMappings","MultiMeasureAttributeMappings",properties.MultiMeasureAttributeMappings!=null?cfn_parse.FromCloudFormation.getArray(CfnScheduledQueryMultiMeasureAttributeMappingPropertyFromCloudFormation)(properties.MultiMeasureAttributeMappings):void 0),ret.addPropertyResult("sourceColumn","SourceColumn",properties.SourceColumn!=null?cfn_parse.FromCloudFormation.getString(properties.SourceColumn):void 0),ret.addPropertyResult("targetMeasureName","TargetMeasureName",properties.TargetMeasureName!=null?cfn_parse.FromCloudFormation.getString(properties.TargetMeasureName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_MultiMeasureAttributeMappingPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("measureValueType",cdk.requiredValidator)(properties.measureValueType)),errors.collect(cdk.propertyValidator("measureValueType",cdk.validateString)(properties.measureValueType)),errors.collect(cdk.propertyValidator("sourceColumn",cdk.requiredValidator)(properties.sourceColumn)),errors.collect(cdk.propertyValidator("sourceColumn",cdk.validateString)(properties.sourceColumn)),errors.collect(cdk.propertyValidator("targetMultiMeasureAttributeName",cdk.validateString)(properties.targetMultiMeasureAttributeName)),errors.wrap('supplied properties not correct for "MultiMeasureAttributeMappingProperty"')}function cfnScheduledQueryMultiMeasureAttributeMappingPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_MultiMeasureAttributeMappingPropertyValidator(properties).assertSuccess(),{MeasureValueType:cdk.stringToCloudFormation(properties.measureValueType),SourceColumn:cdk.stringToCloudFormation(properties.sourceColumn),TargetMultiMeasureAttributeName:cdk.stringToCloudFormation(properties.targetMultiMeasureAttributeName)}):properties}function CfnScheduledQueryMultiMeasureAttributeMappingPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("measureValueType","MeasureValueType",cfn_parse.FromCloudFormation.getString(properties.MeasureValueType)),ret.addPropertyResult("sourceColumn","SourceColumn",cfn_parse.FromCloudFormation.getString(properties.SourceColumn)),ret.addPropertyResult("targetMultiMeasureAttributeName","TargetMultiMeasureAttributeName",properties.TargetMultiMeasureAttributeName!=null?cfn_parse.FromCloudFormation.getString(properties.TargetMultiMeasureAttributeName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_MultiMeasureMappingsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("multiMeasureAttributeMappings",cdk.requiredValidator)(properties.multiMeasureAttributeMappings)),errors.collect(cdk.propertyValidator("multiMeasureAttributeMappings",cdk.listValidator(CfnScheduledQuery_MultiMeasureAttributeMappingPropertyValidator))(properties.multiMeasureAttributeMappings)),errors.collect(cdk.propertyValidator("targetMultiMeasureName",cdk.validateString)(properties.targetMultiMeasureName)),errors.wrap('supplied properties not correct for "MultiMeasureMappingsProperty"')}function cfnScheduledQueryMultiMeasureMappingsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_MultiMeasureMappingsPropertyValidator(properties).assertSuccess(),{MultiMeasureAttributeMappings:cdk.listMapper(cfnScheduledQueryMultiMeasureAttributeMappingPropertyToCloudFormation)(properties.multiMeasureAttributeMappings),TargetMultiMeasureName:cdk.stringToCloudFormation(properties.targetMultiMeasureName)}):properties}function CfnScheduledQueryMultiMeasureMappingsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("multiMeasureAttributeMappings","MultiMeasureAttributeMappings",cfn_parse.FromCloudFormation.getArray(CfnScheduledQueryMultiMeasureAttributeMappingPropertyFromCloudFormation)(properties.MultiMeasureAttributeMappings)),ret.addPropertyResult("targetMultiMeasureName","TargetMultiMeasureName",properties.TargetMultiMeasureName!=null?cfn_parse.FromCloudFormation.getString(properties.TargetMultiMeasureName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_NotificationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("snsConfiguration",cdk.requiredValidator)(properties.snsConfiguration)),errors.collect(cdk.propertyValidator("snsConfiguration",CfnScheduledQuery_SnsConfigurationPropertyValidator)(properties.snsConfiguration)),errors.wrap('supplied properties not correct for "NotificationConfigurationProperty"')}function cfnScheduledQueryNotificationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_NotificationConfigurationPropertyValidator(properties).assertSuccess(),{SnsConfiguration:cfnScheduledQuerySnsConfigurationPropertyToCloudFormation(properties.snsConfiguration)}):properties}function CfnScheduledQueryNotificationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("snsConfiguration","SnsConfiguration",CfnScheduledQuerySnsConfigurationPropertyFromCloudFormation(properties.SnsConfiguration)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_S3ConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucketName",cdk.requiredValidator)(properties.bucketName)),errors.collect(cdk.propertyValidator("bucketName",cdk.validateString)(properties.bucketName)),errors.collect(cdk.propertyValidator("encryptionOption",cdk.validateString)(properties.encryptionOption)),errors.collect(cdk.propertyValidator("objectKeyPrefix",cdk.validateString)(properties.objectKeyPrefix)),errors.wrap('supplied properties not correct for "S3ConfigurationProperty"')}function cfnScheduledQueryS3ConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_S3ConfigurationPropertyValidator(properties).assertSuccess(),{BucketName:cdk.stringToCloudFormation(properties.bucketName),EncryptionOption:cdk.stringToCloudFormation(properties.encryptionOption),ObjectKeyPrefix:cdk.stringToCloudFormation(properties.objectKeyPrefix)}):properties}function CfnScheduledQueryS3ConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucketName","BucketName",cfn_parse.FromCloudFormation.getString(properties.BucketName)),ret.addPropertyResult("encryptionOption","EncryptionOption",properties.EncryptionOption!=null?cfn_parse.FromCloudFormation.getString(properties.EncryptionOption):void 0),ret.addPropertyResult("objectKeyPrefix","ObjectKeyPrefix",properties.ObjectKeyPrefix!=null?cfn_parse.FromCloudFormation.getString(properties.ObjectKeyPrefix):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_ScheduleConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("scheduleExpression",cdk.requiredValidator)(properties.scheduleExpression)),errors.collect(cdk.propertyValidator("scheduleExpression",cdk.validateString)(properties.scheduleExpression)),errors.wrap('supplied properties not correct for "ScheduleConfigurationProperty"')}function cfnScheduledQueryScheduleConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_ScheduleConfigurationPropertyValidator(properties).assertSuccess(),{ScheduleExpression:cdk.stringToCloudFormation(properties.scheduleExpression)}):properties}function CfnScheduledQueryScheduleConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("scheduleExpression","ScheduleExpression",cfn_parse.FromCloudFormation.getString(properties.ScheduleExpression)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_SnsConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("topicArn",cdk.requiredValidator)(properties.topicArn)),errors.collect(cdk.propertyValidator("topicArn",cdk.validateString)(properties.topicArn)),errors.wrap('supplied properties not correct for "SnsConfigurationProperty"')}function cfnScheduledQuerySnsConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_SnsConfigurationPropertyValidator(properties).assertSuccess(),{TopicArn:cdk.stringToCloudFormation(properties.topicArn)}):properties}function CfnScheduledQuerySnsConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("topicArn","TopicArn",cfn_parse.FromCloudFormation.getString(properties.TopicArn)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_TargetConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("timestreamConfiguration",cdk.requiredValidator)(properties.timestreamConfiguration)),errors.collect(cdk.propertyValidator("timestreamConfiguration",CfnScheduledQuery_TimestreamConfigurationPropertyValidator)(properties.timestreamConfiguration)),errors.wrap('supplied properties not correct for "TargetConfigurationProperty"')}function cfnScheduledQueryTargetConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_TargetConfigurationPropertyValidator(properties).assertSuccess(),{TimestreamConfiguration:cfnScheduledQueryTimestreamConfigurationPropertyToCloudFormation(properties.timestreamConfiguration)}):properties}function CfnScheduledQueryTargetConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("timestreamConfiguration","TimestreamConfiguration",CfnScheduledQueryTimestreamConfigurationPropertyFromCloudFormation(properties.TimestreamConfiguration)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnScheduledQuery_TimestreamConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("databaseName",cdk.requiredValidator)(properties.databaseName)),errors.collect(cdk.propertyValidator("databaseName",cdk.validateString)(properties.databaseName)),errors.collect(cdk.propertyValidator("dimensionMappings",cdk.requiredValidator)(properties.dimensionMappings)),errors.collect(cdk.propertyValidator("dimensionMappings",cdk.listValidator(CfnScheduledQuery_DimensionMappingPropertyValidator))(properties.dimensionMappings)),errors.collect(cdk.propertyValidator("measureNameColumn",cdk.validateString)(properties.measureNameColumn)),errors.collect(cdk.propertyValidator("mixedMeasureMappings",cdk.listValidator(CfnScheduledQuery_MixedMeasureMappingPropertyValidator))(properties.mixedMeasureMappings)),errors.collect(cdk.propertyValidator("multiMeasureMappings",CfnScheduledQuery_MultiMeasureMappingsPropertyValidator)(properties.multiMeasureMappings)),errors.collect(cdk.propertyValidator("tableName",cdk.requiredValidator)(properties.tableName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.collect(cdk.propertyValidator("timeColumn",cdk.requiredValidator)(properties.timeColumn)),errors.collect(cdk.propertyValidator("timeColumn",cdk.validateString)(properties.timeColumn)),errors.wrap('supplied properties not correct for "TimestreamConfigurationProperty"')}function cfnScheduledQueryTimestreamConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnScheduledQuery_TimestreamConfigurationPropertyValidator(properties).assertSuccess(),{DatabaseName:cdk.stringToCloudFormation(properties.databaseName),DimensionMappings:cdk.listMapper(cfnScheduledQueryDimensionMappingPropertyToCloudFormation)(properties.dimensionMappings),MeasureNameColumn:cdk.stringToCloudFormation(properties.measureNameColumn),MixedMeasureMappings:cdk.listMapper(cfnScheduledQueryMixedMeasureMappingPropertyToCloudFormation)(properties.mixedMeasureMappings),MultiMeasureMappings:cfnScheduledQueryMultiMeasureMappingsPropertyToCloudFormation(properties.multiMeasureMappings),TableName:cdk.stringToCloudFormation(properties.tableName),TimeColumn:cdk.stringToCloudFormation(properties.timeColumn)}):properties}function CfnScheduledQueryTimestreamConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("databaseName","DatabaseName",cfn_parse.FromCloudFormation.getString(properties.DatabaseName)),ret.addPropertyResult("dimensionMappings","DimensionMappings",cfn_parse.FromCloudFormation.getArray(CfnScheduledQueryDimensionMappingPropertyFromCloudFormation)(properties.DimensionMappings)),ret.addPropertyResult("measureNameColumn","MeasureNameColumn",properties.MeasureNameColumn!=null?cfn_parse.FromCloudFormation.getString(properties.MeasureNameColumn):void 0),ret.addPropertyResult("mixedMeasureMappings","MixedMeasureMappings",properties.MixedMeasureMappings!=null?cfn_parse.FromCloudFormation.getArray(CfnScheduledQueryMixedMeasureMappingPropertyFromCloudFormation)(properties.MixedMeasureMappings):void 0),ret.addPropertyResult("multiMeasureMappings","MultiMeasureMappings",properties.MultiMeasureMappings!=null?CfnScheduledQueryMultiMeasureMappingsPropertyFromCloudFormation(properties.MultiMeasureMappings):void 0),ret.addPropertyResult("tableName","TableName",cfn_parse.FromCloudFormation.getString(properties.TableName)),ret.addPropertyResult("timeColumn","TimeColumn",cfn_parse.FromCloudFormation.getString(properties.TimeColumn)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnTablePropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("databaseName",cdk.requiredValidator)(properties.databaseName)),errors.collect(cdk.propertyValidator("databaseName",cdk.validateString)(properties.databaseName)),errors.collect(cdk.propertyValidator("magneticStoreWriteProperties",cdk.validateObject)(properties.magneticStoreWriteProperties)),errors.collect(cdk.propertyValidator("retentionProperties",cdk.validateObject)(properties.retentionProperties)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnTableProps"')}function cfnTablePropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnTablePropsValidator(properties).assertSuccess(),{DatabaseName:cdk.stringToCloudFormation(properties.databaseName),MagneticStoreWriteProperties:cdk.objectToCloudFormation(properties.magneticStoreWriteProperties),RetentionProperties:cdk.objectToCloudFormation(properties.retentionProperties),TableName:cdk.stringToCloudFormation(properties.tableName),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnTablePropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("databaseName","DatabaseName",cfn_parse.FromCloudFormation.getString(properties.DatabaseName)),ret.addPropertyResult("magneticStoreWriteProperties","MagneticStoreWriteProperties",properties.MagneticStoreWriteProperties!=null?cfn_parse.FromCloudFormation.getAny(properties.MagneticStoreWriteProperties):void 0),ret.addPropertyResult("retentionProperties","RetentionProperties",properties.RetentionProperties!=null?cfn_parse.FromCloudFormation.getAny(properties.RetentionProperties):void 0),ret.addPropertyResult("tableName","TableName",properties.TableName!=null?cfn_parse.FromCloudFormation.getString(properties.TableName):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnTable extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnTable.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_timestream_CfnTableProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnTable),error}cdk.requireProperty(props,"databaseName",this),this.attrArn=cdk.Token.asString(this.getAtt("Arn",cdk.ResolutionTypeHint.STRING)),this.attrName=cdk.Token.asString(this.getAtt("Name",cdk.ResolutionTypeHint.STRING)),this.databaseName=props.databaseName,this.magneticStoreWriteProperties=props.magneticStoreWriteProperties,this.retentionProperties=props.retentionProperties,this.tableName=props.tableName,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::Timestream::Table",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnTablePropsFromCloudFormation(resourceProperties),ret=new CfnTable(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnTable.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{databaseName:this.databaseName,magneticStoreWriteProperties:this.magneticStoreWriteProperties,retentionProperties:this.retentionProperties,tableName:this.tableName,tags:this.tags.renderTags()}}renderProperties(props){return cfnTablePropsToCloudFormation(props)}}exports.CfnTable=CfnTable,_c=JSII_RTTI_SYMBOL_1,CfnTable[_c]={fqn:"aws-cdk-lib.aws_timestream.CfnTable",version:"2.69.0"},CfnTable.CFN_RESOURCE_TYPE_NAME="AWS::Timestream::Table";function CfnTable_MagneticStoreRejectedDataLocationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("s3Configuration",CfnTable_S3ConfigurationPropertyValidator)(properties.s3Configuration)),errors.wrap('supplied properties not correct for "MagneticStoreRejectedDataLocationProperty"')}function cfnTableMagneticStoreRejectedDataLocationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnTable_MagneticStoreRejectedDataLocationPropertyValidator(properties).assertSuccess(),{S3Configuration:cfnTableS3ConfigurationPropertyToCloudFormation(properties.s3Configuration)}):properties}function CfnTableMagneticStoreRejectedDataLocationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("s3Configuration","S3Configuration",properties.S3Configuration!=null?CfnTableS3ConfigurationPropertyFromCloudFormation(properties.S3Configuration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnTable_MagneticStoreWritePropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enableMagneticStoreWrites",cdk.requiredValidator)(properties.enableMagneticStoreWrites)),errors.collect(cdk.propertyValidator("enableMagneticStoreWrites",cdk.validateBoolean)(properties.enableMagneticStoreWrites)),errors.collect(cdk.propertyValidator("magneticStoreRejectedDataLocation",CfnTable_MagneticStoreRejectedDataLocationPropertyValidator)(properties.magneticStoreRejectedDataLocation)),errors.wrap('supplied properties not correct for "MagneticStoreWritePropertiesProperty"')}function cfnTableMagneticStoreWritePropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnTable_MagneticStoreWritePropertiesPropertyValidator(properties).assertSuccess(),{EnableMagneticStoreWrites:cdk.booleanToCloudFormation(properties.enableMagneticStoreWrites),MagneticStoreRejectedDataLocation:cfnTableMagneticStoreRejectedDataLocationPropertyToCloudFormation(properties.magneticStoreRejectedDataLocation)}):properties}function CfnTableMagneticStoreWritePropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enableMagneticStoreWrites","EnableMagneticStoreWrites",cfn_parse.FromCloudFormation.getBoolean(properties.EnableMagneticStoreWrites)),ret.addPropertyResult("magneticStoreRejectedDataLocation","MagneticStoreRejectedDataLocation",properties.MagneticStoreRejectedDataLocation!=null?CfnTableMagneticStoreRejectedDataLocationPropertyFromCloudFormation(properties.MagneticStoreRejectedDataLocation):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnTable_RetentionPropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("magneticStoreRetentionPeriodInDays",cdk.validateString)(properties.magneticStoreRetentionPeriodInDays)),errors.collect(cdk.propertyValidator("memoryStoreRetentionPeriodInHours",cdk.validateString)(properties.memoryStoreRetentionPeriodInHours)),errors.wrap('supplied properties not correct for "RetentionPropertiesProperty"')}function cfnTableRetentionPropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnTable_RetentionPropertiesPropertyValidator(properties).assertSuccess(),{MagneticStoreRetentionPeriodInDays:cdk.stringToCloudFormation(properties.magneticStoreRetentionPeriodInDays),MemoryStoreRetentionPeriodInHours:cdk.stringToCloudFormation(properties.memoryStoreRetentionPeriodInHours)}):properties}function CfnTableRetentionPropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("magneticStoreRetentionPeriodInDays","MagneticStoreRetentionPeriodInDays",properties.MagneticStoreRetentionPeriodInDays!=null?cfn_parse.FromCloudFormation.getString(properties.MagneticStoreRetentionPeriodInDays):void 0),ret.addPropertyResult("memoryStoreRetentionPeriodInHours","MemoryStoreRetentionPeriodInHours",properties.MemoryStoreRetentionPeriodInHours!=null?cfn_parse.FromCloudFormation.getString(properties.MemoryStoreRetentionPeriodInHours):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnTable_S3ConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucketName",cdk.requiredValidator)(properties.bucketName)),errors.collect(cdk.propertyValidator("bucketName",cdk.validateString)(properties.bucketName)),errors.collect(cdk.propertyValidator("encryptionOption",cdk.requiredValidator)(properties.encryptionOption)),errors.collect(cdk.propertyValidator("encryptionOption",cdk.validateString)(properties.encryptionOption)),errors.collect(cdk.propertyValidator("kmsKeyId",cdk.validateString)(properties.kmsKeyId)),errors.collect(cdk.propertyValidator("objectKeyPrefix",cdk.validateString)(properties.objectKeyPrefix)),errors.wrap('supplied properties not correct for "S3ConfigurationProperty"')}function cfnTableS3ConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnTable_S3ConfigurationPropertyValidator(properties).assertSuccess(),{BucketName:cdk.stringToCloudFormation(properties.bucketName),EncryptionOption:cdk.stringToCloudFormation(properties.encryptionOption),KmsKeyId:cdk.stringToCloudFormation(properties.kmsKeyId),ObjectKeyPrefix:cdk.stringToCloudFormation(properties.objectKeyPrefix)}):properties}function CfnTableS3ConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucketName","BucketName",cfn_parse.FromCloudFormation.getString(properties.BucketName)),ret.addPropertyResult("encryptionOption","EncryptionOption",cfn_parse.FromCloudFormation.getString(properties.EncryptionOption)),ret.addPropertyResult("kmsKeyId","KmsKeyId",properties.KmsKeyId!=null?cfn_parse.FromCloudFormation.getString(properties.KmsKeyId):void 0),ret.addPropertyResult("objectKeyPrefix","ObjectKeyPrefix",properties.ObjectKeyPrefix!=null?cfn_parse.FromCloudFormation.getString(properties.ObjectKeyPrefix):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
