"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Activity=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cloudwatch=require("../../aws-cloudwatch"),iam=require("../../aws-iam"),core_1=require("../../core"),stepfunctions_canned_metrics_generated_1=require("./stepfunctions-canned-metrics.generated"),stepfunctions_generated_1=require("./stepfunctions.generated");class Activity extends core_1.Resource{constructor(scope,id,props={}){super(scope,id,{physicalName:props.activityName||core_1.Lazy.string({produce:()=>this.generateName()})});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_ActivityProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Activity),error}const resource=new stepfunctions_generated_1.CfnActivity(this,"Resource",{name:this.physicalName});this.activityArn=this.getResourceArnAttribute(resource.ref,{service:"states",resource:"activity",resourceName:this.physicalName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME}),this.activityName=this.getResourceNameAttribute(resource.attrName)}static fromActivityArn(scope,id,activityArn){class Imported extends core_1.Resource{get activityArn(){return activityArn}get activityName(){return core_1.Stack.of(this).splitArn(activityArn,core_1.ArnFormat.COLON_RESOURCE_NAME).resourceName||""}}return new Imported(scope,id)}static fromActivityName(scope,id,activityName){return Activity.fromActivityArn(scope,id,core_1.Stack.of(scope).formatArn({service:"states",resource:"activity",resourceName:activityName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME}))}grant(identity,...actions){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(identity)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grant),error}return iam.Grant.addToPrincipal({grantee:identity,actions,resourceArns:[this.activityArn]})}metric(metricName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metric),error}return new cloudwatch.Metric({namespace:"AWS/States",metricName,dimensions:{ActivityArn:this.activityArn},statistic:"sum",...props}).attachTo(this)}metricRunTime(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricRunTime),error}return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.activityRunTimeAverage,props)}metricScheduleTime(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricScheduleTime),error}return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.activityScheduleTimeAverage,props)}metricTime(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTime),error}return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.activityTimeAverage,props)}metricScheduled(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricScheduled),error}return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.activitiesScheduledSum,props)}metricTimedOut(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricTimedOut),error}return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.activitiesTimedOutSum,props)}metricStarted(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricStarted),error}return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.activitiesStartedSum,props)}metricSucceeded(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricSucceeded),error}return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.activitiesSucceededSum,props)}metricFailed(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricFailed),error}return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.activitiesFailedSum,props)}metricHeartbeatTimedOut(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricHeartbeatTimedOut),error}return this.cannedMetric(stepfunctions_canned_metrics_generated_1.StatesMetrics.activitiesHeartbeatTimedOutSum,props)}generateName(){const name=core_1.Names.uniqueId(this);return name.length>80?name.substring(0,40)+name.substring(name.length-40):name}cannedMetric(fn,props){return new cloudwatch.Metric({...fn({ActivityArn:this.activityArn}),...props}).attachTo(this)}}exports.Activity=Activity,_a=JSII_RTTI_SYMBOL_1,Activity[_a]={fqn:"aws-cdk-lib.aws_stepfunctions.Activity",version:"2.69.0"};
