"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.ProductStackSynthesizer=void 0;const path=require("path"),aws_s3_deployment_1=require("../../../aws-s3-deployment"),cdk=require("../../../core");class ProductStackSynthesizer extends cdk.StackSynthesizer{constructor(assetBucket){super(),this.assetBucket=assetBucket}addFileAsset(asset){if(!this.assetBucket)throw new Error("An Asset Bucket must be provided to use Assets");const assetPath=`${cdk.App.of(this.boundStack)?.outdir??"cdk.out"}/${asset.fileName}`;if(this.bucketDeployment)this.bucketDeployment.addSource(aws_s3_deployment_1.Source.asset(assetPath));else{const parentStack=this.boundStack._getParentStack();cdk.Resource.isOwnedResource(this.assetBucket)||cdk.Annotations.of(parentStack).addWarning("[WARNING] Bucket Policy Permissions cannot be added to referenced Bucket. Please make sure your bucket has the correct permissions"),this.bucketDeployment=new aws_s3_deployment_1.BucketDeployment(parentStack,"AssetsBucketDeployment",{sources:[aws_s3_deployment_1.Source.asset(assetPath)],destinationBucket:this.assetBucket,extract:!1,prune:!1})}const bucketName=this.physicalNameOfBucket(this.assetBucket);if(!asset.fileName)throw new Error("Asset file name is undefined");const objectKey=`${path.basename(asset.fileName).split(".")[1]+".zip"}`,s3ObjectUrl=`s3://${bucketName}/${objectKey}`,httpUrl=`https://s3.${bucketName}/${objectKey}`;return{bucketName,objectKey,httpUrl,s3ObjectUrl,s3Url:httpUrl}}physicalNameOfBucket(bucket){let resolvedName;if(cdk.Resource.isOwnedResource(bucket)?resolvedName=cdk.Stack.of(bucket).resolve(bucket.node.defaultChild.bucketName):resolvedName=bucket.bucketName,resolvedName===void 0)throw new Error("A bucketName must be provided to use Assets");return resolvedName}addDockerImageAsset(_asset){throw new Error("Service Catalog Product Stacks cannot use Assets")}synthesize(session){this.synthesizeTemplate(session)}}exports.ProductStackSynthesizer=ProductStackSynthesizer;
