"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const cloudwatch=require("../../aws-cloudwatch"),ec2=require("../../aws-ec2"),targets=require("../../aws-events-targets"),lambda=require("../../aws-lambda"),logs=require("../../aws-logs"),cdk=require("../../core"),core_1=require("../../core"),rds=require("../lib"),app=new cdk.App;class DatabaseInstanceStack extends cdk.Stack{constructor(scope,id,props){super(scope,id,props);const vpc=new ec2.Vpc(this,"VPC",{maxAzs:2}),parameterGroup=new rds.ParameterGroup(this,"ParameterGroup",{engine:rds.DatabaseInstanceEngine.oracleSe2({version:rds.OracleEngineVersion.VER_19_0_0_0_2020_04_R1}),parameters:{open_cursors:"2500"}}),optionGroup=new rds.OptionGroup(this,"OptionGroup",{engine:rds.DatabaseInstanceEngine.oracleSe2({version:rds.OracleEngineVersion.VER_19_0_0_0_2020_04_R1}),configurations:[{name:"LOCATOR"},{name:"OEM",port:1158,vpc}]});optionGroup.optionConnections.OEM.connections.allowDefaultPortFromAnyIpv4();const instance=new rds.DatabaseInstance(this,"Instance",{engine:rds.DatabaseInstanceEngine.oracleSe2({version:rds.OracleEngineVersion.VER_19_0_0_0_2020_04_R1}),licenseModel:rds.LicenseModel.BRING_YOUR_OWN_LICENSE,instanceType:ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE3,ec2.InstanceSize.MEDIUM),multiAz:!0,storageType:rds.StorageType.IO1,credentials:rds.Credentials.fromUsername("syscdk"),vpc,databaseName:"ORCL",storageEncrypted:!0,backupRetention:cdk.Duration.days(7),monitoringInterval:cdk.Duration.seconds(60),enablePerformanceInsights:!0,cloudwatchLogsExports:["trace","audit","alert","listener"],cloudwatchLogsRetention:logs.RetentionDays.ONE_MONTH,autoMinorVersionUpgrade:!0,optionGroup,parameterGroup,removalPolicy:core_1.RemovalPolicy.DESTROY});instance.connections.allowDefaultPortFromAnyIpv4(),instance.addRotationSingleUser(),new cloudwatch.Alarm(this,"HighCPU",{metric:instance.metricCPUUtilization(),threshold:90,evaluationPeriods:1});const fn=new lambda.Function(this,"Function",{code:lambda.Code.fromInline("exports.handler = (event) => console.log(event);"),handler:"index.handler",runtime:lambda.Runtime.NODEJS_14_X});instance.onEvent("Availability",{target:new targets.LambdaFunction(fn)}).addEventPattern({detail:{EventCategories:["availability"]}})}}new DatabaseInstanceStack(app,"aws-cdk-rds-instance"),app.synth();
