"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DatabaseProxy=exports.ProxyTarget=exports.SessionPinningFilter=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2=require("../../aws-ec2"),iam=require("../../aws-iam"),secretsmanager=require("../../aws-secretsmanager"),cdk=require("../../core"),cxapi=require("../../cx-api"),util_1=require("./private/util"),rds_generated_1=require("./rds.generated");class SessionPinningFilter{constructor(filterName){this.filterName=filterName}static of(filterName){return new SessionPinningFilter(filterName)}}exports.SessionPinningFilter=SessionPinningFilter,_a=JSII_RTTI_SYMBOL_1,SessionPinningFilter[_a]={fqn:"aws-cdk-lib.aws_rds.SessionPinningFilter",version:"2.69.0"},SessionPinningFilter.EXCLUDE_VARIABLE_SETS=new SessionPinningFilter("EXCLUDE_VARIABLE_SETS");class ProxyTarget{constructor(dbInstance,dbCluster){this.dbInstance=dbInstance,this.dbCluster=dbCluster}static fromInstance(instance){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_IDatabaseInstance(instance)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromInstance),error}return new ProxyTarget(instance,void 0)}static fromCluster(cluster){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_IDatabaseCluster(cluster)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromCluster),error}return new ProxyTarget(void 0,cluster)}bind(proxy){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_DatabaseProxy(proxy)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}const engine=this.dbInstance?.engine??this.dbCluster?.engine;if(!engine){const errorResource=this.dbCluster??this.dbInstance;throw new Error(`Could not determine engine for proxy target '${errorResource?.node.path}'. Please provide it explicitly when importing the resource`)}const engineFamily=engine.engineFamily;if(!engineFamily)throw new Error(`Engine '${util_1.engineDescription(engine)}' does not support proxies`);return this.dbCluster?.connections.allowDefaultPortFrom(proxy,"Allow connections to the database Cluster from the Proxy"),this.dbInstance?.connections.allowDefaultPortFrom(proxy,"Allow connections to the database Instance from the Proxy"),{engineFamily,dbClusters:this.dbCluster?[this.dbCluster]:void 0,dbInstances:this.dbInstance?[this.dbInstance]:void 0}}}exports.ProxyTarget=ProxyTarget,_b=JSII_RTTI_SYMBOL_1,ProxyTarget[_b]={fqn:"aws-cdk-lib.aws_rds.ProxyTarget",version:"2.69.0"};class DatabaseProxyBase extends cdk.Resource{grantConnect(grantee,dbUser){if(!dbUser)throw new Error("For imported Database Proxies, the dbUser is required in grantConnect()");const scopeStack=cdk.Stack.of(this),proxyGeneratedId=scopeStack.splitArn(this.dbProxyArn,cdk.ArnFormat.COLON_RESOURCE_NAME).resourceName,userArn=scopeStack.formatArn({service:"rds-db",resource:"dbuser",resourceName:`${proxyGeneratedId}/${dbUser}`,arnFormat:cdk.ArnFormat.COLON_RESOURCE_NAME});return iam.Grant.addToPrincipal({grantee,actions:["rds-db:connect"],resourceArns:[userArn]})}}class DatabaseProxy extends DatabaseProxyBase{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_DatabaseProxyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DatabaseProxy),error}const physicalName=props.dbProxyName||(cdk.FeatureFlags.of(this).isEnabled(cxapi.DATABASE_PROXY_UNIQUE_RESOURCE_NAME)?cdk.Names.uniqueResourceName(this,{maxLength:60}):id),role=props.role||new iam.Role(this,"IAMRole",{assumedBy:new iam.ServicePrincipal("rds.amazonaws.com")});for(const secret of props.secrets)secret.grantRead(role);const securityGroups=props.securityGroups??[new ec2.SecurityGroup(this,"ProxySecurityGroup",{description:"SecurityGroup for Database Proxy",vpc:props.vpc})];this.connections=new ec2.Connections({securityGroups});const bindResult=props.proxyTarget.bind(this);if(props.secrets.length<1)throw new Error("One or more secrets are required.");this.secrets=props.secrets,this.resource=new rds_generated_1.CfnDBProxy(this,"Resource",{auth:props.secrets.map(_=>({authScheme:"SECRETS",iamAuth:props.iamAuth?"REQUIRED":"DISABLED",secretArn:_.secretArn})),dbProxyName:physicalName,debugLogging:props.debugLogging,engineFamily:bindResult.engineFamily,idleClientTimeout:props.idleClientTimeout?.toSeconds(),requireTls:props.requireTLS??!0,roleArn:role.roleArn,vpcSecurityGroupIds:cdk.Lazy.list({produce:()=>this.connections.securityGroups.map(_=>_.securityGroupId)}),vpcSubnetIds:props.vpc.selectSubnets(props.vpcSubnets).subnetIds}),this.dbProxyName=this.resource.ref,this.dbProxyArn=this.resource.attrDbProxyArn,this.endpoint=this.resource.attrEndpoint;let dbInstanceIdentifiers;bindResult.dbInstances&&(dbInstanceIdentifiers=[bindResult.dbInstances[0].instanceIdentifier]);let dbClusterIdentifiers;if(bindResult.dbClusters&&(dbClusterIdentifiers=bindResult.dbClusters.map(c=>c.clusterIdentifier)),dbInstanceIdentifiers&&dbClusterIdentifiers)throw new Error("Cannot specify both dbInstanceIdentifiers and dbClusterIdentifiers");const proxyTargetGroup=new rds_generated_1.CfnDBProxyTargetGroup(this,"ProxyTargetGroup",{targetGroupName:"default",dbProxyName:this.dbProxyName,dbInstanceIdentifiers,dbClusterIdentifiers,connectionPoolConfigurationInfo:toConnectionPoolConfigurationInfo(props)});bindResult.dbClusters?.forEach(c=>proxyTargetGroup.node.addDependency(c))}static fromDatabaseProxyAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_DatabaseProxyAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDatabaseProxyAttributes),error}class Import extends DatabaseProxyBase{constructor(){super(...arguments),this.dbProxyName=attrs.dbProxyName,this.dbProxyArn=attrs.dbProxyArn,this.endpoint=attrs.endpoint}}return new Import(scope,id)}asSecretAttachmentTarget(){return{targetId:this.dbProxyName,targetType:secretsmanager.AttachmentTargetType.RDS_DB_PROXY}}grantConnect(grantee,dbUser){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantConnect),error}if(!dbUser){if(this.secrets.length>1)throw new Error("When the Proxy contains multiple Secrets, you must pass a dbUser explicitly to grantConnect()");dbUser=this.secrets[0].secretValueFromJson("username").unsafeUnwrap()}return super.grantConnect(grantee,dbUser)}}exports.DatabaseProxy=DatabaseProxy,_c=JSII_RTTI_SYMBOL_1,DatabaseProxy[_c]={fqn:"aws-cdk-lib.aws_rds.DatabaseProxy",version:"2.69.0"};function toConnectionPoolConfigurationInfo(props){return{connectionBorrowTimeout:props.borrowTimeout?.toSeconds(),initQuery:props.initQuery,maxConnectionsPercent:props.maxConnectionsPercent,maxIdleConnectionsPercent:props.maxIdleConnectionsPercent,sessionPinningFilters:props.sessionPinningFilters?.map(_=>_.filterName)}}
