"use strict";var _a,_b,_c,_d,_e,_f,_g;Object.defineProperty(exports,"__esModule",{value:!0}),exports.AssetImageCode=exports.EcrImageCode=exports.CfnParametersCode=exports.AssetCode=exports.InlineCode=exports.S3Code=exports.Code=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ecr_assets=require("../../aws-ecr-assets"),iam=require("../../aws-iam"),s3_assets=require("../../aws-s3-assets"),cdk=require("../../core");class Code{static fromBucket(bucket,key,objectVersion){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromBucket),error}return new S3Code(bucket,key,objectVersion)}static bucket(bucket,key,objectVersion){return this.fromBucket(bucket,key,objectVersion)}static fromInline(code){return new InlineCode(code)}static inline(code){return this.fromInline(code)}static fromAsset(path,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_assets_AssetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAsset),error}return new AssetCode(path,options)}static fromDockerBuild(path,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_DockerBuildAssetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDockerBuild),error}let imagePath=options.imagePath??"/asset/.";imagePath.endsWith("/")?imagePath=`${imagePath}.`:imagePath.endsWith("/.")||(imagePath=`${imagePath}/.`);const assetPath=cdk.DockerImage.fromBuild(path,options).cp(imagePath,options.outputPath);return new AssetCode(assetPath)}static asset(path){return this.fromAsset(path)}static fromCfnParameters(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_CfnParametersCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromCfnParameters),error}return new CfnParametersCode(props)}static cfnParameters(props){return this.fromCfnParameters(props)}static fromEcrImage(repository,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecr_IRepository(repository),jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_EcrImageCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromEcrImage),error}return new EcrImageCode(repository,props)}static fromAssetImage(directory,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_AssetImageCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromAssetImage),error}return new AssetImageCode(directory,props)}bindToResource(_resource,_options){try{jsiiDeprecationWarnings.aws_cdk_lib_CfnResource(_resource),jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_ResourceBindOptions(_options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bindToResource),error}}}exports.Code=Code,_a=JSII_RTTI_SYMBOL_1,Code[_a]={fqn:"aws-cdk-lib.aws_lambda.Code",version:"2.69.0"};class S3Code extends Code{constructor(bucket,key,objectVersion){super(),this.key=key,this.objectVersion=objectVersion,this.isInline=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,S3Code),error}if(!bucket.bucketName)throw new Error("bucketName is undefined for the provided bucket");this.bucketName=bucket.bucketName}bind(_scope){return{s3Location:{bucketName:this.bucketName,objectKey:this.key,objectVersion:this.objectVersion}}}}exports.S3Code=S3Code,_b=JSII_RTTI_SYMBOL_1,S3Code[_b]={fqn:"aws-cdk-lib.aws_lambda.S3Code",version:"2.69.0"};class InlineCode extends Code{constructor(code){if(super(),this.code=code,this.isInline=!0,code.length===0)throw new Error("Lambda inline code cannot be empty")}bind(_scope){return{inlineCode:this.code}}}exports.InlineCode=InlineCode,_c=JSII_RTTI_SYMBOL_1,InlineCode[_c]={fqn:"aws-cdk-lib.aws_lambda.InlineCode",version:"2.69.0"};class AssetCode extends Code{constructor(path,options={}){super(),this.path=path,this.options=options,this.isInline=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_assets_AssetOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,AssetCode),error}}bind(scope){if(!this.asset)this.asset=new s3_assets.Asset(scope,"Code",{path:this.path,...this.options});else if(cdk.Stack.of(this.asset)!==cdk.Stack.of(scope))throw new Error(`Asset is already associated with another stack '${cdk.Stack.of(this.asset).stackName}'. Create a new Code instance for every stack.`);if(!this.asset.isZipArchive)throw new Error(`Asset must be a .zip file or a directory (${this.path})`);return{s3Location:{bucketName:this.asset.s3BucketName,objectKey:this.asset.s3ObjectKey}}}bindToResource(resource,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_CfnResource(resource),jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_ResourceBindOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bindToResource),error}if(!this.asset)throw new Error("bindToResource() must be called after bind()");const resourceProperty=options.resourceProperty||"Code";this.asset.addResourceMetadata(resource,resourceProperty)}}exports.AssetCode=AssetCode,_d=JSII_RTTI_SYMBOL_1,AssetCode[_d]={fqn:"aws-cdk-lib.aws_lambda.AssetCode",version:"2.69.0"};class CfnParametersCode extends Code{constructor(props={}){super(),this.isInline=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_CfnParametersCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnParametersCode),error}this._bucketNameParam=props.bucketNameParam,this._objectKeyParam=props.objectKeyParam}bind(scope){return this._bucketNameParam||(this._bucketNameParam=new cdk.CfnParameter(scope,"LambdaSourceBucketNameParameter",{type:"String"})),this._objectKeyParam||(this._objectKeyParam=new cdk.CfnParameter(scope,"LambdaSourceObjectKeyParameter",{type:"String"})),{s3Location:{bucketName:this._bucketNameParam.valueAsString,objectKey:this._objectKeyParam.valueAsString}}}assign(location){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_Location(location)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.assign),error}const ret={};return ret[this.bucketNameParam]=location.bucketName,ret[this.objectKeyParam]=location.objectKey,ret}get bucketNameParam(){if(this._bucketNameParam)return this._bucketNameParam.logicalId;throw new Error("Pass CfnParametersCode to a Lambda Function before accessing the bucketNameParam property")}get objectKeyParam(){if(this._objectKeyParam)return this._objectKeyParam.logicalId;throw new Error("Pass CfnParametersCode to a Lambda Function before accessing the objectKeyParam property")}}exports.CfnParametersCode=CfnParametersCode,_e=JSII_RTTI_SYMBOL_1,CfnParametersCode[_e]={fqn:"aws-cdk-lib.aws_lambda.CfnParametersCode",version:"2.69.0"};class EcrImageCode extends Code{constructor(repository,props={}){super(),this.repository=repository,this.props=props,this.isInline=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ecr_IRepository(repository),jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_EcrImageCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EcrImageCode),error}}bind(_){return this.repository.grantPull(new iam.ServicePrincipal("lambda.amazonaws.com")),{image:{imageUri:this.repository.repositoryUriForTagOrDigest(this.props?.tagOrDigest??this.props?.tag??"latest"),cmd:this.props.cmd,entrypoint:this.props.entrypoint,workingDirectory:this.props.workingDirectory}}}}exports.EcrImageCode=EcrImageCode,_f=JSII_RTTI_SYMBOL_1,EcrImageCode[_f]={fqn:"aws-cdk-lib.aws_lambda.EcrImageCode",version:"2.69.0"};class AssetImageCode extends Code{constructor(directory,props){super(),this.directory=directory,this.props=props,this.isInline=!1;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_AssetImageCodeProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,AssetImageCode),error}}bind(scope){if(!this.asset)this.asset=new ecr_assets.DockerImageAsset(scope,"AssetImage",{directory:this.directory,...this.props}),this.asset.repository.grantPull(new iam.ServicePrincipal("lambda.amazonaws.com"));else if(cdk.Stack.of(this.asset)!==cdk.Stack.of(scope))throw new Error(`Asset is already associated with another stack '${cdk.Stack.of(this.asset).stackName}'. Create a new Code instance for every stack.`);return{image:{imageUri:this.asset.imageUri,entrypoint:this.props.entrypoint,cmd:this.props.cmd,workingDirectory:this.props.workingDirectory}}}bindToResource(resource,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_CfnResource(resource),jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_ResourceBindOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bindToResource),error}if(!this.asset)throw new Error("bindToResource() must be called after bind()");const resourceProperty=options.resourceProperty||"Code.ImageUri";this.asset.addResourceMetadata(resource,resourceProperty)}}exports.AssetImageCode=AssetImageCode,_g=JSII_RTTI_SYMBOL_1,AssetImageCode[_g]={fqn:"aws-cdk-lib.aws_lambda.AssetImageCode",version:"2.69.0"};
