"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.InstanceDrainHook=void 0;const fs=require("fs"),path=require("path"),autoscaling=require("../../../aws-autoscaling"),hooks=require("../../../aws-autoscaling-hooktargets"),iam=require("../../../aws-iam"),lambda=require("../../../aws-lambda"),cdk=require("../../../core"),constructs_1=require("constructs");class InstanceDrainHook extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);const drainTime=props.drainTime||cdk.Duration.minutes(5),fn=new lambda.Function(this,"Function",{code:lambda.Code.fromInline(fs.readFileSync(path.join(__dirname,"lambda-source","index.py"),{encoding:"utf-8"})),handler:"index.lambda_handler",runtime:lambda.Runtime.PYTHON_3_9,timeout:cdk.Duration.seconds(Math.min(drainTime.toSeconds()+10,900)),environment:{CLUSTER:props.cluster.clusterName}});props.autoScalingGroup.addLifecycleHook("DrainHook",{lifecycleTransition:autoscaling.LifecycleTransition.INSTANCE_TERMINATING,defaultResult:autoscaling.DefaultResult.CONTINUE,notificationTarget:new hooks.FunctionHook(fn,props.topicEncryptionKey),heartbeatTimeout:drainTime}),fn.addToRolePolicy(new iam.PolicyStatement({actions:["ec2:DescribeInstances","ec2:DescribeInstanceAttribute","ec2:DescribeInstanceStatus","ec2:DescribeHosts"],resources:["*"]})),fn.addToRolePolicy(new iam.PolicyStatement({actions:["autoscaling:CompleteLifecycleAction"],resources:[props.autoScalingGroup.autoScalingGroupArn]})),fn.addToRolePolicy(new iam.PolicyStatement({actions:["ecs:DescribeContainerInstances","ecs:DescribeTasks"],resources:["*"],conditions:{ArnEquals:{"ecs:cluster":props.cluster.clusterArn}}})),fn.addToRolePolicy(new iam.PolicyStatement({actions:["ecs:ListContainerInstances","ecs:SubmitContainerStateChange","ecs:SubmitTaskStateChange"],resources:[props.cluster.clusterArn]})),fn.addToRolePolicy(new iam.PolicyStatement({actions:["ecs:UpdateContainerInstancesState","ecs:ListTasks"],conditions:{ArnEquals:{"ecs:cluster":props.cluster.clusterArn}},resources:["*"]}))}}exports.InstanceDrainHook=InstanceDrainHook;
