"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.TableClass=exports.StreamViewType=exports.ProjectionType=exports.BillingMode=exports.AttributeType=exports.Table=exports.TableEncryption=exports.Operation=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),appscaling=require("../../aws-applicationautoscaling"),cloudwatch=require("../../aws-cloudwatch"),iam=require("../../aws-iam"),kms=require("../../aws-kms"),core_1=require("../../core"),constructs_1=require("constructs"),dynamodb_canned_metrics_generated_1=require("./dynamodb-canned-metrics.generated"),dynamodb_generated_1=require("./dynamodb.generated"),perms=require("./perms"),replica_provider_1=require("./replica-provider"),scalable_table_attribute_1=require("./scalable-table-attribute"),HASH_KEY_TYPE="HASH",RANGE_KEY_TYPE="RANGE",MAX_LOCAL_SECONDARY_INDEX_COUNT=5;var Operation;(function(Operation2){Operation2.GET_ITEM="GetItem",Operation2.BATCH_GET_ITEM="BatchGetItem",Operation2.SCAN="Scan",Operation2.QUERY="Query",Operation2.GET_RECORDS="GetRecords",Operation2.PUT_ITEM="PutItem",Operation2.DELETE_ITEM="DeleteItem",Operation2.UPDATE_ITEM="UpdateItem",Operation2.BATCH_WRITE_ITEM="BatchWriteItem",Operation2.TRANSACT_WRITE_ITEMS="TransactWriteItems",Operation2.TRANSACT_GET_ITEMS="TransactGetItems",Operation2.EXECUTE_TRANSACTION="ExecuteTransaction",Operation2.BATCH_EXECUTE_STATEMENT="BatchExecuteStatement",Operation2.EXECUTE_STATEMENT="ExecuteStatement"})(Operation=exports.Operation||(exports.Operation={}));var TableEncryption;(function(TableEncryption2){TableEncryption2.DEFAULT="AWS_OWNED",TableEncryption2.CUSTOMER_MANAGED="CUSTOMER_MANAGED",TableEncryption2.AWS_MANAGED="AWS_MANAGED"})(TableEncryption=exports.TableEncryption||(exports.TableEncryption={}));class TableBase extends core_1.Resource{constructor(){super(...arguments),this.regionalArns=new Array}grant(grantee,...actions){return iam.Grant.addToPrincipal({grantee,actions,resourceArns:[this.tableArn,core_1.Lazy.string({produce:()=>this.hasIndex?`${this.tableArn}/index/*`:core_1.Aws.NO_VALUE}),...this.regionalArns,...this.regionalArns.map(arn=>core_1.Lazy.string({produce:()=>this.hasIndex?`${arn}/index/*`:core_1.Aws.NO_VALUE}))],scope:this})}grantStream(grantee,...actions){if(!this.tableStreamArn)throw new Error(`DynamoDB Streams must be enabled on the table ${this.node.path}`);return iam.Grant.addToPrincipal({grantee,actions,resourceArns:[this.tableStreamArn],scope:this})}grantReadData(grantee){const tableActions=perms.READ_DATA_ACTIONS.concat(perms.DESCRIBE_TABLE);return this.combinedGrant(grantee,{keyActions:perms.KEY_READ_ACTIONS,tableActions})}grantTableListStreams(grantee){if(!this.tableStreamArn)throw new Error(`DynamoDB Streams must be enabled on the table ${this.node.path}`);return iam.Grant.addToPrincipal({grantee,actions:["dynamodb:ListStreams"],resourceArns:["*"]})}grantStreamRead(grantee){return this.grantTableListStreams(grantee),this.combinedGrant(grantee,{keyActions:perms.KEY_READ_ACTIONS,streamActions:perms.READ_STREAM_DATA_ACTIONS})}grantWriteData(grantee){const tableActions=perms.WRITE_DATA_ACTIONS.concat(perms.DESCRIBE_TABLE),keyActions=perms.KEY_READ_ACTIONS.concat(perms.KEY_WRITE_ACTIONS);return this.combinedGrant(grantee,{keyActions,tableActions})}grantReadWriteData(grantee){const tableActions=perms.READ_DATA_ACTIONS.concat(perms.WRITE_DATA_ACTIONS).concat(perms.DESCRIBE_TABLE),keyActions=perms.KEY_READ_ACTIONS.concat(perms.KEY_WRITE_ACTIONS);return this.combinedGrant(grantee,{keyActions,tableActions})}grantFullAccess(grantee){const keyActions=perms.KEY_READ_ACTIONS.concat(perms.KEY_WRITE_ACTIONS);return this.combinedGrant(grantee,{keyActions,tableActions:["dynamodb:*"]})}metric(metricName,props){return new cloudwatch.Metric({namespace:"AWS/DynamoDB",metricName,dimensionsMap:{TableName:this.tableName},...props}).attachTo(this)}metricConsumedReadCapacityUnits(props){return this.cannedMetric(dynamodb_canned_metrics_generated_1.DynamoDBMetrics.consumedReadCapacityUnitsSum,props)}metricConsumedWriteCapacityUnits(props){return this.cannedMetric(dynamodb_canned_metrics_generated_1.DynamoDBMetrics.consumedWriteCapacityUnitsSum,props)}metricSystemErrors(props){if(!props?.dimensions?.Operation&&!props?.dimensionsMap?.Operation)throw new Error("'Operation' dimension must be passed for the 'SystemErrors' metric.");const dimensionsMap={TableName:this.tableName,...props?.dimensions??{},...props?.dimensionsMap??{}};return this.metric("SystemErrors",{statistic:"sum",...props,dimensionsMap})}metricUserErrors(props){if(props?.dimensions)throw new Error("'dimensions' is not supported for the 'UserErrors' metric");return this.metric("UserErrors",{statistic:"sum",...props,dimensionsMap:{}})}metricConditionalCheckFailedRequests(props){return this.metric("ConditionalCheckFailedRequests",{statistic:"sum",...props})}metricThrottledRequests(props){return this.metric("ThrottledRequests",{statistic:"sum",...props})}metricSuccessfulRequestLatency(props){if(!props?.dimensions?.Operation&&!props?.dimensionsMap?.Operation)throw new Error("'Operation' dimension must be passed for the 'SuccessfulRequestLatency' metric.");const dimensionsMap={TableName:this.tableName,Operation:props.dimensionsMap?.Operation??props.dimensions?.Operation};return new cloudwatch.Metric({...dynamodb_canned_metrics_generated_1.DynamoDBMetrics.successfulRequestLatencyAverage(dimensionsMap),...props,dimensionsMap}).attachTo(this)}metricThrottledRequestsForOperation(operation,props){return new cloudwatch.Metric({...dynamodb_canned_metrics_generated_1.DynamoDBMetrics.throttledRequestsSum({Operation:operation,TableName:this.tableName}),...props}).attachTo(this)}metricThrottledRequestsForOperations(props){return this.sumMetricsForOperations("ThrottledRequests","Sum of throttled requests across all operations",props)}metricSystemErrorsForOperations(props){return this.sumMetricsForOperations("SystemErrors","Sum of errors across all operations",props)}sumMetricsForOperations(metricName,expressionLabel,props){if(props?.dimensions?.Operation)throw new Error("The Operation dimension is not supported. Use the 'operations' property.");const operations=props?.operations??Object.values(Operation),values=this.createMetricsForOperations(metricName,operations,{statistic:"sum",...props});return new cloudwatch.MathExpression({expression:`${Object.keys(values).join(" + ")}`,usingMetrics:{...values},color:props?.color,label:expressionLabel,period:props?.period})}createMetricsForOperations(metricName,operations,props,metricNameMapper){const metrics={},mapper=metricNameMapper??(op=>op.toLowerCase());if(props?.dimensions?.Operation)throw new Error("Invalid properties. Operation dimension is not supported when calculating operational metrics");for(const operation of operations){const metric=this.metric(metricName,{...props,dimensionsMap:{TableName:this.tableName,Operation:operation,...props?.dimensions}}),operationMetricName=mapper(operation),firstChar=operationMetricName.charAt(0);if(firstChar===firstChar.toUpperCase())throw new Error(`Mapper generated an illegal operation metric name: ${operationMetricName}. Must start with a lowercase letter`);metrics[operationMetricName]=metric}return metrics}combinedGrant(grantee,opts){if(this.encryptionKey&&opts.keyActions&&this.encryptionKey.grant(grantee,...opts.keyActions),opts.tableActions){const resources=[this.tableArn,core_1.Lazy.string({produce:()=>this.hasIndex?`${this.tableArn}/index/*`:core_1.Aws.NO_VALUE}),...this.regionalArns,...this.regionalArns.map(arn=>core_1.Lazy.string({produce:()=>this.hasIndex?`${arn}/index/*`:core_1.Aws.NO_VALUE}))];return iam.Grant.addToPrincipal({grantee,actions:opts.tableActions,resourceArns:resources,scope:this})}if(opts.streamActions){if(!this.tableStreamArn)throw new Error(`DynamoDB Streams must be enabled on the table ${this.node.path}`);const resources=[this.tableStreamArn];return iam.Grant.addToPrincipal({grantee,actions:opts.streamActions,resourceArns:resources,scope:this})}throw new Error(`Unexpected 'action', ${opts.tableActions||opts.streamActions}`)}cannedMetric(fn,props){return new cloudwatch.Metric({...fn({TableName:this.tableName}),...props}).attachTo(this)}}class Table extends TableBase{constructor(scope,id,props){super(scope,id,{physicalName:props.tableName}),this.keySchema=new Array,this.attributeDefinitions=new Array,this.globalSecondaryIndexes=new Array,this.localSecondaryIndexes=new Array,this.secondaryIndexSchemas=new Map,this.nonKeyAttributes=new Set,this.tableScaling={},this.indexScaling=new Map,this.globalReplicaCustomResources=new Array;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_dynamodb_TableProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Table),error}const{sseSpecification,encryptionKey}=this.parseEncryption(props);let streamSpecification;if(props.replicationRegions){if(props.stream&&props.stream!==StreamViewType.NEW_AND_OLD_IMAGES)throw new Error("`stream` must be set to `NEW_AND_OLD_IMAGES` when specifying `replicationRegions`");streamSpecification={streamViewType:StreamViewType.NEW_AND_OLD_IMAGES},this.billingMode=props.billingMode??BillingMode.PAY_PER_REQUEST}else this.billingMode=props.billingMode??BillingMode.PROVISIONED,props.stream&&(streamSpecification={streamViewType:props.stream});this.validateProvisioning(props),this.table=new dynamodb_generated_1.CfnTable(this,"Resource",{tableName:this.physicalName,keySchema:this.keySchema,attributeDefinitions:this.attributeDefinitions,globalSecondaryIndexes:core_1.Lazy.any({produce:()=>this.globalSecondaryIndexes},{omitEmptyArray:!0}),localSecondaryIndexes:core_1.Lazy.any({produce:()=>this.localSecondaryIndexes},{omitEmptyArray:!0}),pointInTimeRecoverySpecification:props.pointInTimeRecovery!=null?{pointInTimeRecoveryEnabled:props.pointInTimeRecovery}:void 0,billingMode:this.billingMode===BillingMode.PAY_PER_REQUEST?this.billingMode:void 0,provisionedThroughput:this.billingMode===BillingMode.PAY_PER_REQUEST?void 0:{readCapacityUnits:props.readCapacity||5,writeCapacityUnits:props.writeCapacity||5},sseSpecification,streamSpecification,tableClass:props.tableClass,timeToLiveSpecification:props.timeToLiveAttribute?{attributeName:props.timeToLiveAttribute,enabled:!0}:void 0,contributorInsightsSpecification:props.contributorInsightsEnabled!==void 0?{enabled:props.contributorInsightsEnabled}:void 0,kinesisStreamSpecification:props.kinesisStream?{streamArn:props.kinesisStream.streamArn}:void 0}),this.table.applyRemovalPolicy(props.removalPolicy),this.encryptionKey=encryptionKey,this.tableArn=this.getResourceArnAttribute(this.table.attrArn,{service:"dynamodb",resource:"table",resourceName:this.physicalName}),this.tableName=this.getResourceNameAttribute(this.table.ref),props.tableName&&this.node.addMetadata("aws:cdk:hasPhysicalName",this.tableName),this.tableStreamArn=streamSpecification?this.table.attrStreamArn:void 0,this.scalingRole=this.makeScalingRole(),this.addKey(props.partitionKey,HASH_KEY_TYPE),this.tablePartitionKey=props.partitionKey,props.sortKey&&(this.addKey(props.sortKey,RANGE_KEY_TYPE),this.tableSortKey=props.sortKey),props.replicationRegions&&props.replicationRegions.length>0&&this.createReplicaTables(props.replicationRegions,props.replicationTimeout,props.waitForReplicationToFinish),this.node.addValidation({validate:()=>this.validateTable()})}static grantListStreams(grantee){return iam.Grant.addToPrincipal({grantee,actions:["dynamodb:ListStreams"],resourceArns:["*"]})}static fromTableName(scope,id,tableName){return Table.fromTableAttributes(scope,id,{tableName})}static fromTableArn(scope,id,tableArn){return Table.fromTableAttributes(scope,id,{tableArn})}static fromTableAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_dynamodb_TableAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromTableAttributes),error}class Import extends TableBase{constructor(_tableArn,tableName,tableStreamArn){super(scope,id),this.hasIndex=(attrs.grantIndexPermissions??!1)||(attrs.globalIndexes??[]).length>0||(attrs.localIndexes??[]).length>0,this.tableArn=_tableArn,this.tableName=tableName,this.tableStreamArn=tableStreamArn,this.encryptionKey=attrs.encryptionKey}}let name,arn;const stack=core_1.Stack.of(scope);if(attrs.tableName){if(attrs.tableArn)throw new Error("Only one of tableArn or tableName can be provided");name=attrs.tableName,arn=stack.formatArn({service:"dynamodb",resource:"table",resourceName:attrs.tableName})}else{if(!attrs.tableArn)throw new Error("One of tableName or tableArn is required!");arn=attrs.tableArn;const maybeTableName=stack.splitArn(attrs.tableArn,core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;if(!maybeTableName)throw new Error("ARN for DynamoDB table must be in the form: ...");name=maybeTableName}return new Import(arn,name,attrs.tableStreamArn)}addGlobalSecondaryIndex(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_dynamodb_GlobalSecondaryIndexProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addGlobalSecondaryIndex),error}this.validateProvisioning(props),this.validateIndexName(props.indexName);const gsiKeySchema=this.buildIndexKeySchema(props.partitionKey,props.sortKey),gsiProjection=this.buildIndexProjection(props);this.globalSecondaryIndexes.push({indexName:props.indexName,keySchema:gsiKeySchema,projection:gsiProjection,provisionedThroughput:this.billingMode===BillingMode.PAY_PER_REQUEST?void 0:{readCapacityUnits:props.readCapacity||5,writeCapacityUnits:props.writeCapacity||5}}),this.secondaryIndexSchemas.set(props.indexName,{partitionKey:props.partitionKey,sortKey:props.sortKey}),this.indexScaling.set(props.indexName,{})}addLocalSecondaryIndex(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_dynamodb_LocalSecondaryIndexProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addLocalSecondaryIndex),error}if(this.localSecondaryIndexes.length>=MAX_LOCAL_SECONDARY_INDEX_COUNT)throw new RangeError(`a maximum number of local secondary index per table is ${MAX_LOCAL_SECONDARY_INDEX_COUNT}`);this.validateIndexName(props.indexName);const lsiKeySchema=this.buildIndexKeySchema(this.tablePartitionKey,props.sortKey),lsiProjection=this.buildIndexProjection(props);this.localSecondaryIndexes.push({indexName:props.indexName,keySchema:lsiKeySchema,projection:lsiProjection}),this.secondaryIndexSchemas.set(props.indexName,{partitionKey:this.tablePartitionKey,sortKey:props.sortKey})}autoScaleReadCapacity(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_dynamodb_EnableScalingProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.autoScaleReadCapacity),error}if(this.tableScaling.scalableReadAttribute)throw new Error("Read AutoScaling already enabled for this table");if(this.billingMode===BillingMode.PAY_PER_REQUEST)throw new Error("AutoScaling is not available for tables with PAY_PER_REQUEST billing mode");return this.tableScaling.scalableReadAttribute=new scalable_table_attribute_1.ScalableTableAttribute(this,"ReadScaling",{serviceNamespace:appscaling.ServiceNamespace.DYNAMODB,resourceId:`table/${this.tableName}`,dimension:"dynamodb:table:ReadCapacityUnits",role:this.scalingRole,...props})}autoScaleWriteCapacity(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_dynamodb_EnableScalingProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.autoScaleWriteCapacity),error}if(this.tableScaling.scalableWriteAttribute)throw new Error("Write AutoScaling already enabled for this table");if(this.billingMode===BillingMode.PAY_PER_REQUEST)throw new Error("AutoScaling is not available for tables with PAY_PER_REQUEST billing mode");this.tableScaling.scalableWriteAttribute=new scalable_table_attribute_1.ScalableTableAttribute(this,"WriteScaling",{serviceNamespace:appscaling.ServiceNamespace.DYNAMODB,resourceId:`table/${this.tableName}`,dimension:"dynamodb:table:WriteCapacityUnits",role:this.scalingRole,...props});for(const globalReplicaCustomResource of this.globalReplicaCustomResources)globalReplicaCustomResource.node.addDependency(this.tableScaling.scalableWriteAttribute);return this.tableScaling.scalableWriteAttribute}autoScaleGlobalSecondaryIndexReadCapacity(indexName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_dynamodb_EnableScalingProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.autoScaleGlobalSecondaryIndexReadCapacity),error}if(this.billingMode===BillingMode.PAY_PER_REQUEST)throw new Error("AutoScaling is not available for tables with PAY_PER_REQUEST billing mode");const attributePair=this.indexScaling.get(indexName);if(!attributePair)throw new Error(`No global secondary index with name ${indexName}`);if(attributePair.scalableReadAttribute)throw new Error("Read AutoScaling already enabled for this index");return attributePair.scalableReadAttribute=new scalable_table_attribute_1.ScalableTableAttribute(this,`${indexName}ReadScaling`,{serviceNamespace:appscaling.ServiceNamespace.DYNAMODB,resourceId:`table/${this.tableName}/index/${indexName}`,dimension:"dynamodb:index:ReadCapacityUnits",role:this.scalingRole,...props})}autoScaleGlobalSecondaryIndexWriteCapacity(indexName,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_dynamodb_EnableScalingProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.autoScaleGlobalSecondaryIndexWriteCapacity),error}if(this.billingMode===BillingMode.PAY_PER_REQUEST)throw new Error("AutoScaling is not available for tables with PAY_PER_REQUEST billing mode");const attributePair=this.indexScaling.get(indexName);if(!attributePair)throw new Error(`No global secondary index with name ${indexName}`);if(attributePair.scalableWriteAttribute)throw new Error("Write AutoScaling already enabled for this index");return attributePair.scalableWriteAttribute=new scalable_table_attribute_1.ScalableTableAttribute(this,`${indexName}WriteScaling`,{serviceNamespace:appscaling.ServiceNamespace.DYNAMODB,resourceId:`table/${this.tableName}/index/${indexName}`,dimension:"dynamodb:index:WriteCapacityUnits",role:this.scalingRole,...props})}schema(indexName){if(!indexName)return{partitionKey:this.tablePartitionKey,sortKey:this.tableSortKey};let schema=this.secondaryIndexSchemas.get(indexName);if(!schema)throw new Error(`Cannot find schema for index: ${indexName}. Use 'addGlobalSecondaryIndex' or 'addLocalSecondaryIndex' to add index`);return schema}validateTable(){const errors=new Array;if(this.tablePartitionKey||errors.push("a partition key must be specified"),this.localSecondaryIndexes.length>0&&!this.tableSortKey&&errors.push("a sort key of the table must be specified to add local secondary indexes"),this.globalReplicaCustomResources.length>0&&this.billingMode===BillingMode.PROVISIONED){const writeAutoScaleAttribute=this.tableScaling.scalableWriteAttribute;writeAutoScaleAttribute?writeAutoScaleAttribute._scalingPolicyCreated||errors.push("A global Table that uses PROVISIONED as the billing mode needs auto-scaled write capacity with a policy. Call one of the scaleOn*() methods of the object returned from autoScaleWriteCapacity()"):errors.push("A global Table that uses PROVISIONED as the billing mode needs auto-scaled write capacity. Use the autoScaleWriteCapacity() method to enable it.")}return errors}validateProvisioning(props){if(this.billingMode===BillingMode.PAY_PER_REQUEST&&(props.readCapacity!==void 0||props.writeCapacity!==void 0))throw new Error("you cannot provision read and write capacity for a table with PAY_PER_REQUEST billing mode")}validateIndexName(indexName){if(this.secondaryIndexSchemas.has(indexName))throw new Error(`a duplicate index name, ${indexName}, is not allowed`)}validateNonKeyAttributes(nonKeyAttributes){if(this.nonKeyAttributes.size+nonKeyAttributes.length>100)throw new RangeError("a maximum number of nonKeyAttributes across all of secondary indexes is 100");nonKeyAttributes.forEach(att=>this.nonKeyAttributes.add(att))}buildIndexKeySchema(partitionKey,sortKey){this.registerAttribute(partitionKey);const indexKeySchema=[{attributeName:partitionKey.name,keyType:HASH_KEY_TYPE}];return sortKey&&(this.registerAttribute(sortKey),indexKeySchema.push({attributeName:sortKey.name,keyType:RANGE_KEY_TYPE})),indexKeySchema}buildIndexProjection(props){if(props.projectionType===ProjectionType.INCLUDE&&!props.nonKeyAttributes)throw new Error(`non-key attributes should be specified when using ${ProjectionType.INCLUDE} projection type`);if(props.projectionType!==ProjectionType.INCLUDE&&props.nonKeyAttributes)throw new Error(`non-key attributes should not be specified when not using ${ProjectionType.INCLUDE} projection type`);return props.nonKeyAttributes&&this.validateNonKeyAttributes(props.nonKeyAttributes),{projectionType:props.projectionType??ProjectionType.ALL,nonKeyAttributes:props.nonKeyAttributes??void 0}}findKey(keyType){return this.keySchema.find(prop=>prop.keyType===keyType)}addKey(attribute,keyType){const existingProp=this.findKey(keyType);if(existingProp)throw new Error(`Unable to set ${attribute.name} as a ${keyType} key, because ${existingProp.attributeName} is a ${keyType} key`);return this.registerAttribute(attribute),this.keySchema.push({attributeName:attribute.name,keyType}),this}registerAttribute(attribute){const{name,type}=attribute,existingDef=this.attributeDefinitions.find(def=>def.attributeName===name);if(existingDef&&existingDef.attributeType!==type)throw new Error(`Unable to specify ${name} as ${type} because it was already defined as ${existingDef.attributeType}`);existingDef||this.attributeDefinitions.push({attributeName:name,attributeType:type})}makeScalingRole(){return iam.Role.fromRoleArn(this,"ScalingRole",core_1.Stack.of(this).formatArn({service:"iam",region:"",resource:"role/aws-service-role/dynamodb.application-autoscaling.amazonaws.com",resourceName:"AWSServiceRoleForApplicationAutoScaling_DynamoDBTable"}))}createReplicaTables(regions,timeout,waitForReplicationToFinish){const stack=core_1.Stack.of(this);if(!core_1.Token.isUnresolved(stack.region)&&regions.includes(stack.region))throw new Error("`replicationRegions` cannot include the region where this stack is deployed.");const provider=replica_provider_1.ReplicaProvider.getOrCreate(this,{timeout}),onEventHandlerPolicy=new SourceTableAttachedPolicy(this,provider.onEventHandler.role),isCompleteHandlerPolicy=new SourceTableAttachedPolicy(this,provider.isCompleteHandler.role);this.grant(onEventHandlerPolicy,"dynamodb:*"),this.grant(isCompleteHandlerPolicy,"dynamodb:DescribeTable");let previousRegion,previousRegionCondition;for(const region of new Set(regions)){const currentRegion=new core_1.CustomResource(this,`Replica${region}`,{serviceToken:provider.provider.serviceToken,resourceType:"Custom::DynamoDBReplica",properties:{TableName:this.tableName,Region:region,SkipReplicationCompletedWait:waitForReplicationToFinish==null?void 0:(!waitForReplicationToFinish).toString()}});currentRegion.node.addDependency(onEventHandlerPolicy.policy,isCompleteHandlerPolicy.policy),this.globalReplicaCustomResources.push(currentRegion);let createReplica;if(core_1.Token.isUnresolved(stack.region)){createReplica=new core_1.CfnCondition(this,`StackRegionNotEquals${region}`,{expression:core_1.Fn.conditionNot(core_1.Fn.conditionEquals(region,core_1.Aws.REGION))});const cfnCustomResource=currentRegion.node.defaultChild;cfnCustomResource.cfnOptions.condition=createReplica}if(this.regionalArns.push(stack.formatArn({region,service:"dynamodb",resource:"table",resourceName:this.tableName})),previousRegion)if(previousRegionCondition){const previousRegionCfnResource=previousRegion.node.defaultChild;currentRegion.node.defaultChild.addMetadata("DynamoDbReplicationDependency",core_1.Fn.conditionIf(previousRegionCondition.logicalId,previousRegionCfnResource.ref,core_1.Aws.NO_VALUE))}else currentRegion.node.addDependency(previousRegion);previousRegion=currentRegion,previousRegionCondition=createReplica}onEventHandlerPolicy.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({actions:["dynamodb:*"],resources:this.regionalArns}))}get hasIndex(){return this.globalSecondaryIndexes.length+this.localSecondaryIndexes.length>0}parseEncryption(props){let encryptionType=props.encryption;if(encryptionType!=null&&props.serverSideEncryption!=null)throw new Error("Only one of encryption and serverSideEncryption can be specified, but both were provided");if(props.serverSideEncryption&&props.encryptionKey)throw new Error("encryptionKey cannot be specified when serverSideEncryption is specified. Use encryption instead");if(encryptionType===void 0&&(encryptionType=props.encryptionKey!=null?TableEncryption.CUSTOMER_MANAGED:props.serverSideEncryption?TableEncryption.AWS_MANAGED:void 0),encryptionType!==TableEncryption.CUSTOMER_MANAGED&&props.encryptionKey)throw new Error("`encryptionKey cannot be specified unless encryption is set to TableEncryption.CUSTOMER_MANAGED (it was set to ${encryptionType})`");if(encryptionType===TableEncryption.CUSTOMER_MANAGED&&props.replicationRegions)throw new Error("TableEncryption.CUSTOMER_MANAGED is not supported by DynamoDB Global Tables (where replicationRegions was set)");switch(encryptionType){case TableEncryption.CUSTOMER_MANAGED:const encryptionKey=props.encryptionKey??new kms.Key(this,"Key",{description:`Customer-managed key auto-created for encrypting DynamoDB table at ${this.node.path}`,enableKeyRotation:!0});return{sseSpecification:{sseEnabled:!0,kmsMasterKeyId:encryptionKey.keyArn,sseType:"KMS"},encryptionKey};case TableEncryption.AWS_MANAGED:return{sseSpecification:{sseEnabled:!0}};case TableEncryption.DEFAULT:return{sseSpecification:{sseEnabled:!1}};case void 0:return{sseSpecification:void 0};default:throw new Error(`Unexpected 'encryptionType': ${encryptionType}`)}}}exports.Table=Table,_a=JSII_RTTI_SYMBOL_1,Table[_a]={fqn:"aws-cdk-lib.aws_dynamodb.Table",version:"2.69.0"};var AttributeType;(function(AttributeType2){AttributeType2.BINARY="B",AttributeType2.NUMBER="N",AttributeType2.STRING="S"})(AttributeType=exports.AttributeType||(exports.AttributeType={}));var BillingMode;(function(BillingMode2){BillingMode2.PAY_PER_REQUEST="PAY_PER_REQUEST",BillingMode2.PROVISIONED="PROVISIONED"})(BillingMode=exports.BillingMode||(exports.BillingMode={}));var ProjectionType;(function(ProjectionType2){ProjectionType2.KEYS_ONLY="KEYS_ONLY",ProjectionType2.INCLUDE="INCLUDE",ProjectionType2.ALL="ALL"})(ProjectionType=exports.ProjectionType||(exports.ProjectionType={}));var StreamViewType;(function(StreamViewType2){StreamViewType2.NEW_IMAGE="NEW_IMAGE",StreamViewType2.OLD_IMAGE="OLD_IMAGE",StreamViewType2.NEW_AND_OLD_IMAGES="NEW_AND_OLD_IMAGES",StreamViewType2.KEYS_ONLY="KEYS_ONLY"})(StreamViewType=exports.StreamViewType||(exports.StreamViewType={}));var TableClass;(function(TableClass2){TableClass2.STANDARD="STANDARD",TableClass2.STANDARD_INFREQUENT_ACCESS="STANDARD_INFREQUENT_ACCESS"})(TableClass=exports.TableClass||(exports.TableClass={}));class SourceTableAttachedPolicy extends constructs_1.Construct{constructor(sourceTable,role){super(sourceTable,`SourceTableAttachedManagedPolicy-${core_1.Names.nodeUniqueId(role.node)}`);const policy=new iam.ManagedPolicy(this,"Resource",{description:`DynamoDB replication managed policy for table ${sourceTable.tableName}`,roles:[role]});this.policy=policy,this.grantPrincipal=new SourceTableAttachedPrincipal(role,policy)}}class SourceTableAttachedPrincipal extends iam.PrincipalBase{constructor(role,policy){super(),this.role=role,this.policy=policy}get policyFragment(){return this.role.policyFragment}addToPrincipalPolicy(statement){return this.policy.addStatements(statement),{policyDependable:this.policy,statementAdded:!0}}dedupeString(){}}
