"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const codecommit=require("../../aws-codecommit"),codepipeline=require("../../aws-codepipeline"),cdk=require("../../core"),cpactions=require("../lib"),app=new cdk.App,stack=new cdk.Stack(app,"aws-cdk-codepipeline-cloudformation"),repo=new codecommit.Repository(stack,"TemplateRepo",{repositoryName:"template-repo"}),sourceOutput=new codepipeline.Artifact("SourceArtifact"),source=new cpactions.CodeCommitSourceAction({actionName:"Source",repository:repo,output:sourceOutput,trigger:cpactions.CodeCommitTrigger.POLL}),sourceStage={stageName:"Source",actions:[source]},stackName="OurStack",changeSetName="StagedChangeSet",prodStage={stageName:"Deploy",actions:[new cpactions.CloudFormationCreateReplaceChangeSetAction({actionName:"PrepareChanges",stackName,changeSetName,adminPermissions:!0,templatePath:sourceOutput.atPath("template.yaml"),runOrder:1}),new cpactions.ManualApprovalAction({actionName:"ApproveChanges",runOrder:2}),new cpactions.CloudFormationExecuteChangeSetAction({actionName:"ExecuteChanges",stackName,changeSetName,runOrder:3})]};new codepipeline.Pipeline(stack,"Pipeline",{stages:[sourceStage,prodStage]}),app.synth();
