"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.TokenMap=void 0;const encoding_1=require("./encoding"),token_1=require("../token"),glob=global,STRING_SYMBOL=Symbol.for("@aws-cdk/core.TokenMap.STRING"),LIST_SYMBOL=Symbol.for("@aws-cdk/core.TokenMap.LIST"),NUMBER_SYMBOL=Symbol.for("@aws-cdk/core.TokenMap.NUMBER");class TokenMap{constructor(){this.stringTokenMap=new Map,this.numberTokenMap=new Map,this.tokenCounter=Math.floor(Math.random()*10)}static instance(){return glob.__cdkTokenMap||(glob.__cdkTokenMap=new TokenMap),glob.__cdkTokenMap}registerString(token,displayHint){return cachedValue(token,STRING_SYMBOL,()=>{const key=this.registerStringKey(token,displayHint);return`${encoding_1.BEGIN_STRING_TOKEN_MARKER}${key}${encoding_1.END_TOKEN_MARKER}`})}registerList(token,displayHint){return cachedValue(token,LIST_SYMBOL,()=>{const key=this.registerStringKey(token,displayHint);return[`${encoding_1.BEGIN_LIST_TOKEN_MARKER}${key}${encoding_1.END_TOKEN_MARKER}`]})}registerNumber(token){return cachedValue(token,NUMBER_SYMBOL,()=>this.registerNumberKey(token))}tokenFromEncoding(x){if(token_1.isResolvableObject(x))return x;if(typeof x=="string")return this.lookupString(x);if(Array.isArray(x))return this.lookupList(x);if(token_1.Token.isUnresolved(x))return x}lookupString(s){const fragments=this.splitString(s);if(fragments.tokens.length>0&&fragments.length===1)return fragments.firstToken}lookupList(xs){if(xs.length!==1)return;const fragments=encoding_1.TokenString.forListToken(xs[0]).split(this.lookupToken.bind(this));if(fragments.length===1)return fragments.firstToken}splitString(s){return encoding_1.TokenString.forString(s).split(this.lookupToken.bind(this))}lookupNumberToken(x){const tokenIndex=encoding_1.extractTokenDouble(x);if(tokenIndex===void 0)return;const t=this.numberTokenMap.get(tokenIndex);if(t===void 0)throw new Error("Encoded representation of unknown number Token found");return t}lookupToken(key){const token=this.stringTokenMap.get(key);if(!token)throw new Error(`Unrecognized token key: ${key}`);return token}registerStringKey(token,displayHint){const counter=this.tokenCounter++,key=`${(displayHint||"TOKEN").replace(new RegExp(`[^${encoding_1.VALID_KEY_CHARS}]`,"g"),".")}.${counter}`;return this.stringTokenMap.set(key,token),key}registerNumberKey(token){const counter=this.tokenCounter++,dbl=encoding_1.createTokenDouble(counter);return this.numberTokenMap.set(counter,token),this.stringTokenMap.set(`${dbl}`,token),dbl}}exports.TokenMap=TokenMap;function cachedValue(x,sym,prod){let cached=x[sym];return cached===void 0&&(cached=prod(),Object.defineProperty(x,sym,{value:cached})),cached}
