"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.handler=void 0;const aws_sdk_1=require("aws-sdk");async function handler(event){const props=event.ResourceProperties.WriterProps,exports2=props.exports,ssm=new aws_sdk_1.SSM({region:props.region});try{switch(event.RequestType){case"Create":console.info(`Creating new SSM Parameter exports in region ${props.region}`),await throwIfAnyInUse(ssm,exports2),await putParameters(ssm,exports2);return;case"Update":const oldExports=event.OldResourceProperties.WriterProps.exports,newExports=except(exports2,oldExports),changedExports=changed(oldExports,exports2);if(changedExports.length>0)throw new Error(`Some exports have changed!
`+changedExports.join(`
`));const removedExports=except(oldExports,exports2);await throwIfAnyInUse(ssm,removedExports);const removedExportsNames=Object.keys(removedExports);removedExportsNames.length>0&&await ssm.deleteParameters({Names:removedExportsNames}).promise(),await throwIfAnyInUse(ssm,newExports),console.info(`Creating new SSM Parameter exports in region ${props.region}`),await putParameters(ssm,newExports);return;case"Delete":await throwIfAnyInUse(ssm,exports2),await ssm.deleteParameters({Names:Object.keys(exports2)}).promise();return;default:return}}catch(e){throw console.error("Error processing event: ",e),e}}exports.handler=handler;async function putParameters(ssm,parameters){await Promise.all(Array.from(Object.entries(parameters),([name,value])=>ssm.putParameter({Name:name,Value:value,Type:"String"}).promise()))}async function throwIfAnyInUse(ssm,parameters){const tagResults=new Map;if(await Promise.all(Object.keys(parameters).map(async name=>{const result=await isInUse(ssm,name);result.size>0&&tagResults.set(name,result)})),tagResults.size>0){const message=Object.entries(tagResults).map(result=>`${result[0]} is in use by stack(s) ${result[1].join(" ")}`).join(`
`);throw new Error(`Exports cannot be updated: 
${message}`)}}async function isInUse(ssm,parameterName){const tagResults=new Set;try{(await ssm.listTagsForResource({ResourceId:parameterName,ResourceType:"Parameter"}).promise()).TagList?.forEach(tag=>{const tagParts=tag.Key.split(":");tagParts[0]==="aws-cdk"&&tagParts[1]==="strong-ref"&&tagResults.add(tagParts[2])})}catch(e){if(e.code==="InvalidResourceId")return new Set;throw e}return tagResults}function except(source,filter){return Object.keys(source).filter(key=>!filter.hasOwnProperty(key)).reduce((acc,curr)=>(acc[curr]=source[curr],acc),{})}function changed(oldParams,newParams){return Object.keys(oldParams).filter(key=>newParams.hasOwnProperty(key)&&oldParams[key]!==newParams[key]).reduce((acc,curr)=>(acc.push(curr),acc),[])}
