"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Manifest=exports.VERSION_MISMATCH=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),jsonschema=require("jsonschema"),semver=require("semver"),assembly=require("./cloud-assembly");exports.VERSION_MISMATCH="Cloud assembly schema version mismatch";const ASSETS_SCHEMA=require("../schema/assets.schema.json"),ASSEMBLY_SCHEMA=require("../schema/cloud-assembly.schema.json"),SCHEMA_VERSION=require("../schema/cloud-assembly.version.json").version,INTEG_SCHEMA=require("../schema/integ.schema.json");class Manifest{constructor(){}static saveAssemblyManifest(manifest,filePath){try{jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_AssemblyManifest(manifest)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.saveAssemblyManifest),error}Manifest.saveManifest(manifest,filePath,ASSEMBLY_SCHEMA,Manifest.patchStackTagsOnWrite)}static loadAssemblyManifest(filePath,options){try{jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_LoadManifestOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.loadAssemblyManifest),error}return Manifest.loadManifest(filePath,ASSEMBLY_SCHEMA,Manifest.patchStackTagsOnRead,options)}static saveAssetManifest(manifest,filePath){try{jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_AssetManifest(manifest)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.saveAssetManifest),error}Manifest.saveManifest(manifest,filePath,ASSETS_SCHEMA,Manifest.patchStackTagsOnRead)}static loadAssetManifest(filePath){return this.loadManifest(filePath,ASSETS_SCHEMA)}static saveIntegManifest(manifest,filePath){try{jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_IntegManifest(manifest)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.saveIntegManifest),error}Manifest.saveManifest(manifest,filePath,INTEG_SCHEMA)}static loadIntegManifest(filePath){return this.loadManifest(filePath,INTEG_SCHEMA)}static version(){return SCHEMA_VERSION}static save(manifest,filePath){return this.saveAssemblyManifest(manifest,filePath)}static load(filePath){return this.loadAssemblyManifest(filePath)}static validate(manifest,schema,options){function parseVersion(version){const ver=semver.valid(version);if(!ver)throw new Error(`Invalid semver string: "${version}"`);return ver}const maxSupported=parseVersion(Manifest.version()),actual=parseVersion(manifest.version);if(semver.gt(actual,maxSupported)&&!options?.skipVersionCheck)throw new Error(`${exports.VERSION_MISMATCH}: Maximum schema version supported is ${maxSupported}, but found ${actual}`);let errors=new jsonschema.Validator().validate(manifest,schema,{nestedErrors:!0,allowUnknownAttributes:!1}).errors;if(options?.skipEnumCheck&&(errors=stripEnumErrors(errors)),errors.length>0)throw new Error(`Invalid assembly manifest:
${errors.map(e=>e.stack).join(`
`)}`)}static saveManifest(manifest,filePath,schema,preprocess){let withVersion={...manifest,version:Manifest.version()};Manifest.validate(withVersion,schema),preprocess&&(withVersion=preprocess(withVersion)),fs.writeFileSync(filePath,JSON.stringify(withVersion,void 0,2))}static loadManifest(filePath,schema,preprocess,options){const contents=fs.readFileSync(filePath,{encoding:"utf-8"});let obj;try{obj=JSON.parse(contents)}catch(e){throw new Error(`${e.message}, while parsing ${JSON.stringify(contents)}`)}return preprocess&&(obj=preprocess(obj)),Manifest.validate(obj,schema,options),obj}static patchStackTagsOnRead(manifest){return Manifest.replaceStackTags(manifest,tags=>tags.map(diskTag=>({key:diskTag.Key,value:diskTag.Value})))}static patchStackTagsOnWrite(manifest){return Manifest.replaceStackTags(manifest,tags=>tags.map(memTag=>"Key"in memTag?memTag:{Key:memTag.key,Value:memTag.value}))}static replaceStackTags(manifest,fn){return noUndefined({...manifest,artifacts:mapValues(manifest.artifacts,artifact=>artifact.type!==assembly.ArtifactType.AWS_CLOUDFORMATION_STACK?artifact:noUndefined({...artifact,metadata:mapValues(artifact.metadata,metadataEntries=>metadataEntries.map(metadataEntry=>metadataEntry.type!==assembly.ArtifactMetadataEntryType.STACK_TAGS||!metadataEntry.data?metadataEntry:{...metadataEntry,data:fn(metadataEntry.data)}))}))})}}exports.Manifest=Manifest,_a=JSII_RTTI_SYMBOL_1,Manifest[_a]={fqn:"aws-cdk-lib.cloud_assembly_schema.Manifest",version:"2.69.0"};function mapValues(xs,fn){if(!xs)return;const ret={};for(const[k,v]of Object.entries(xs))ret[k]=fn(v);return ret}function noUndefined(xs){const ret={};for(const[k,v]of Object.entries(xs))v!==void 0&&(ret[k]=v);return ret}function stripEnumErrors(errors){return errors.filter(e=>typeof e.schema=="string"||!("enum"in e.schema))}
