import * as sns from '../../aws-sns';
import { IQueue } from '../../aws-sqs';
/**
 * Options to subscribing to an SNS topic
 */
export interface SubscriptionProps {
    /**
     * The filter policy.
     *
     * @default - all messages are delivered
     */
    readonly filterPolicy?: {
        [attribute: string]: sns.SubscriptionFilter;
    };
    /**
     * The filter policy that is applied on the message body.
     * To apply a filter policy to the message attributes, use `filterPolicy`. A maximum of one of `filterPolicyWithMessageBody` and `filterPolicy` may be used.
     *
     * @default - all messages are delivered
     */
    readonly filterPolicyWithMessageBody?: {
        [attribute: string]: sns.FilterOrPolicy;
    };
    /**
     * Queue to be used as dead letter queue.
     * If not passed no dead letter queue is enabled.
     *
     * @default - No dead letter queue enabled.
     */
    readonly deadLetterQueue?: IQueue;
}
