import { IResource, Resource } from '../../core';
import { Construct } from 'constructs';
/**
 * A dedicated IP pool
 */
export interface IDedicatedIpPool extends IResource {
    /**
     * The name of the dedicated IP pool
     *
     * @attribute
     */
    readonly dedicatedIpPoolName: string;
}
/**
 * Properties for a dedicated IP pool
 */
export interface DedicatedIpPoolProps {
    /**
     * A name for the dedicated IP pool
     *
     * @default - a CloudFormation generated name
     */
    readonly dedicatedIpPoolName?: string;
}
/**
 * A dedicated IP pool
 */
export declare class DedicatedIpPool extends Resource implements IDedicatedIpPool {
    /**
     * Use an existing dedicated IP pool
     */
    static fromDedicatedIpPoolName(scope: Construct, id: string, dedicatedIpPoolName: string): IDedicatedIpPool;
    readonly dedicatedIpPoolName: string;
    constructor(scope: Construct, id: string, props?: DedicatedIpPoolProps);
}
