"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SecretTargetAttachment=exports.AttachmentTargetType=exports.Secret=exports.SecretStringValueBeta1=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../aws-iam"),kms=require("../../aws-kms"),core_1=require("../../core"),cxapi=require("../../cx-api"),policy_1=require("./policy"),rotation_schedule_1=require("./rotation-schedule"),secretsmanager=require("./secretsmanager.generated"),SECRET_SYMBOL=Symbol.for("@aws-cdk/secretsmanager.Secret");class SecretStringValueBeta1{constructor(_secretValue){this._secretValue=_secretValue}static fromUnsafePlaintext(secretValue){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_secretsmanager.SecretStringValueBeta1#fromUnsafePlaintext","Use `cdk.SecretValue` instead.")}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromUnsafePlaintext),error}return new SecretStringValueBeta1(secretValue)}static fromToken(secretValueFromToken){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_secretsmanager.SecretStringValueBeta1#fromToken","Use `cdk.SecretValue` instead.")}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromToken),error}if(!core_1.Token.isUnresolved(secretValueFromToken))throw new Error("SecretStringValueBeta1 appears to be plaintext (unsafe) string (or resolved Token); use fromUnsafePlaintext if this is intentional");return new SecretStringValueBeta1(secretValueFromToken)}secretValue(){try{jsiiDeprecationWarnings.print("aws-cdk-lib.aws_secretsmanager.SecretStringValueBeta1#secretValue","Use `cdk.SecretValue` instead.")}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.secretValue),error}return this._secretValue}}exports.SecretStringValueBeta1=SecretStringValueBeta1,_a=JSII_RTTI_SYMBOL_1,SecretStringValueBeta1[_a]={fqn:"aws-cdk-lib.aws_secretsmanager.SecretStringValueBeta1",version:"2.69.0"};class SecretBase extends core_1.Resource{constructor(scope,id,props={}){super(scope,id,props),this.node.addValidation({validate:()=>this.policy?.document.validateForResourcePolicy()??[]})}get secretFullArn(){return this.secretArn}grantRead(grantee,versionStages){const result=iam.Grant.addToPrincipalOrResource({grantee,actions:["secretsmanager:GetSecretValue","secretsmanager:DescribeSecret"],resourceArns:[this.arnForPolicies],resource:this}),statement=result.principalStatement||result.resourceStatement;versionStages!=null&&statement&&statement.addCondition("ForAnyValue:StringEquals",{"secretsmanager:VersionStage":versionStages}),this.encryptionKey&&this.encryptionKey.grantDecrypt(new kms.ViaServicePrincipal(`secretsmanager.${core_1.Stack.of(this).region}.amazonaws.com`,grantee.grantPrincipal));const crossAccount=core_1.Token.compareStrings(core_1.Stack.of(this).account,grantee.grantPrincipal.principalAccount||"");if(this instanceof Secret&&result.resourceStatement&&!this.encryptionKey&&crossAccount===core_1.TokenComparison.DIFFERENT)throw new Error("KMS Key must be provided for cross account access to Secret");return result}grantWrite(grantee){const result=iam.Grant.addToPrincipalOrResource({grantee,actions:["secretsmanager:PutSecretValue","secretsmanager:UpdateSecret"],resourceArns:[this.arnForPolicies],resource:this});if(this.encryptionKey&&this.encryptionKey.grantEncrypt(new kms.ViaServicePrincipal(`secretsmanager.${core_1.Stack.of(this).region}.amazonaws.com`,grantee.grantPrincipal)),this instanceof Secret&&result.resourceStatement&&!this.encryptionKey)throw new Error("KMS Key must be provided for cross account access to Secret");return result}get secretValue(){return this.secretValueFromJson("")}secretValueFromJson(jsonField){return core_1.SecretValue.secretsManager(this.secretArn,{jsonField})}addRotationSchedule(id,options){return new rotation_schedule_1.RotationSchedule(this,id,{secret:this,...options})}addToResourcePolicy(statement){return!this.policy&&this.autoCreatePolicy&&(this.policy=new policy_1.ResourcePolicy(this,"Policy",{secret:this})),this.policy?(this.policy.document.addStatements(statement),{statementAdded:!0,policyDependable:this.policy}):{statementAdded:!1}}denyAccountRootDelete(){this.addToResourcePolicy(new iam.PolicyStatement({actions:["secretsmanager:DeleteSecret"],effect:iam.Effect.DENY,resources:["*"],principals:[new iam.AccountRootPrincipal]}))}get arnForPolicies(){return this.secretFullArn?this.secretFullArn:`${this.secretArn}-??????`}attach(target){const id="Attachment";if(this.node.tryFindChild(id))throw new Error("Secret is already attached to a target.");return new SecretTargetAttachment(this,id,{secret:this,target})}}class Secret extends SecretBase{constructor(scope,id,props={}){super(scope,id,{physicalName:props.secretName}),this.replicaRegions=[],this.autoCreatePolicy=!0;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_secretsmanager_SecretProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Secret),error}if(props.generateSecretString&&(props.generateSecretString.secretStringTemplate||props.generateSecretString.generateStringKey)&&!(props.generateSecretString.secretStringTemplate&&props.generateSecretString.generateStringKey))throw new Error("`secretStringTemplate` and `generateStringKey` must be specified together.");if((props.generateSecretString?1:0)+(props.secretStringBeta1?1:0)+(props.secretStringValue?1:0)+(props.secretObjectValue?1:0)>1)throw new Error("Cannot specify more than one of `generateSecretString`, `secretStringValue`, `secretObjectValue`, and `secretStringBeta1`.");const secretString=props.secretObjectValue?this.resolveSecretObjectValue(props.secretObjectValue):props.secretStringValue?.unsafeUnwrap()??props.secretStringBeta1?.secretValue(),resource=new secretsmanager.CfnSecret(this,"Resource",{description:props.description,kmsKeyId:props.encryptionKey&&props.encryptionKey.keyArn,generateSecretString:props.generateSecretString??(secretString?void 0:{}),secretString,name:this.physicalName,replicaRegions:core_1.Lazy.any({produce:()=>this.replicaRegions},{omitEmptyArray:!0})});resource.applyRemovalPolicy(props.removalPolicy,{default:core_1.RemovalPolicy.DESTROY}),this.secretArn=this.getResourceArnAttribute(resource.ref,{service:"secretsmanager",resource:"secret",resourceName:this.physicalName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME}),this.encryptionKey=props.encryptionKey;const parseOwnedSecretName=core_1.FeatureFlags.of(this).isEnabled(cxapi.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME);this.secretName=parseOwnedSecretName?parseSecretNameForOwnedSecret(this,this.secretArn,props.secretName):parseSecretName(this,this.secretArn);const principal=new kms.ViaServicePrincipal(`secretsmanager.${core_1.Stack.of(this).region}.amazonaws.com`,new iam.AccountPrincipal(core_1.Stack.of(this).account));this.encryptionKey?.grantEncryptDecrypt(principal),this.encryptionKey?.grant(principal,"kms:CreateGrant","kms:DescribeKey");for(const replica of props.replicaRegions??[])this.addReplicaRegion(replica.region,replica.encryptionKey);this.excludeCharacters=props.generateSecretString?.excludeCharacters}static isSecret(x){return x!==null&&typeof x=="object"&&SECRET_SYMBOL in x}static fromSecretArn(scope,id,secretArn){const attrs=arnIsComplete(secretArn)?{secretCompleteArn:secretArn}:{secretPartialArn:secretArn};return Secret.fromSecretAttributes(scope,id,attrs)}static fromSecretCompleteArn(scope,id,secretCompleteArn){return Secret.fromSecretAttributes(scope,id,{secretCompleteArn})}static fromSecretPartialArn(scope,id,secretPartialArn){return Secret.fromSecretAttributes(scope,id,{secretPartialArn})}static fromSecretName(scope,id,secretName){return new class extends SecretBase{constructor(){super(...arguments),this.encryptionKey=void 0,this.secretArn=secretName,this.secretName=secretName,this.autoCreatePolicy=!1}get secretFullArn(){}get arnForPolicies(){return core_1.Stack.of(this).formatArn({service:"secretsmanager",resource:"secret",resourceName:this.secretName+"*",arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})}}(scope,id)}static fromSecretNameV2(scope,id,secretName){return new class extends SecretBase{constructor(){super(...arguments),this.encryptionKey=void 0,this.secretName=secretName,this.secretArn=this.partialArn,this.autoCreatePolicy=!1}get secretFullArn(){}get partialArn(){return core_1.Stack.of(this).formatArn({service:"secretsmanager",resource:"secret",resourceName:secretName,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})}}(scope,id)}static fromSecretAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_secretsmanager_SecretAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSecretAttributes),error}let secretArn,secretArnIsPartial;if(attrs.secretArn){if(attrs.secretCompleteArn||attrs.secretPartialArn)throw new Error("cannot use `secretArn` with `secretCompleteArn` or `secretPartialArn`");secretArn=attrs.secretArn,secretArnIsPartial=!1}else{if(attrs.secretCompleteArn&&attrs.secretPartialArn||!attrs.secretCompleteArn&&!attrs.secretPartialArn)throw new Error("must use only one of `secretCompleteArn` or `secretPartialArn`");if(attrs.secretCompleteArn&&!arnIsComplete(attrs.secretCompleteArn))throw new Error("`secretCompleteArn` does not appear to be complete; missing 6-character suffix");[secretArn,secretArnIsPartial]=attrs.secretCompleteArn?[attrs.secretCompleteArn,!1]:[attrs.secretPartialArn,!0]}return new class extends SecretBase{constructor(){super(...arguments),this.encryptionKey=attrs.encryptionKey,this.secretArn=secretArn,this.secretName=parseSecretName(scope,secretArn),this.autoCreatePolicy=!1}get secretFullArn(){return secretArnIsPartial?void 0:secretArn}}(scope,id,{environmentFromArn:secretArn})}resolveSecretObjectValue(secretObject){const resolvedObject={};for(const[key,value]of Object.entries(secretObject))resolvedObject[key]=value.unsafeUnwrap();return JSON.stringify(resolvedObject)}addTargetAttachment(id,options){return new SecretTargetAttachment(this,id,{secret:this,...options})}addReplicaRegion(region,encryptionKey){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_IKey(encryptionKey)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addReplicaRegion),error}const stack=core_1.Stack.of(this);if(!core_1.Token.isUnresolved(stack.region)&&!core_1.Token.isUnresolved(region)&&region===stack.region)throw new Error("Cannot add the region where this stack is deployed as a replica region.");this.replicaRegions.push({region,kmsKeyId:encryptionKey?.keyArn})}}exports.Secret=Secret,_b=JSII_RTTI_SYMBOL_1,Secret[_b]={fqn:"aws-cdk-lib.aws_secretsmanager.Secret",version:"2.69.0"};var AttachmentTargetType;(function(AttachmentTargetType2){AttachmentTargetType2.RDS_DB_INSTANCE="AWS::RDS::DBInstance",AttachmentTargetType2.INSTANCE="deprecated_AWS::RDS::DBInstance",AttachmentTargetType2.RDS_DB_CLUSTER="AWS::RDS::DBCluster",AttachmentTargetType2.CLUSTER="deprecated_AWS::RDS::DBCluster",AttachmentTargetType2.RDS_DB_PROXY="AWS::RDS::DBProxy",AttachmentTargetType2.REDSHIFT_CLUSTER="AWS::Redshift::Cluster",AttachmentTargetType2.DOCDB_DB_INSTANCE="AWS::DocDB::DBInstance",AttachmentTargetType2.DOCDB_DB_CLUSTER="AWS::DocDB::DBCluster"})(AttachmentTargetType=exports.AttachmentTargetType||(exports.AttachmentTargetType={}));class SecretTargetAttachment extends SecretBase{constructor(scope,id,props){super(scope,id),this.autoCreatePolicy=!0;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_secretsmanager_SecretTargetAttachmentProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SecretTargetAttachment),error}this.attachedSecret=props.secret;const attachment=new secretsmanager.CfnSecretTargetAttachment(this,"Resource",{secretId:this.attachedSecret.secretArn,targetId:props.target.asSecretAttachmentTarget().targetId,targetType:attachmentTargetTypeToString(props.target.asSecretAttachmentTarget().targetType)});this.encryptionKey=this.attachedSecret.encryptionKey,this.secretName=this.attachedSecret.secretName,this.secretArn=attachment.ref,this.secretTargetAttachmentSecretArn=attachment.ref}static fromSecretTargetAttachmentSecretArn(scope,id,secretTargetAttachmentSecretArn){class Import extends SecretBase{constructor(){super(...arguments),this.secretArn=secretTargetAttachmentSecretArn,this.secretTargetAttachmentSecretArn=secretTargetAttachmentSecretArn,this.secretName=parseSecretName(scope,secretTargetAttachmentSecretArn),this.autoCreatePolicy=!1}}return new Import(scope,id)}addToResourcePolicy(statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addToResourcePolicy),error}return core_1.FeatureFlags.of(this).isEnabled(cxapi.SECRETS_MANAGER_TARGET_ATTACHMENT_RESOURCE_POLICY)?this.attachedSecret.addToResourcePolicy(statement):super.addToResourcePolicy(statement)}}exports.SecretTargetAttachment=SecretTargetAttachment,_c=JSII_RTTI_SYMBOL_1,SecretTargetAttachment[_c]={fqn:"aws-cdk-lib.aws_secretsmanager.SecretTargetAttachment",version:"2.69.0"};function parseSecretName(construct,secretArn){const resourceName=core_1.Stack.of(construct).splitArn(secretArn,core_1.ArnFormat.COLON_RESOURCE_NAME).resourceName;if(resourceName){if(core_1.Token.isUnresolved(resourceName))return resourceName;const lastHyphenIndex=resourceName.lastIndexOf("-");return lastHyphenIndex!==-1&&resourceName.slice(lastHyphenIndex+1).length===6?resourceName.slice(0,lastHyphenIndex):resourceName}throw new Error("invalid ARN format; no secret name provided")}function parseSecretNameForOwnedSecret(construct,secretArn,secretName){const resourceName=core_1.Stack.of(construct).splitArn(secretArn,core_1.ArnFormat.COLON_RESOURCE_NAME).resourceName;if(!resourceName)throw new Error("invalid ARN format; no secret name provided");if(secretName&&core_1.Token.isUnresolved(secretName))return secretName;const secretNameHyphenatedSegments=secretName?secretName.split("-").length:2,segmentIndexes=[...new Array(secretNameHyphenatedSegments)].map((_,i)=>i);return core_1.Fn.join("-",segmentIndexes.map(i=>core_1.Fn.select(i,core_1.Fn.split("-",resourceName))))}function arnIsComplete(secretArn){return core_1.Token.isUnresolved(secretArn)||/-[a-z0-9]{6}$/i.test(secretArn)}Object.defineProperty(Secret.prototype,SECRET_SYMBOL,{value:!0,enumerable:!1,writable:!1});function attachmentTargetTypeToString(x){switch(x){case AttachmentTargetType.RDS_DB_INSTANCE:case AttachmentTargetType.INSTANCE:return"AWS::RDS::DBInstance";case AttachmentTargetType.RDS_DB_CLUSTER:case AttachmentTargetType.CLUSTER:return"AWS::RDS::DBCluster";case AttachmentTargetType.RDS_DB_PROXY:return"AWS::RDS::DBProxy";case AttachmentTargetType.REDSHIFT_CLUSTER:return"AWS::Redshift::Cluster";case AttachmentTargetType.DOCDB_DB_INSTANCE:return"AWS::DocDB::DBInstance";case AttachmentTargetType.DOCDB_DB_CLUSTER:return"AWS::DocDB::DBCluster"}}
