"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.VpcEndpointServiceDomainName=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),core_1=require("../../core"),helpers_internal_1=require("../../core/lib/helpers-internal"),custom_resources_1=require("../../custom-resources"),constructs_1=require("constructs"),lib_1=require("../lib");class VpcEndpointServiceDomainName extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_route53_VpcEndpointServiceDomainNameProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,VpcEndpointServiceDomainName),error}const serviceUniqueId=core_1.Names.nodeUniqueId(props.endpointService.node),serviceId=props.endpointService.vpcEndpointServiceId;this.domainName=props.domainName,this.validateProps(props),VpcEndpointServiceDomainName.endpointServicesMap[serviceUniqueId]=this.domainName,VpcEndpointServiceDomainName.endpointServices.push(props.endpointService);const privateDnsConfiguration=this.getPrivateDnsConfiguration(serviceUniqueId,serviceId,this.domainName);this.verifyPrivateDnsConfiguration(privateDnsConfiguration,props.publicHostedZone),this.node.addDependency(props.endpointService)}validateProps(props){const serviceUniqueId=core_1.Names.nodeUniqueId(props.endpointService.node);if(serviceUniqueId in VpcEndpointServiceDomainName.endpointServicesMap){const endpoint=VpcEndpointServiceDomainName.endpointServicesMap[serviceUniqueId];throw new Error(`Cannot create a VpcEndpointServiceDomainName for service ${serviceUniqueId}, another VpcEndpointServiceDomainName (${endpoint}) is already associated with it`)}}getPrivateDnsConfiguration(serviceUniqueId,serviceId,privateDnsName){const enablePrivateDnsAction={service:"EC2",action:"modifyVpcEndpointServiceConfiguration",parameters:{ServiceId:serviceId,PrivateDnsName:privateDnsName},physicalResourceId:custom_resources_1.PhysicalResourceId.of(serviceUniqueId)},removePrivateDnsAction={service:"EC2",action:"modifyVpcEndpointServiceConfiguration",parameters:{ServiceId:serviceId,RemovePrivateDnsName:!0}},enable=new custom_resources_1.AwsCustomResource(this,"EnableDns",{onCreate:enablePrivateDnsAction,onUpdate:enablePrivateDnsAction,onDelete:removePrivateDnsAction,policy:custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({resources:[core_1.Fn.join(":",["arn",core_1.Stack.of(this).partition,"ec2",core_1.Stack.of(this).region,core_1.Stack.of(this).account,core_1.Fn.join("/",["vpc-endpoint-service",serviceId])])]}),installLatestAwsSdk:!1}),lookup=hashcode(core_1.Names.uniqueId(this)+serviceUniqueId+privateDnsName),retrieveNameValuePairAction={service:"EC2",action:"describeVpcEndpointServiceConfigurations",parameters:{ServiceIds:[serviceId]},physicalResourceId:custom_resources_1.PhysicalResourceId.of(lookup)},getNames=new custom_resources_1.AwsCustomResource(this,"GetNames",{onCreate:retrieveNameValuePairAction,onUpdate:retrieveNameValuePairAction,policy:custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({resources:custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE}),installLatestAwsSdk:!1});getNames.node.addDependency(enable);const name=getNames.getResponseField("ServiceConfigurations.0.PrivateDnsNameConfiguration.Name"),value=getNames.getResponseField("ServiceConfigurations.0.PrivateDnsNameConfiguration.Value");return{name,value,serviceId}}verifyPrivateDnsConfiguration(config,publicHostedZone){const verificationRecord=new lib_1.TxtRecord(this,"DnsVerificationRecord",{recordName:config.name,values:[config.value],zone:publicHostedZone}),startVerificationAction={service:"EC2",action:"startVpcEndpointServicePrivateDnsVerification",parameters:{ServiceId:config.serviceId},physicalResourceId:custom_resources_1.PhysicalResourceId.of(core_1.Fn.join(":",[config.name,config.value]))};new custom_resources_1.AwsCustomResource(this,"StartVerification",{onCreate:startVerificationAction,onUpdate:startVerificationAction,policy:custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({resources:[core_1.Fn.join(":",["arn",core_1.Stack.of(this).partition,"ec2",core_1.Stack.of(this).region,core_1.Stack.of(this).account,core_1.Fn.join("/",["vpc-endpoint-service",config.serviceId])])]}),installLatestAwsSdk:!1}).node.addDependency(verificationRecord)}}exports.VpcEndpointServiceDomainName=VpcEndpointServiceDomainName,_a=JSII_RTTI_SYMBOL_1,VpcEndpointServiceDomainName[_a]={fqn:"aws-cdk-lib.aws_route53.VpcEndpointServiceDomainName",version:"2.69.0"},VpcEndpointServiceDomainName.endpointServices=[],VpcEndpointServiceDomainName.endpointServicesMap={};function hashcode(s){return helpers_internal_1.md5hash(s)}
