"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.handler=void 0;const diff_1=require("./diff"),external_1=require("./external");async function handler(event){if(event.RequestType==="Create")return onCreate(event);if(event.RequestType==="Update")return onUpdate(event);if(event.RequestType==="Delete")return onDelete(event);throw new Error("invalid request type")}exports.handler=handler;async function onCreate(event){const issuerUrl=event.ResourceProperties.Url,thumbprints=(event.ResourceProperties.ThumbprintList??[]).sort(),clients=(event.ResourceProperties.ClientIDList??[]).sort();return thumbprints.length===0&&thumbprints.push(await external_1.external.downloadThumbprint(issuerUrl)),{PhysicalResourceId:(await external_1.external.createOpenIDConnectProvider({Url:issuerUrl,ClientIDList:clients,ThumbprintList:thumbprints})).OpenIDConnectProviderArn,Data:{Thumbprints:JSON.stringify(thumbprints)}}}async function onUpdate(event){const issuerUrl=event.ResourceProperties.Url,thumbprints=(event.ResourceProperties.ThumbprintList??[]).sort(),clients=(event.ResourceProperties.ClientIDList??[]).sort();if(event.OldResourceProperties.Url!==issuerUrl)return onCreate({...event,RequestType:"Create"});const providerArn=event.PhysicalResourceId;thumbprints.length===0&&thumbprints.push(await external_1.external.downloadThumbprint(issuerUrl)),external_1.external.log("updating thumbprint to",thumbprints),await external_1.external.updateOpenIDConnectProviderThumbprint({OpenIDConnectProviderArn:providerArn,ThumbprintList:thumbprints});const oldClients=(event.OldResourceProperties.ClientIDList||[]).sort(),diff=diff_1.arrayDiff(oldClients,clients);external_1.external.log(`client ID diff: ${JSON.stringify(diff)}`);for(const addClient of diff.adds)external_1.external.log(`adding client id "${addClient}" to provider ${providerArn}`),await external_1.external.addClientIDToOpenIDConnectProvider({OpenIDConnectProviderArn:providerArn,ClientID:addClient});for(const deleteClient of diff.deletes)external_1.external.log(`removing client id "${deleteClient}" from provider ${providerArn}`),await external_1.external.removeClientIDFromOpenIDConnectProvider({OpenIDConnectProviderArn:providerArn,ClientID:deleteClient});return{Data:{Thumbprints:JSON.stringify(thumbprints)}}}async function onDelete(deleteEvent){await external_1.external.deleteOpenIDConnectProvider({OpenIDConnectProviderArn:deleteEvent.PhysicalResourceId})}
