"use strict";var _a,_b,_c,_d;Object.defineProperty(exports,"__esModule",{value:!0}),exports.MachineImageType=exports.DefaultCapacityType=exports.CoreDnsComputeType=exports.CpuArch=exports.NodeType=exports.EksOptimizedImage=exports.Cluster=exports.ClusterLoggingTypes=exports.KubernetesVersion=exports.EndpointAccess=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),fs=require("fs"),path=require("path"),autoscaling=require("../../aws-autoscaling"),ec2=require("../../aws-ec2"),iam=require("../../aws-iam"),ssm=require("../../aws-ssm"),core_1=require("../../core"),constructs_1=require("constructs"),semver=require("semver"),YAML=require("yaml"),alb_controller_1=require("./alb-controller"),aws_auth_1=require("./aws-auth"),cluster_resource_1=require("./cluster-resource"),fargate_profile_1=require("./fargate-profile"),helm_chart_1=require("./helm-chart"),instance_types_1=require("./instance-types"),k8s_manifest_1=require("./k8s-manifest"),k8s_object_value_1=require("./k8s-object-value"),k8s_patch_1=require("./k8s-patch"),kubectl_provider_1=require("./kubectl-provider"),managed_nodegroup_1=require("./managed-nodegroup"),oidc_provider_1=require("./oidc-provider"),bottlerocket_1=require("./private/bottlerocket"),service_account_1=require("./service-account"),user_data_1=require("./user-data"),DEFAULT_CAPACITY_COUNT=2,DEFAULT_CAPACITY_TYPE=ec2.InstanceType.of(ec2.InstanceClass.M5,ec2.InstanceSize.LARGE);class EndpointAccess{constructor(_config){if(this._config=_config,!_config.publicAccess&&_config.publicCidrs&&_config.publicCidrs.length>0)throw new Error("CIDR blocks can only be configured when public access is enabled")}onlyFrom(...cidr){if(!this._config.privateAccess)throw new Error("Cannot restric public access to endpoint when private access is disabled. Use PUBLIC_AND_PRIVATE.onlyFrom() instead.");return new EndpointAccess({...this._config,publicCidrs:cidr})}}exports.EndpointAccess=EndpointAccess,_a=JSII_RTTI_SYMBOL_1,EndpointAccess[_a]={fqn:"aws-cdk-lib.aws_eks.EndpointAccess",version:"2.69.0"},EndpointAccess.PUBLIC=new EndpointAccess({privateAccess:!1,publicAccess:!0}),EndpointAccess.PRIVATE=new EndpointAccess({privateAccess:!0,publicAccess:!1}),EndpointAccess.PUBLIC_AND_PRIVATE=new EndpointAccess({privateAccess:!0,publicAccess:!0});class KubernetesVersion{constructor(version){this.version=version}static of(version){return new KubernetesVersion(version)}}exports.KubernetesVersion=KubernetesVersion,_b=JSII_RTTI_SYMBOL_1,KubernetesVersion[_b]={fqn:"aws-cdk-lib.aws_eks.KubernetesVersion",version:"2.69.0"},KubernetesVersion.V1_14=KubernetesVersion.of("1.14"),KubernetesVersion.V1_15=KubernetesVersion.of("1.15"),KubernetesVersion.V1_16=KubernetesVersion.of("1.16"),KubernetesVersion.V1_17=KubernetesVersion.of("1.17"),KubernetesVersion.V1_18=KubernetesVersion.of("1.18"),KubernetesVersion.V1_19=KubernetesVersion.of("1.19"),KubernetesVersion.V1_20=KubernetesVersion.of("1.20"),KubernetesVersion.V1_21=KubernetesVersion.of("1.21"),KubernetesVersion.V1_22=KubernetesVersion.of("1.22"),KubernetesVersion.V1_23=KubernetesVersion.of("1.23"),KubernetesVersion.V1_24=KubernetesVersion.of("1.24"),KubernetesVersion.V1_25=KubernetesVersion.of("1.25");var ClusterLoggingTypes;(function(ClusterLoggingTypes2){ClusterLoggingTypes2.API="api",ClusterLoggingTypes2.AUDIT="audit",ClusterLoggingTypes2.AUTHENTICATOR="authenticator",ClusterLoggingTypes2.CONTROLLER_MANAGER="controllerManager",ClusterLoggingTypes2.SCHEDULER="scheduler"})(ClusterLoggingTypes=exports.ClusterLoggingTypes||(exports.ClusterLoggingTypes={}));class ClusterBase extends core_1.Resource{addManifest(id,...manifest){return new k8s_manifest_1.KubernetesManifest(this,`manifest-${id}`,{cluster:this,manifest})}addHelmChart(id,options){return new helm_chart_1.HelmChart(this,`chart-${id}`,{cluster:this,...options})}addCdk8sChart(id,chart,options={}){const cdk8sChart=chart;if(typeof cdk8sChart.toJson!="function")throw new Error(`Invalid cdk8s chart. Must contain a 'toJson' method, but found ${typeof cdk8sChart.toJson}`);return new k8s_manifest_1.KubernetesManifest(this,id,{cluster:this,manifest:cdk8sChart.toJson(),...options})}addServiceAccount(id,options={}){return new service_account_1.ServiceAccount(this,id,{...options,cluster:this})}addSpotInterruptHandler(){return this._spotInterruptHandler||(this._spotInterruptHandler=this.addHelmChart("spot-interrupt-handler",{chart:"aws-node-termination-handler",version:"0.18.0",repository:"https://aws.github.io/eks-charts",namespace:"kube-system",values:{nodeSelector:{lifecycle:user_data_1.LifecycleLabel.SPOT}}})),this._spotInterruptHandler}connectAutoScalingGroupCapacity(autoScalingGroup,options){autoScalingGroup.connections.allowInternally(ec2.Port.allTraffic()),autoScalingGroup.connections.allowFrom(this,ec2.Port.tcp(443)),autoScalingGroup.connections.allowFrom(this,ec2.Port.tcpRange(1025,65535)),autoScalingGroup.connections.allowTo(this,ec2.Port.tcp(443)),autoScalingGroup.connections.allowToAnyIpv4(ec2.Port.allTcp()),autoScalingGroup.connections.allowToAnyIpv4(ec2.Port.allUdp()),autoScalingGroup.connections.allowToAnyIpv4(ec2.Port.allIcmp()),autoScalingGroup.addSecurityGroup(this.clusterSecurityGroup);const bootstrapEnabled=options.bootstrapEnabled??!0;if(options.bootstrapOptions&&!bootstrapEnabled)throw new Error('Cannot specify "bootstrapOptions" if "bootstrapEnabled" is false');if(bootstrapEnabled){const userData=options.machineImageType===MachineImageType.BOTTLEROCKET?user_data_1.renderBottlerocketUserData(this):user_data_1.renderAmazonLinuxUserData(this,autoScalingGroup,options.bootstrapOptions);autoScalingGroup.addUserData(...userData)}autoScalingGroup.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("AmazonEKSWorkerNodePolicy")),autoScalingGroup.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("AmazonEKS_CNI_Policy")),autoScalingGroup.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("AmazonEC2ContainerRegistryReadOnly")),core_1.Tags.of(autoScalingGroup).add(`kubernetes.io/cluster/${this.clusterName}`,"owned",{applyToLaunchedInstances:!0,excludeResourceTypes:["AWS::EC2::SecurityGroup"]});let mapRole=options.mapRole??!0;mapRole&&!(this instanceof Cluster)&&(core_1.Annotations.of(autoScalingGroup).addWarning("Auto-mapping aws-auth role for imported cluster is not supported, please map role manually"),mapRole=!1),mapRole?this.awsAuth.addRoleMapping(autoScalingGroup.role,{username:"system:node:{{EC2PrivateDNSName}}",groups:["system:bootstrappers","system:nodes"]}):new core_1.CfnOutput(autoScalingGroup,"InstanceRoleARN",{value:autoScalingGroup.role.roleArn});const addSpotInterruptHandler=options.spotInterruptHandler??!0;autoScalingGroup.spotPrice&&addSpotInterruptHandler&&this.addSpotInterruptHandler(),this instanceof Cluster&&this.albController&&constructs_1.Node.of(this.albController).addDependency(autoScalingGroup)}}class Cluster extends ClusterBase{constructor(scope,id,props){super(scope,id,{physicalName:props.clusterName}),this._fargateProfiles=[];try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_ClusterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Cluster),error}const stack=core_1.Stack.of(this);this.prune=props.prune??!0,this.vpc=props.vpc||new ec2.Vpc(this,"DefaultVpc");const kubectlVersion=new semver.SemVer(`${props.version.version}.0`);semver.gte(kubectlVersion,"1.22.0")&&!props.kubectlLayer&&core_1.Annotations.of(this).addWarning(`You created a cluster with Kubernetes Version ${props.version.version} without specifying the kubectlLayer property. This may cause failures as the kubectl version provided with aws-cdk-lib is 1.20, which is only guaranteed to be compatible with Kubernetes versions 1.19-1.21. Please provide a kubectlLayer from @aws-cdk/lambda-layer-kubectl-v${kubectlVersion.minor}.`),this.version=props.version,this.kubectlLambdaRole=props.kubectlLambdaRole?props.kubectlLambdaRole:void 0,this.tagSubnets(),this.role=props.role||new iam.Role(this,"Role",{assumedBy:new iam.ServicePrincipal("eks.amazonaws.com"),managedPolicies:[iam.ManagedPolicy.fromAwsManagedPolicyName("AmazonEKSClusterPolicy")]});const securityGroup=props.securityGroup||new ec2.SecurityGroup(this,"ControlPlaneSecurityGroup",{vpc:this.vpc,description:"EKS Control Plane Security Group"});this.vpcSubnets=props.vpcSubnets??[{subnetType:ec2.SubnetType.PUBLIC},{subnetType:ec2.SubnetType.PRIVATE_WITH_EGRESS}];const selectedSubnetIdsPerGroup=this.vpcSubnets.map(s=>this.vpc.selectSubnets(s).subnetIds);if(selectedSubnetIdsPerGroup.some(core_1.Token.isUnresolved)&&selectedSubnetIdsPerGroup.length>1)throw new Error("eks.Cluster: cannot select multiple subnet groups from a VPC imported from list tokens with unknown length. Select only one subnet group, pass a length to Fn.split, or switch to Vpc.fromLookup.");const subnetIds=Array.from(new Set(flatten(selectedSubnetIdsPerGroup)));this.logging=props.clusterLogging?{clusterLogging:[{enabled:!0,types:Object.values(props.clusterLogging)}]}:void 0,this.endpointAccess=props.endpointAccess??EndpointAccess.PUBLIC_AND_PRIVATE,this.kubectlEnvironment=props.kubectlEnvironment,this.kubectlLayer=props.kubectlLayer,this.awscliLayer=props.awscliLayer,this.kubectlMemory=props.kubectlMemory,this.onEventLayer=props.onEventLayer,this.clusterHandlerSecurityGroup=props.clusterHandlerSecurityGroup;const privateSubnets=this.selectPrivateSubnets().slice(0,16),publicAccessDisabled=!this.endpointAccess._config.publicAccess,publicAccessRestricted=!publicAccessDisabled&&this.endpointAccess._config.publicCidrs&&this.endpointAccess._config.publicCidrs.length!==0;if(privateSubnets.length===0&&publicAccessDisabled)throw new Error("Vpc must contain private subnets when public endpoint access is disabled");if(privateSubnets.length===0&&publicAccessRestricted)throw new Error("Vpc must contain private subnets when public endpoint access is restricted");const placeClusterHandlerInVpc=props.placeClusterHandlerInVpc??!1;if(placeClusterHandlerInVpc&&privateSubnets.length===0)throw new Error("Cannot place cluster handler in the VPC since no private subnets could be selected");if(props.clusterHandlerSecurityGroup&&!placeClusterHandlerInVpc)throw new Error("Cannot specify clusterHandlerSecurityGroup without placeClusterHandlerInVpc set to true");const resource=this._clusterResource=new cluster_resource_1.ClusterResource(this,"Resource",{name:this.physicalName,environment:props.clusterHandlerEnvironment,roleArn:this.role.roleArn,version:props.version.version,resourcesVpcConfig:{securityGroupIds:[securityGroup.securityGroupId],subnetIds},...props.secretsEncryptionKey?{encryptionConfig:[{provider:{keyArn:props.secretsEncryptionKey.keyArn},resources:["secrets"]}]}:{},kubernetesNetworkConfig:props.serviceIpv4Cidr?{serviceIpv4Cidr:props.serviceIpv4Cidr}:void 0,endpointPrivateAccess:this.endpointAccess._config.privateAccess,endpointPublicAccess:this.endpointAccess._config.publicAccess,publicAccessCidrs:this.endpointAccess._config.publicCidrs,secretsEncryptionKey:props.secretsEncryptionKey,vpc:this.vpc,subnets:placeClusterHandlerInVpc?privateSubnets:void 0,clusterHandlerSecurityGroup:this.clusterHandlerSecurityGroup,onEventLayer:this.onEventLayer,tags:props.tags,logging:this.logging});if(this.endpointAccess._config.privateAccess&&privateSubnets.length!==0){if(this.vpc instanceof ec2.Vpc&&!(this.vpc.dnsHostnamesEnabled&&this.vpc.dnsSupportEnabled))throw new Error("Private endpoint access requires the VPC to have DNS support and DNS hostnames enabled. Use `enableDnsHostnames: true` and `enableDnsSupport: true` when creating the VPC.");this.kubectlPrivateSubnets=privateSubnets,this._clusterResource.node.addDependency(this.vpc)}this.adminRole=resource.adminRole,this._kubectlReadyBarrier=new core_1.CfnResource(this,"KubectlReadyBarrier",{type:"AWS::SSM::Parameter",properties:{Type:"String",Value:"aws:cdk:eks:kubectl-ready"}}),this._kubectlReadyBarrier.node.addDependency(this._clusterResource),this.clusterName=this.getResourceNameAttribute(resource.ref),this.clusterArn=this.getResourceArnAttribute(resource.attrArn,cluster_resource_1.clusterArnComponents(this.physicalName)),this.clusterEndpoint=resource.attrEndpoint,this.clusterCertificateAuthorityData=resource.attrCertificateAuthorityData,this.clusterSecurityGroupId=resource.attrClusterSecurityGroupId,this.clusterEncryptionConfigKeyArn=resource.attrEncryptionConfigKeyArn,this.clusterSecurityGroup=ec2.SecurityGroup.fromSecurityGroupId(this,"ClusterSecurityGroup",this.clusterSecurityGroupId),this.connections=new ec2.Connections({securityGroups:[this.clusterSecurityGroup,securityGroup],defaultPort:ec2.Port.tcp(443)}),this.kubectlSecurityGroup=this.clusterSecurityGroup,this.kubectlRole=this.adminRole,this._kubectlResourceProvider=this.defineKubectlProvider();const updateConfigCommandPrefix=`aws eks update-kubeconfig --name ${this.clusterName}`,getTokenCommandPrefix=`aws eks get-token --cluster-name ${this.clusterName}`,commonCommandOptions=[`--region ${stack.region}`];props.outputClusterName&&new core_1.CfnOutput(this,"ClusterName",{value:this.clusterName});const mastersRole=props.mastersRole??new iam.Role(this,"MastersRole",{assumedBy:new iam.AccountRootPrincipal});this.awsAuth.addMastersRole(mastersRole),props.outputMastersRoleArn&&new core_1.CfnOutput(this,"MastersRoleArn",{value:mastersRole.roleArn}),commonCommandOptions.push(`--role-arn ${mastersRole.roleArn}`),props.albController&&(this.albController=alb_controller_1.AlbController.create(this,{...props.albController,cluster:this}));const minCapacity=props.defaultCapacity??DEFAULT_CAPACITY_COUNT;if(minCapacity>0){const instanceType=props.defaultCapacityInstance||DEFAULT_CAPACITY_TYPE;this.defaultCapacity=props.defaultCapacityType===DefaultCapacityType.EC2?this.addAutoScalingGroupCapacity("DefaultCapacity",{instanceType,minCapacity}):void 0,this.defaultNodegroup=props.defaultCapacityType!==DefaultCapacityType.EC2?this.addNodegroupCapacity("DefaultCapacity",{instanceTypes:[instanceType],minSize:minCapacity}):void 0}if(props.outputConfigCommand??!0){const postfix=commonCommandOptions.join(" ");new core_1.CfnOutput(this,"ConfigCommand",{value:`${updateConfigCommandPrefix} ${postfix}`}),new core_1.CfnOutput(this,"GetTokenCommand",{value:`${getTokenCommandPrefix} ${postfix}`})}this.defineCoreDnsComputeType(props.coreDnsComputeType??CoreDnsComputeType.EC2)}static fromClusterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_ClusterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromClusterAttributes),error}return new ImportedCluster(scope,id,attrs)}getServiceLoadBalancerAddress(serviceName,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_ServiceLoadBalancerAddressOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getServiceLoadBalancerAddress),error}return new k8s_object_value_1.KubernetesObjectValue(this,`${serviceName}LoadBalancerAddress`,{cluster:this,objectType:"service",objectName:serviceName,objectNamespace:options.namespace,jsonPath:".status.loadBalancer.ingress[0].hostname",timeout:options.timeout}).value}getIngressLoadBalancerAddress(ingressName,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_IngressLoadBalancerAddressOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getIngressLoadBalancerAddress),error}return new k8s_object_value_1.KubernetesObjectValue(this,`${ingressName}LoadBalancerAddress`,{cluster:this,objectType:"ingress",objectName:ingressName,objectNamespace:options.namespace,jsonPath:".status.loadBalancer.ingress[0].hostname",timeout:options.timeout}).value}addAutoScalingGroupCapacity(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_AutoScalingGroupCapacityOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addAutoScalingGroupCapacity),error}if(options.machineImageType===MachineImageType.BOTTLEROCKET&&options.bootstrapOptions!==void 0)throw new Error("bootstrapOptions is not supported for Bottlerocket");const asg=new autoscaling.AutoScalingGroup(this,id,{...options,vpc:this.vpc,machineImage:options.machineImageType===MachineImageType.BOTTLEROCKET?new bottlerocket_1.BottleRocketImage({kubernetesVersion:this.version.version}):new EksOptimizedImage({nodeType:nodeTypeForInstanceType(options.instanceType),cpuArch:cpuArchForInstanceType(options.instanceType),kubernetesVersion:this.version.version})});return this.connectAutoScalingGroupCapacity(asg,{mapRole:options.mapRole,bootstrapOptions:options.bootstrapOptions,bootstrapEnabled:options.bootstrapEnabled,machineImageType:options.machineImageType,spotInterruptHandler:options.spotInterruptHandler}),nodeTypeForInstanceType(options.instanceType)===NodeType.INFERENTIA&&this.addNeuronDevicePlugin(),asg}addNodegroupCapacity(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_NodegroupOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addNodegroupCapacity),error}return new managed_nodegroup_1.Nodegroup(this,`Nodegroup${id}`,{cluster:this,...options})}get awsAuth(){return this._awsAuth||(this._awsAuth=new aws_auth_1.AwsAuth(this,"AwsAuth",{cluster:this})),this._awsAuth}get clusterOpenIdConnectIssuerUrl(){return this._clusterResource.attrOpenIdConnectIssuerUrl}get clusterOpenIdConnectIssuer(){return this._clusterResource.attrOpenIdConnectIssuer}get openIdConnectProvider(){return this._openIdConnectProvider||(this._openIdConnectProvider=new oidc_provider_1.OpenIdConnectProvider(this,"OpenIdConnectProvider",{url:this.clusterOpenIdConnectIssuerUrl})),this._openIdConnectProvider}addFargateProfile(id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_FargateProfileOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFargateProfile),error}return new fargate_profile_1.FargateProfile(this,`fargate-profile-${id}`,{...options,cluster:this})}_attachFargateProfile(fargateProfile){return this._fargateProfiles.push(fargateProfile),this._kubectlReadyBarrier.node.addDependency(fargateProfile),this._fargateProfiles}_attachKubectlResourceScope(resourceScope){return constructs_1.Node.of(resourceScope).addDependency(this._kubectlReadyBarrier),this._kubectlResourceProvider}defineKubectlProvider(){const uid="@aws-cdk/aws-eks.KubectlProvider";if(this.stack.node.tryFindChild(uid))throw new Error("Only a single EKS cluster can be defined within a CloudFormation stack");return new kubectl_provider_1.KubectlProvider(this.stack,uid,{cluster:this})}selectPrivateSubnets(){const privateSubnets=[],vpcPrivateSubnetIds=this.vpc.privateSubnets.map(s=>s.subnetId),vpcPublicSubnetIds=this.vpc.publicSubnets.map(s=>s.subnetId);for(const placement of this.vpcSubnets)for(const subnet of this.vpc.selectSubnets(placement).subnets){if(vpcPrivateSubnetIds.includes(subnet.subnetId)){privateSubnets.push(subnet);continue}vpcPublicSubnetIds.includes(subnet.subnetId)||privateSubnets.push(subnet)}return privateSubnets}addNeuronDevicePlugin(){if(!this._neuronDevicePlugin){const fileContents=fs.readFileSync(path.join(__dirname,"addons/neuron-device-plugin.yaml"),"utf8"),sanitized=YAML.parse(fileContents);this._neuronDevicePlugin=this.addManifest("NeuronDevicePlugin",sanitized)}return this._neuronDevicePlugin}tagSubnets(){const tagAllSubnets=(type,subnets,tag)=>{for(const subnet of subnets){if(!ec2.Subnet.isVpcSubnet(subnet)){const subnetID=core_1.Token.isUnresolved(subnet.subnetId)||core_1.Token.isUnresolved([subnet.subnetId])?"":` ${subnet.subnetId}`;core_1.Annotations.of(this).addWarning(`Could not auto-tag ${type} subnet${subnetID} with "${tag}=1", please remember to do this manually`);continue}core_1.Tags.of(subnet).add(tag,"1")}};tagAllSubnets("private",this.vpc.privateSubnets,"kubernetes.io/role/internal-elb"),tagAllSubnets("public",this.vpc.publicSubnets,"kubernetes.io/role/elb")}defineCoreDnsComputeType(type){if(type===CoreDnsComputeType.EC2)return;const renderPatch=computeType=>({spec:{template:{metadata:{annotations:{"eks.amazonaws.com/compute-type":computeType}}}}});new k8s_patch_1.KubernetesPatch(this,"CoreDnsComputeTypePatch",{cluster:this,resourceName:"deployment/coredns",resourceNamespace:"kube-system",applyPatch:renderPatch(CoreDnsComputeType.FARGATE),restorePatch:renderPatch(CoreDnsComputeType.EC2)})}}exports.Cluster=Cluster,_c=JSII_RTTI_SYMBOL_1,Cluster[_c]={fqn:"aws-cdk-lib.aws_eks.Cluster",version:"2.69.0"};class ImportedCluster extends ClusterBase{constructor(scope,id,props){super(scope,id),this.props=props,this.connections=new ec2.Connections,this.clusterName=props.clusterName,this.clusterArn=this.stack.formatArn(cluster_resource_1.clusterArnComponents(props.clusterName)),this.kubectlRole=props.kubectlRoleArn?iam.Role.fromRoleArn(this,"KubectlRole",props.kubectlRoleArn):void 0,this.kubectlLambdaRole=props.kubectlLambdaRole,this.kubectlSecurityGroup=props.kubectlSecurityGroupId?ec2.SecurityGroup.fromSecurityGroupId(this,"KubectlSecurityGroup",props.kubectlSecurityGroupId):void 0,this.kubectlEnvironment=props.kubectlEnvironment,this.kubectlPrivateSubnets=props.kubectlPrivateSubnetIds?props.kubectlPrivateSubnetIds.map((subnetid,index)=>ec2.Subnet.fromSubnetId(this,`KubectlSubnet${index}`,subnetid)):void 0,this.kubectlLayer=props.kubectlLayer,this.awscliLayer=props.awscliLayer,this.kubectlMemory=props.kubectlMemory,this.clusterHandlerSecurityGroup=props.clusterHandlerSecurityGroupId?ec2.SecurityGroup.fromSecurityGroupId(this,"ClusterHandlerSecurityGroup",props.clusterHandlerSecurityGroupId):void 0,this.kubectlProvider=props.kubectlProvider,this.onEventLayer=props.onEventLayer,this.prune=props.prune??!0;let i=1;for(const sgid of props.securityGroupIds??[])this.connections.addSecurityGroup(ec2.SecurityGroup.fromSecurityGroupId(this,`SecurityGroup${i}`,sgid)),i++;props.clusterSecurityGroupId&&(this._clusterSecurityGroup=ec2.SecurityGroup.fromSecurityGroupId(this,"ClusterSecurityGroup",this.clusterSecurityGroupId),this.connections.addSecurityGroup(this._clusterSecurityGroup))}get vpc(){if(!this.props.vpc)throw new Error('"vpc" is not defined for this imported cluster');return this.props.vpc}get clusterSecurityGroup(){if(!this._clusterSecurityGroup)throw new Error('"clusterSecurityGroup" is not defined for this imported cluster');return this._clusterSecurityGroup}get clusterSecurityGroupId(){if(!this.props.clusterSecurityGroupId)throw new Error('"clusterSecurityGroupId" is not defined for this imported cluster');return this.props.clusterSecurityGroupId}get clusterEndpoint(){if(!this.props.clusterEndpoint)throw new Error('"clusterEndpoint" is not defined for this imported cluster');return this.props.clusterEndpoint}get clusterCertificateAuthorityData(){if(!this.props.clusterCertificateAuthorityData)throw new Error('"clusterCertificateAuthorityData" is not defined for this imported cluster');return this.props.clusterCertificateAuthorityData}get clusterEncryptionConfigKeyArn(){if(!this.props.clusterEncryptionConfigKeyArn)throw new Error('"clusterEncryptionConfigKeyArn" is not defined for this imported cluster');return this.props.clusterEncryptionConfigKeyArn}get openIdConnectProvider(){if(!this.props.openIdConnectProvider)throw new Error('"openIdConnectProvider" is not defined for this imported cluster');return this.props.openIdConnectProvider}get awsAuth(){throw new Error('"awsAuth" is not supported on imported clusters')}}class EksOptimizedImage{constructor(props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_eks_EksOptimizedImageProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EksOptimizedImage),error}this.nodeType=props.nodeType??NodeType.STANDARD,this.cpuArch=props.cpuArch??CpuArch.X86_64,this.kubernetesVersion=props.kubernetesVersion??LATEST_KUBERNETES_VERSION,this.amiParameterName=`/aws/service/eks/optimized-ami/${this.kubernetesVersion}/`+(this.nodeType===NodeType.STANDARD?this.cpuArch===CpuArch.X86_64?"amazon-linux-2/":"amazon-linux-2-arm64/":"")+(this.nodeType===NodeType.GPU?"amazon-linux-2-gpu/":"")+(this.nodeType===NodeType.INFERENTIA?"amazon-linux-2-gpu/":"")+"recommended/image_id"}getImage(scope){return{imageId:ssm.StringParameter.valueForStringParameter(scope,this.amiParameterName),osType:ec2.OperatingSystemType.LINUX,userData:ec2.UserData.forLinux()}}}exports.EksOptimizedImage=EksOptimizedImage,_d=JSII_RTTI_SYMBOL_1,EksOptimizedImage[_d]={fqn:"aws-cdk-lib.aws_eks.EksOptimizedImage",version:"2.69.0"};const LATEST_KUBERNETES_VERSION="1.24";var NodeType;(function(NodeType2){NodeType2.STANDARD="Standard",NodeType2.GPU="GPU",NodeType2.INFERENTIA="INFERENTIA"})(NodeType=exports.NodeType||(exports.NodeType={}));var CpuArch;(function(CpuArch2){CpuArch2.ARM_64="arm64",CpuArch2.X86_64="x86_64"})(CpuArch=exports.CpuArch||(exports.CpuArch={}));var CoreDnsComputeType;(function(CoreDnsComputeType2){CoreDnsComputeType2.EC2="ec2",CoreDnsComputeType2.FARGATE="fargate"})(CoreDnsComputeType=exports.CoreDnsComputeType||(exports.CoreDnsComputeType={}));var DefaultCapacityType;(function(DefaultCapacityType2){DefaultCapacityType2[DefaultCapacityType2.NODEGROUP=0]="NODEGROUP",DefaultCapacityType2[DefaultCapacityType2.EC2=1]="EC2"})(DefaultCapacityType=exports.DefaultCapacityType||(exports.DefaultCapacityType={}));var MachineImageType;(function(MachineImageType2){MachineImageType2[MachineImageType2.AMAZON_LINUX_2=0]="AMAZON_LINUX_2",MachineImageType2[MachineImageType2.BOTTLEROCKET=1]="BOTTLEROCKET"})(MachineImageType=exports.MachineImageType||(exports.MachineImageType={}));function nodeTypeForInstanceType(instanceType){return instance_types_1.INSTANCE_TYPES.gpu.includes(instanceType.toString().substring(0,2))?NodeType.GPU:instance_types_1.INSTANCE_TYPES.inferentia.includes(instanceType.toString().substring(0,4))?NodeType.INFERENTIA:NodeType.STANDARD}function cpuArchForInstanceType(instanceType){return instance_types_1.INSTANCE_TYPES.graviton2.includes(instanceType.toString().substring(0,3))||instance_types_1.INSTANCE_TYPES.graviton3.includes(instanceType.toString().substring(0,3))||instance_types_1.INSTANCE_TYPES.graviton.includes(instanceType.toString().substring(0,2))?CpuArch.ARM_64:CpuArch.X86_64}function flatten(xss){return Array.prototype.concat.call([],...xss)}
