"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.IpAddresses=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),core_1=require("../../core"),cidr_splits_1=require("./cidr-splits"),network_util_1=require("./network-util");class IpAddresses{constructor(){}static cidr(cidrBlock){return new Cidr(cidrBlock)}static awsIpamAllocation(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_AwsIpamProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.awsIpamAllocation),error}return new AwsIpam(props)}}exports.IpAddresses=IpAddresses,_a=JSII_RTTI_SYMBOL_1,IpAddresses[_a]={fqn:"aws-cdk-lib.aws_ec2.IpAddresses",version:"2.69.0"};class AwsIpam{constructor(props){this.props=props}allocateVpcCidr(){return{ipv4NetmaskLength:this.props.ipv4NetmaskLength,ipv4IpamPoolId:this.props.ipv4IpamPoolId}}allocateSubnetsCidr(input){return{allocatedSubnets:cidr_splits_1.calculateCidrSplits(this.props.ipv4NetmaskLength,input.requestedSubnets.map(mask=>{if(mask.configuration.cidrMask===void 0&&this.props.defaultSubnetIpv4NetmaskLength===void 0)throw new Error("If you have not set a cidr for all subnets in this case you must set a defaultCidrMask in AwsIpam Options");const cidrMask=mask.configuration.cidrMask??this.props.defaultSubnetIpv4NetmaskLength;if(cidrMask===void 0)throw new Error("Should not have happened, but satisfies the type checker");return cidrMask})).map(subnet=>({cidr:core_1.Fn.select(subnet.index,core_1.Fn.cidr(input.vpcCidr,subnet.count,`${32-subnet.netmask}`))}))}}}class Cidr{constructor(cidrBlock){if(this.cidrBlock=cidrBlock,core_1.Token.isUnresolved(cidrBlock))throw new Error("'cidr' property must be a concrete CIDR string, got a Token (we need to parse it for automatic subdivision)");this.networkBuilder=new network_util_1.NetworkBuilder(this.cidrBlock)}allocateVpcCidr(){return{cidrBlock:this.networkBuilder.networkCidr.cidr}}allocateSubnetsCidr(input){const allocatedSubnets=[],subnetsWithoutDefinedCidr=[];input.requestedSubnets.forEach((requestedSubnet,index)=>{requestedSubnet.configuration.cidrMask===void 0?subnetsWithoutDefinedCidr.push({index,requestedSubnet}):allocatedSubnets.push({cidr:this.networkBuilder.addSubnet(requestedSubnet.configuration.cidrMask)})});const cidrMaskForRemaining=this.networkBuilder.maskForRemainingSubnets(subnetsWithoutDefinedCidr.length);return subnetsWithoutDefinedCidr.forEach(subnet=>{allocatedSubnets.splice(subnet.index,0,{cidr:this.networkBuilder.addSubnet(cidrMaskForRemaining)})}),{allocatedSubnets}}}
