"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CodeCommitSourceAction=exports.CodeCommitTrigger=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),codepipeline=require("../../../aws-codepipeline"),targets=require("../../../aws-events-targets"),iam=require("../../../aws-iam"),core_1=require("../../../core"),action_1=require("../action"),common_1=require("../common");var CodeCommitTrigger;(function(CodeCommitTrigger2){CodeCommitTrigger2.NONE="None",CodeCommitTrigger2.POLL="Poll",CodeCommitTrigger2.EVENTS="Events"})(CodeCommitTrigger=exports.CodeCommitTrigger||(exports.CodeCommitTrigger={}));class CodeCommitSourceAction extends action_1.Action{constructor(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_actions_CodeCommitSourceActionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CodeCommitSourceAction),error}const branch=props.branch??"master";if(!branch)throw new Error("'branch' parameter cannot be an empty string");props.codeBuildCloneOutput===!0&&props.output.setMetadata(CodeCommitSourceAction._FULL_CLONE_ARN_PROPERTY,props.repository.repositoryArn),super({...props,resource:props.repository,category:codepipeline.ActionCategory.SOURCE,provider:"CodeCommit",artifactBounds:common_1.sourceArtifactBounds(),outputs:[props.output]}),this.branch=branch,this.props=props}get variables(){return{repositoryName:this.variableExpression("RepositoryName"),branchName:this.variableExpression("BranchName"),authorDate:this.variableExpression("AuthorDate"),committerDate:this.variableExpression("CommitterDate"),commitId:this.variableExpression("CommitId"),commitMessage:this.variableExpression("CommitMessage")}}bound(_scope,stage,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_IStage(stage),jsiiDeprecationWarnings.aws_cdk_lib_aws_codepipeline_ActionBindOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bound),error}if(this.props.trigger===void 0||this.props.trigger===CodeCommitTrigger.EVENTS){const eventId=this.generateEventId(stage);this.props.repository.onCommit(eventId,{target:new targets.CodePipeline(stage.pipeline,{eventRole:this.props.eventRole}),branches:[this.branch],crossStackScope:stage.pipeline})}return options.bucket.grantReadWrite(options.role),core_1.Token.compareStrings(this.props.repository.env.account,core_1.Stack.of(stage.pipeline).account)===core_1.TokenComparison.DIFFERENT&&options.bucket.grantPutAcl(options.role),options.role.addToPrincipalPolicy(new iam.PolicyStatement({resources:[this.props.repository.repositoryArn],actions:["codecommit:GetBranch","codecommit:GetCommit","codecommit:UploadArchive","codecommit:GetUploadArchiveStatus","codecommit:CancelUploadArchive",...this.props.codeBuildCloneOutput===!0?["codecommit:GetRepository"]:[]]})),{configuration:{RepositoryName:this.props.repository.repositoryName,BranchName:this.branch,PollForSourceChanges:this.props.trigger===CodeCommitTrigger.POLL,OutputArtifactFormat:this.props.codeBuildCloneOutput===!0?"CODEBUILD_CLONE_REF":void 0}}}generateEventId(stage){const baseId=core_1.Names.nodeUniqueId(stage.pipeline.node);if(core_1.Token.isUnresolved(this.branch)){let candidate="",counter=0;do candidate=this.eventIdFromPrefix(`${baseId}${counter}`),counter+=1;while(this.props.repository.node.tryFindChild(candidate)!==void 0);return candidate}else{const branchIdDisambiguator=this.branch==="master"?"":`-${this.branch}-`;return this.eventIdFromPrefix(`${baseId}${branchIdDisambiguator}`)}}eventIdFromPrefix(eventIdPrefix){return`${eventIdPrefix}EventRule`}}exports.CodeCommitSourceAction=CodeCommitSourceAction,_a=JSII_RTTI_SYMBOL_1,CodeCommitSourceAction[_a]={fqn:"aws-cdk-lib.aws_codepipeline_actions.CodeCommitSourceAction",version:"2.69.0"},CodeCommitSourceAction._FULL_CLONE_ARN_PROPERTY="CodeCommitCloneRepositoryArn";
