"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.BackupPlanRule=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),events=require("../../aws-events"),core_1=require("../../core");class BackupPlanRule{constructor(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_BackupPlanRuleProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,BackupPlanRule),error}if(props.deleteAfter&&props.moveToColdStorageAfter&&props.deleteAfter.toDays()<props.moveToColdStorageAfter.toDays())throw new Error("`deleteAfter` must be greater than `moveToColdStorageAfter`");if(props.scheduleExpression&&!/^cron/.test(props.scheduleExpression.expressionString))throw new Error("`scheduleExpression` must be of type `cron`");const deleteAfter=props.enableContinuousBackup&&!props.deleteAfter?core_1.Duration.days(35):props.deleteAfter;if(props.enableContinuousBackup&&props.moveToColdStorageAfter)throw new Error("`moveToColdStorageAfter` must not be specified if `enableContinuousBackup` is enabled");if(props.enableContinuousBackup&&props.deleteAfter&&(props.deleteAfter?.toDays()<1||props.deleteAfter?.toDays()>35))throw new Error(`'deleteAfter' must be between 1 and 35 days if 'enableContinuousBackup' is enabled, but got ${props.deleteAfter.toHumanString()}`);props.copyActions&&props.copyActions.length>0&&props.copyActions.forEach(copyAction=>{if(copyAction.deleteAfter&&!core_1.Token.isUnresolved(copyAction.deleteAfter)&&copyAction.moveToColdStorageAfter&&!core_1.Token.isUnresolved(copyAction.moveToColdStorageAfter)&&copyAction.deleteAfter.toDays()<copyAction.moveToColdStorageAfter.toDays()+90)throw new Error(["'deleteAfter' must at least 90 days later than corresponding 'moveToColdStorageAfter'",`received 'deleteAfter: ${copyAction.deleteAfter.toDays()}' and 'moveToColdStorageAfter: ${copyAction.moveToColdStorageAfter.toDays()}'`].join(`
`))}),this.props={...props,deleteAfter}}static daily(backupVault){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_IBackupVault(backupVault)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.daily),error}return new BackupPlanRule({backupVault,ruleName:"Daily",scheduleExpression:events.Schedule.cron({hour:"5",minute:"0"}),deleteAfter:core_1.Duration.days(35)})}static weekly(backupVault){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_IBackupVault(backupVault)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.weekly),error}return new BackupPlanRule({backupVault,ruleName:"Weekly",scheduleExpression:events.Schedule.cron({hour:"5",minute:"0",weekDay:"SAT"}),deleteAfter:core_1.Duration.days(30*3)})}static monthly1Year(backupVault){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_IBackupVault(backupVault)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.monthly1Year),error}return new BackupPlanRule({backupVault,ruleName:"Monthly1Year",scheduleExpression:events.Schedule.cron({day:"1",hour:"5",minute:"0"}),moveToColdStorageAfter:core_1.Duration.days(30),deleteAfter:core_1.Duration.days(365)})}static monthly5Year(backupVault){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_IBackupVault(backupVault)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.monthly5Year),error}return new BackupPlanRule({backupVault,ruleName:"Monthly5Year",scheduleExpression:events.Schedule.cron({day:"1",hour:"5",minute:"0"}),moveToColdStorageAfter:core_1.Duration.days(30*3),deleteAfter:core_1.Duration.days(365*5)})}static monthly7Year(backupVault){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_backup_IBackupVault(backupVault)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.monthly7Year),error}return new BackupPlanRule({backupVault,ruleName:"Monthly7Year",scheduleExpression:events.Schedule.cron({day:"1",hour:"5",minute:"0"}),moveToColdStorageAfter:core_1.Duration.days(30*3),deleteAfter:core_1.Duration.days(365*7)})}}exports.BackupPlanRule=BackupPlanRule,_a=JSII_RTTI_SYMBOL_1,BackupPlanRule[_a]={fqn:"aws-cdk-lib.aws_backup.BackupPlanRule",version:"2.69.0"};
