"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.GraphqlApi=exports.IamResource=exports.FieldLogLevel=exports.UserPoolDefaultAction=exports.AuthorizationType=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),aws_iam_1=require("../../aws-iam"),aws_logs_1=require("../../aws-logs"),core_1=require("../../core"),appsync_generated_1=require("./appsync.generated"),graphqlapi_base_1=require("./graphqlapi-base");var AuthorizationType;(function(AuthorizationType2){AuthorizationType2.API_KEY="API_KEY",AuthorizationType2.IAM="AWS_IAM",AuthorizationType2.USER_POOL="AMAZON_COGNITO_USER_POOLS",AuthorizationType2.OIDC="OPENID_CONNECT",AuthorizationType2.LAMBDA="AWS_LAMBDA"})(AuthorizationType=exports.AuthorizationType||(exports.AuthorizationType={}));var UserPoolDefaultAction;(function(UserPoolDefaultAction2){UserPoolDefaultAction2.ALLOW="ALLOW",UserPoolDefaultAction2.DENY="DENY"})(UserPoolDefaultAction=exports.UserPoolDefaultAction||(exports.UserPoolDefaultAction={}));var FieldLogLevel;(function(FieldLogLevel2){FieldLogLevel2.NONE="NONE",FieldLogLevel2.ERROR="ERROR",FieldLogLevel2.ALL="ALL"})(FieldLogLevel=exports.FieldLogLevel||(exports.FieldLogLevel={}));class IamResource{constructor(arns){this.arns=arns}static custom(...arns){if(arns.length===0)throw new Error("At least 1 custom ARN must be provided.");return new IamResource(arns)}static ofType(type,...fields){const arns=fields.length?fields.map(field=>`types/${type}/fields/${field}`):[`types/${type}/*`];return new IamResource(arns)}static all(){return new IamResource(["*"])}resourceArns(api){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_GraphqlApi(api)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.resourceArns),error}return this.arns.map(arn=>core_1.Stack.of(api).formatArn({service:"appsync",resource:`apis/${api.apiId}`,arnFormat:core_1.ArnFormat.SLASH_RESOURCE_NAME,resourceName:`${arn}`}))}}exports.IamResource=IamResource,_a=JSII_RTTI_SYMBOL_1,IamResource[_a]={fqn:"aws-cdk-lib.aws_appsync.IamResource",version:"2.69.0"};class GraphqlApi extends graphqlapi_base_1.GraphqlApiBase{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_GraphqlApiProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,GraphqlApi),error}const defaultMode=props.authorizationConfig?.defaultAuthorization??{authorizationType:AuthorizationType.API_KEY},additionalModes=props.authorizationConfig?.additionalAuthorizationModes??[],modes=[defaultMode,...additionalModes];if(this.modes=modes.map(mode=>mode.authorizationType),this.validateAuthorizationProps(modes),this.api=new appsync_generated_1.CfnGraphQLApi(this,"Resource",{name:props.name,authenticationType:defaultMode.authorizationType,logConfig:this.setupLogConfig(props.logConfig),openIdConnectConfig:this.setupOpenIdConnectConfig(defaultMode.openIdConnectConfig),userPoolConfig:this.setupUserPoolConfig(defaultMode.userPoolConfig),lambdaAuthorizerConfig:this.setupLambdaAuthorizerConfig(defaultMode.lambdaAuthorizerConfig),additionalAuthenticationProviders:this.setupAdditionalAuthorizationModes(additionalModes),xrayEnabled:props.xrayEnabled}),this.apiId=this.api.attrApiId,this.arn=this.api.attrArn,this.graphqlUrl=this.api.attrGraphQlUrl,this.name=this.api.name,this.schema=props.schema,this.schemaResource=new appsync_generated_1.CfnGraphQLSchema(this,"Schema",this.schema.bind(this)),props.domainName&&(this.domainNameResource=new appsync_generated_1.CfnDomainName(this,"DomainName",{domainName:props.domainName.domainName,certificateArn:props.domainName.certificate.certificateArn,description:`domain for ${this.name} at ${this.graphqlUrl}`}),new appsync_generated_1.CfnDomainNameApiAssociation(this,"DomainAssociation",{domainName:props.domainName.domainName,apiId:this.apiId}).addDependency(this.domainNameResource)),modes.some(mode=>mode.authorizationType===AuthorizationType.API_KEY)){const config=modes.find(mode=>mode.authorizationType===AuthorizationType.API_KEY&&mode.apiKeyConfig)?.apiKeyConfig;this.apiKeyResource=this.createAPIKey(config),this.apiKeyResource.addDependency(this.schemaResource),this.apiKey=this.apiKeyResource.attrApiKey}modes.some(mode=>mode.authorizationType===AuthorizationType.LAMBDA)&&modes.find(mode=>mode.authorizationType===AuthorizationType.LAMBDA&&mode.lambdaAuthorizerConfig)?.lambdaAuthorizerConfig?.handler.addPermission(`${id}-appsync`,{principal:new aws_iam_1.ServicePrincipal("appsync.amazonaws.com"),action:"lambda:InvokeFunction"});const logGroupName=`/aws/appsync/apis/${this.apiId}`;this.logGroup=aws_logs_1.LogGroup.fromLogGroupName(this,"LogGroup",logGroupName),props.logConfig?.retention&&new aws_logs_1.LogRetention(this,"LogRetention",{logGroupName:this.logGroup.logGroupName,retention:props.logConfig.retention})}static fromGraphqlApiAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_GraphqlApiAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromGraphqlApiAttributes),error}const arn=attrs.graphqlApiArn??core_1.Stack.of(scope).formatArn({service:"appsync",resource:`apis/${attrs.graphqlApiId}`});class Import extends graphqlapi_base_1.GraphqlApiBase{constructor(s,i){super(s,i),this.apiId=attrs.graphqlApiId,this.arn=arn}}return new Import(scope,id)}grant(grantee,resources,...actions){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee),jsiiDeprecationWarnings.aws_cdk_lib_aws_appsync_IamResource(resources)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grant),error}return aws_iam_1.Grant.addToPrincipal({grantee,actions,resourceArns:resources.resourceArns(this),scope:this})}grantMutation(grantee,...fields){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantMutation),error}return this.grant(grantee,IamResource.ofType("Mutation",...fields),"appsync:GraphQL")}grantQuery(grantee,...fields){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantQuery),error}return this.grant(grantee,IamResource.ofType("Query",...fields),"appsync:GraphQL")}grantSubscription(grantee,...fields){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantSubscription),error}return this.grant(grantee,IamResource.ofType("Subscription",...fields),"appsync:GraphQL")}validateAuthorizationProps(modes){if(modes.filter(mode=>mode.authorizationType===AuthorizationType.LAMBDA).length>1)throw new Error("You can only have a single AWS Lambda function configured to authorize your API.");if(modes.map(mode=>{if(mode.authorizationType===AuthorizationType.OIDC&&!mode.openIdConnectConfig)throw new Error("Missing OIDC Configuration");if(mode.authorizationType===AuthorizationType.USER_POOL&&!mode.userPoolConfig)throw new Error("Missing User Pool Configuration");if(mode.authorizationType===AuthorizationType.LAMBDA&&!mode.lambdaAuthorizerConfig)throw new Error("Missing Lambda Configuration")}),modes.filter(mode=>mode.authorizationType===AuthorizationType.API_KEY).length>1)throw new Error("You can't duplicate API_KEY configuration. See https://docs.aws.amazon.com/appsync/latest/devguide/security.html");if(modes.filter(mode=>mode.authorizationType===AuthorizationType.IAM).length>1)throw new Error("You can't duplicate IAM configuration. See https://docs.aws.amazon.com/appsync/latest/devguide/security.html")}addSchemaDependency(construct){try{jsiiDeprecationWarnings.aws_cdk_lib_CfnResource(construct)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSchemaDependency),error}return construct.addDependency(this.schemaResource),!0}setupLogConfig(config){if(!config)return;const logsRoleArn=config.role?.roleArn??new aws_iam_1.Role(this,"ApiLogsRole",{assumedBy:new aws_iam_1.ServicePrincipal("appsync.amazonaws.com"),managedPolicies:[aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSAppSyncPushToCloudWatchLogs")]}).roleArn,fieldLogLevel=config.fieldLogLevel??FieldLogLevel.NONE;return{cloudWatchLogsRoleArn:logsRoleArn,excludeVerboseContent:config.excludeVerboseContent,fieldLogLevel}}setupOpenIdConnectConfig(config){if(config)return{authTtl:config.tokenExpiryFromAuth,clientId:config.clientId,iatTtl:config.tokenExpiryFromIssue,issuer:config.oidcProvider}}setupUserPoolConfig(config){if(config)return{userPoolId:config.userPool.userPoolId,awsRegion:config.userPool.env.region,appIdClientRegex:config.appIdClientRegex,defaultAction:config.defaultAction||UserPoolDefaultAction.ALLOW}}setupLambdaAuthorizerConfig(config){if(config)return{authorizerResultTtlInSeconds:config.resultsCacheTtl?.toSeconds(),authorizerUri:config.handler.functionArn,identityValidationExpression:config.validationRegex}}setupAdditionalAuthorizationModes(modes){if(!(!modes||modes.length===0))return modes.reduce((acc,mode)=>[...acc,{authenticationType:mode.authorizationType,userPoolConfig:this.setupUserPoolConfig(mode.userPoolConfig),openIdConnectConfig:this.setupOpenIdConnectConfig(mode.openIdConnectConfig),lambdaAuthorizerConfig:this.setupLambdaAuthorizerConfig(mode.lambdaAuthorizerConfig)}],[])}createAPIKey(config){if(config?.expires?.isBefore(core_1.Duration.days(1))||config?.expires?.isAfter(core_1.Duration.days(365)))throw Error("API key expiration must be between 1 and 365 days.");const expires=config?.expires?config?.expires.toEpoch():void 0;return new appsync_generated_1.CfnApiKey(this,`${config?.name||"Default"}ApiKey`,{expires,description:config?.description,apiId:this.apiId})}get appSyncDomainName(){if(!this.domainNameResource)throw new Error("Cannot retrieve the appSyncDomainName without a domainName configuration");return this.domainNameResource.attrAppSyncDomainName}}exports.GraphqlApi=GraphqlApi,_b=JSII_RTTI_SYMBOL_1,GraphqlApi[_b]={fqn:"aws-cdk-lib.aws_appsync.GraphqlApi",version:"2.69.0"};
