"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Template=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),core_1=require("../../core"),fs=require("fs-extra"),match_1=require("./match"),matcher_1=require("./matcher"),conditions_1=require("./private/conditions"),cyclic_1=require("./private/cyclic"),mappings_1=require("./private/mappings"),outputs_1=require("./private/outputs"),parameters_1=require("./private/parameters"),resources_1=require("./private/resources");class Template{constructor(template,templateParsingOptions={}){this.template=template,templateParsingOptions?.skipCyclicalDependenciesCheck||cyclic_1.checkTemplateForCyclicDependencies(this.template)}static fromStack(stack,templateParsingOptions){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack),jsiiDeprecationWarnings.aws_cdk_lib_assertions_TemplateParsingOptions(templateParsingOptions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromStack),error}return new Template(toTemplate(stack),templateParsingOptions)}static fromJSON(template,templateParsingOptions){try{jsiiDeprecationWarnings.aws_cdk_lib_assertions_TemplateParsingOptions(templateParsingOptions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromJSON),error}return new Template(template,templateParsingOptions)}static fromString(template,templateParsingOptions){try{jsiiDeprecationWarnings.aws_cdk_lib_assertions_TemplateParsingOptions(templateParsingOptions)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromString),error}return new Template(JSON.parse(template),templateParsingOptions)}toJSON(){return this.template}resourceCountIs(type,count){const counted=resources_1.countResources(this.template,type);if(counted!==count)throw new Error(`Expected ${count} resources of type ${type} but found ${counted}`)}resourcePropertiesCountIs(type,props,count){const counted=resources_1.countResourcesProperties(this.template,type,props);if(counted!==count)throw new Error(`Expected ${count} resources of type ${type} but found ${counted}`)}hasResourceProperties(type,props){const matchError=resources_1.hasResourceProperties(this.template,type,props);if(matchError)throw new Error(matchError)}hasResource(type,props){const matchError=resources_1.hasResource(this.template,type,props);if(matchError)throw new Error(matchError)}findResources(type,props={}){return resources_1.findResources(this.template,type,props)}allResources(type,props){const matchError=resources_1.allResources(this.template,type,props);if(matchError)throw new Error(matchError)}allResourcesProperties(type,props){const matchError=resources_1.allResourcesProperties(this.template,type,props);if(matchError)throw new Error(matchError)}hasParameter(logicalId,props){const matchError=parameters_1.hasParameter(this.template,logicalId,props);if(matchError)throw new Error(matchError)}findParameters(logicalId,props={}){return parameters_1.findParameters(this.template,logicalId,props)}hasOutput(logicalId,props){const matchError=outputs_1.hasOutput(this.template,logicalId,props);if(matchError)throw new Error(matchError)}findOutputs(logicalId,props={}){return outputs_1.findOutputs(this.template,logicalId,props)}hasMapping(logicalId,props){const matchError=mappings_1.hasMapping(this.template,logicalId,props);if(matchError)throw new Error(matchError)}findMappings(logicalId,props={}){return mappings_1.findMappings(this.template,logicalId,props)}hasCondition(logicalId,props){const matchError=conditions_1.hasCondition(this.template,logicalId,props);if(matchError)throw new Error(matchError)}findConditions(logicalId,props={}){return conditions_1.findConditions(this.template,logicalId,props)}templateMatches(expected){const result=(matcher_1.Matcher.isMatcher(expected)?expected:match_1.Match.objectLike(expected)).test(this.template);if(result.hasFailed())throw new Error(["Template did not match as expected. The following mismatches were found:",...result.toHumanStrings().map(s=>`	${s}`)].join(`
`))}}exports.Template=Template,_a=JSII_RTTI_SYMBOL_1,Template[_a]={fqn:"aws-cdk-lib.assertions.Template",version:"2.69.0"};function toTemplate(stack){const root=stack.node.root;if(!core_1.Stage.isStage(root))throw new Error("unexpected: all stacks must be part of a Stage or an App");const assembly=root.synth();return stack.nestedStackParent?JSON.parse(fs.readFileSync(path.join(assembly.directory,stack.templateFile)).toString("utf-8")):assembly.getStackArtifact(stack.artifactId).template}
