# Generated by Django 3.2.8 on 2021-11-22 14:11

import django.db.models.deletion
import multiselectfield.db.fields
from django.conf import settings
from django.db import migrations, models


try:
    if getattr(settings, "ADMIN_CHARTS_USE_JSONFIELD", True):
        from django.db.models import JSONField
    else:
        from jsonfield.fields import JSONField
except ImportError:
    from jsonfield.fields import JSONField


class Migration(migrations.Migration):

    dependencies = [
        ("admin_tools_stats", "0013_auto_20210221_1247"),
    ]

    operations = [
        migrations.AlterField(
            model_name="dashboardstats",
            name="allowed_chart_types",
            field=multiselectfield.db.fields.MultiSelectField(
                blank=True,
                choices=[
                    ("discreteBarChart", "Bar"),
                    ("lineChart", "Line"),
                    ("multiBarChart", "Multi Bar"),
                    ("pieChart", "Pie"),
                    ("stackedAreaChart", "Stacked Area"),
                    ("multiBarHorizontalChart", "Multi Bar Horizontal"),
                    ("linePlusBarChart", "Line Plus Bar"),
                    ("scatterChart", "Scatter"),
                    ("cumulativeLineChart", "Cumulative Line"),
                    ("lineWithFocusChart", "Line With Focus"),
                ],
                default=(
                    "discreteBarChart",
                    "lineChart",
                    "multiBarChart",
                    "pieChart",
                    "stackedAreaChart",
                    "multiBarHorizontalChart",
                    "linePlusBarChart",
                    "scatterChart",
                    "cumulativeLineChart",
                    "lineWithFocusChart",
                ),
                help_text="More than one selected field will display chooser on the chart.",
                max_length=1000,
                null=True,
                verbose_name="Allowed chart types",
            ),
        ),
        migrations.AlterField(
            model_name="dashboardstats",
            name="allowed_time_scales",
            field=multiselectfield.db.fields.MultiSelectField(
                choices=[
                    ("hours", "Hours"),
                    ("days", "Days"),
                    ("weeks", "Weeks"),
                    ("months", "Months"),
                    ("quarters", "Quarters"),
                    ("years", "Years"),
                ],
                default=("hours", "days", "weeks", "months", "quarters", "years"),
                help_text="More than one selected field will display chooser on the chart.",
                max_length=1000,
                verbose_name="Allowed time scales",
            ),
        ),
        migrations.AlterField(
            model_name="dashboardstats",
            name="allowed_type_operation_field_name",
            field=multiselectfield.db.fields.MultiSelectField(
                blank=True,
                choices=[
                    ("Count", "Count"),
                    ("Sum", "Sum"),
                    ("Avg", "Avgerage"),
                    ("AvgCountPerInstance", "Avgerage count per active model instance"),
                    ("Max", "Max"),
                    ("Min", "Min"),
                    ("StdDev", "StdDev"),
                    ("Variance", "Variance"),
                ],
                help_text="More than one selected field will display chooser on the chart.",
                max_length=1000,
                null=True,
                verbose_name="Choose Type operation",
            ),
        ),
        migrations.AlterField(
            model_name="dashboardstats",
            name="date_field_name",
            field=models.CharField(
                help_text="ex. <i>date_joined</i>, <i>invitation__invitation_date</i>",
                max_length=90,
                verbose_name="date field name",
            ),
        ),
        migrations.AlterField(
            model_name="dashboardstats",
            name="distinct",
            field=models.BooleanField(
                blank=True,
                default=False,
                help_text="Note: Distinct is supported only for <i>Count</i>, <i>Sum</i>, <i>Avg</i> and <i>'Avgerage count per active model instance'</i>.<br/>Django>=3.0 is needed for distinct <i>Sum</i> and <i>Avg</i>.",
            ),
        ),
        migrations.AlterField(
            model_name="dashboardstats",
            name="model_app_name",
            field=models.CharField(
                help_text="ex. <i>auth</i>, <i>dialer_cdr</i>",
                max_length=90,
                verbose_name="app name",
            ),
        ),
        migrations.AlterField(
            model_name="dashboardstats",
            name="model_name",
            field=models.CharField(
                help_text="ex. <i>User</i>", max_length=90, verbose_name="model name"
            ),
        ),
        migrations.AlterField(
            model_name="dashboardstats",
            name="operation_field_name",
            field=models.CharField(
                blank=True,
                help_text="The field you want to aggregate, ex. <i>amount</i>, <i>salaries__total_income</i>.<br/>Can contain multiple fields divided by comma.",
                max_length=90,
                null=True,
                verbose_name="Operate field name",
            ),
        ),
        migrations.AlterField(
            model_name="dashboardstats",
            name="type_operation_field_name",
            field=models.CharField(
                blank=True,
                choices=[
                    ("Count", "Count"),
                    ("Sum", "Sum"),
                    ("Avg", "Avgerage"),
                    ("AvgCountPerInstance", "Avgerage count per active model instance"),
                    ("Max", "Max"),
                    ("Min", "Min"),
                    ("StdDev", "StdDev"),
                    ("Variance", "Variance"),
                ],
                help_text="Choose the type operation what you want to aggregate.",
                max_length=90,
                null=True,
                verbose_name="Choose Type operation",
            ),
        ),
        migrations.AlterField(
            model_name="dashboardstats",
            name="user_field_name",
            field=models.CharField(
                blank=True,
                help_text="User field that will limit chart data only for currently logged user (if not superuser)<br/>ex. owner, <i>invitation__owner</i>",
                max_length=90,
                null=True,
                verbose_name="user field name",
            ),
        ),
        migrations.CreateModel(
            name="CachedValue",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("date", models.DateTimeField()),
                (
                    "time_scale",
                    models.CharField(
                        choices=[
                            ("hours", "Hours"),
                            ("days", "Days"),
                            ("weeks", "Weeks"),
                            ("months", "Months"),
                            ("quarters", "Quarters"),
                            ("years", "Years"),
                        ],
                        default="days",
                        max_length=90,
                        verbose_name="Default time scale",
                    ),
                ),
                (
                    "operation",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("Count", "Count"),
                            ("Sum", "Sum"),
                            ("Avg", "Avgerage"),
                            (
                                "AvgCountPerInstance",
                                "Avgerage count per active model instance",
                            ),
                            ("Max", "Max"),
                            ("Min", "Min"),
                            ("StdDev", "StdDev"),
                            ("Variance", "Variance"),
                        ],
                        max_length=90,
                        null=True,
                    ),
                ),
                (
                    "operation_field_name",
                    models.CharField(blank=True, max_length=90, null=True),
                ),
                (
                    "filtered_value",
                    models.CharField(blank=True, max_length=512, null=True),
                ),
                ("value", models.FloatField(blank=True, default=None, null=True)),
                ("dynamic_choices", JSONField(default=[])),
                (
                    "multiple_series_choice",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="admin_tools_stats.dashboardstatscriteria",
                    ),
                ),
                (
                    "stats",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="admin_tools_stats.dashboardstats",
                    ),
                ),
                ("is_final", models.BooleanField(default=True)),
            ],
        ),
    ]
