from json import loads
from urllib.parse import unquote

from paddle_billing.Entities.Collections import SimulationTypeCollection
from paddle_billing.Entities.Simulations import SimulationKind
from paddle_billing.Entities.SimulationType import SimulationType

from tests.Utils.ReadsFixture import ReadsFixtures


class TestSimulationTypesClient:
    def test_list_simulation_types_returns_expected_response(
        self,
        test_client,
        mock_requests,
    ):
        expected_path = "/simulation-types"
        expected_response_body = ReadsFixtures.read_raw_json_fixture("response/list_default")

        expected_url = f"{test_client.base_url}{expected_path}"
        mock_requests.get(expected_url, status_code=200, text=expected_response_body)

        response = test_client.client.simulation_types.list()
        response_json = test_client.client.simulation_types.response.json()
        last_request = mock_requests.last_request

        assert isinstance(response, SimulationTypeCollection)
        assert last_request is not None
        assert last_request.method == "GET"
        assert test_client.client.status_code == 200
        assert (
            unquote(last_request.url) == expected_url
        ), "The URL does not match the expected URL, verify the query string is correct"
        assert response_json == loads(
            str(expected_response_body)
        ), "The response JSON generated by ResponseParser() doesn't match the expected fixture JSON"

        assert len(response.items) == 49

        first_simulation_type = response.items[0]
        assert isinstance(first_simulation_type, SimulationType)
        assert first_simulation_type.type == SimulationKind.Scenario
        assert first_simulation_type.name == "subscription_creation"
        assert first_simulation_type.label == "Subscription created from a checkout"
        assert first_simulation_type.group == "Subscription"
        assert len(first_simulation_type.events) == 12
        assert first_simulation_type.events == [
            "transaction.created",
            "customer.created",
            "address.created",
            "transaction.updated",
            "transaction.ready",
            "transaction.updated",
            "transaction.paid",
            "subscription.created",
            "subscription.activated",
            "transaction.updated",
            "transaction.updated",
            "transaction.completed",
        ]

        for simulation_type in response.items:
            assert isinstance(simulation_type, SimulationType)
            assert isinstance(simulation_type.type, SimulationKind)
            assert simulation_type.name, "Simulation Type has no name"
            assert simulation_type.label, "Simulation Type has no label"
            assert simulation_type.group, "Simulation Type has no group"
            assert len(simulation_type.events) > 0
