from __future__ import annotations
from dataclasses import dataclass

from paddle_billing.Entities.Product import Product

from paddle_billing.Entities.Shared.Proration import Proration
from paddle_billing.Entities.Shared.Totals import Totals
from paddle_billing.Entities.Shared.UnitTotals import UnitTotals


@dataclass
class TransactionLineItem:
    id: str
    price_id: str
    quantity: int
    proration: Proration | None
    tax_rate: str
    unit_totals: UnitTotals
    totals: Totals
    product: Product

    @staticmethod
    def from_dict(data: dict) -> TransactionLineItem:
        return TransactionLineItem(
            id=data["id"],
            price_id=data["price_id"],
            quantity=data["quantity"],
            proration=Proration.from_dict(data["proration"]) if data.get("proration") else None,
            tax_rate=data["tax_rate"],
            unit_totals=UnitTotals.from_dict(data["unit_totals"]),
            totals=Totals.from_dict(data["totals"]),
            product=Product.from_dict(data["product"]),
        )
