#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['stepwise_mol_bio', 'stepwise_mol_bio.gels']

package_data = \
{'': ['*'], 'stepwise_mol_bio': ['layouts/*']}

install_requires = \
['appcli',
 'appdirs',
 'autoprop',
 'biopython',
 'freezerbox',
 'inform~=1.21',
 'more_itertools~=8.6',
 'numpy',
 'requests',
 'rtoml',
 'stepwise',
 'tidyexc']

extras_require = \
{'doc': ['sphinx', 'sphinx_rtd_theme', 'autoclasstoc'],
 'test': ['pytest', 'pytest-cov', 'parametrize_from_file', 'coveralls']}

entry_points = \
{'freezerbox.make': ['inverse-pcr = stepwise_mol_bio.invpcr:InversePcr',
                     'ivt = stepwise_mol_bio.ivt:Ivt',
                     'pcr = stepwise_mol_bio.pcr:Pcr'],
 'stepwise.protocols': ['molbio = stepwise_mol_bio:Plugin']}

setup(name='stepwise_mol_bio',
      version='1.16.0',
      description='Protocols relating to molecular biology, e.g. PCR.',
      author='Kale Kundert',
      author_email='kale@thekunderts.net',
      url='https://github.com/kalekundert/stepwise_mol_bio',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='~=3.8',
     )
