# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2017-07-14 07:34
from __future__ import unicode_literals

from decimal import Decimal
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('structure', '0052_customer_subnets'),
        ('experts', '0004_expertbid_description'),
    ]

    operations = [
        migrations.CreateModel(
            name='ExpertContract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('description', models.CharField(blank=True, max_length=500, verbose_name='description')),
                ('price', models.DecimalField(decimal_places=7, default=0, max_digits=22, validators=[django.core.validators.MinValueValidator(Decimal('0'))])),
                ('request', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='contract', to='experts.ExpertRequest')),
                ('team', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='structure.Project')),
            ],
            options={
                'ordering': ['-created'],
            },
        ),
    ]
