# Generated by Django 4.2.20 on 2025-04-16 13:29

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Platform",
            fields=[
                ("id", models.UUIDField(primary_key=True, serialize=False)),
                ("name", models.CharField(max_length=400)),
                ("abbrev", models.CharField(blank=True, max_length=50)),
                (
                    "content_provider_name",
                    models.CharField(blank=True, max_length=400, null=True),
                ),
                ("website", models.URLField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="Report",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "counter_release",
                    models.PositiveSmallIntegerField(
                        choices=[(4, "C4"), (5, "C5"), (51, "C51")]
                    ),
                ),
                ("report_id", models.CharField(max_length=20)),
            ],
            options={"unique_together": {("counter_release", "report_id")}},
        ),
        migrations.CreateModel(
            name="SushiService",
            fields=[
                ("id", models.UUIDField(primary_key=True, serialize=False)),
                (
                    "counter_release",
                    models.PositiveSmallIntegerField(
                        choices=[(4, "C4"), (5, "C5"), (51, "C51")]
                    ),
                ),
                ("url", models.URLField(blank=True, null=True)),
                (
                    "ip_address_authorization",
                    models.BooleanField(
                        blank=True,
                        help_text="Access restricted based on IP address",
                        null=True,
                    ),
                ),
                (
                    "api_key_required",
                    models.BooleanField(
                        blank=True, help_text="Is api key required", null=True
                    ),
                ),
                (
                    "platform_attr_required",
                    models.BooleanField(
                        blank=True, help_text="Is platform attr required", null=True
                    ),
                ),
                (
                    "requestor_id_required",
                    models.BooleanField(
                        blank=True, help_text="Is requestor_id required", null=True
                    ),
                ),
                (
                    "platform",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="sushi_services",
                        to="celus_registry.platform",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ReportToPlatform",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "platform",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="celus_registry.platform",
                    ),
                ),
                (
                    "report",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="celus_registry.report",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="platform",
            name="reports",
            field=models.ManyToManyField(
                related_name="platforms",
                through="celus_registry.ReportToPlatform",
                to="celus_registry.report",
            ),
        ),
    ]
