#!/usr/bin/env python
# -*- encoding: utf-8 -*-
#
# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_python.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
#
from __future__ import absolute_import, division, print_function, unicode_literals

from h2o.utils.metaclass import deprecated_params, deprecated_property
import h2o
from h2o.estimators.estimator_base import H2OEstimator
from h2o.exceptions import H2OValueError
from h2o.frame import H2OFrame
from h2o.utils.typechecks import assert_is_type, Enum, numeric


class H2OGeneralizedLinearEstimator(H2OEstimator):
    """
    Generalized Linear Modeling

    Fits a generalized linear model, specified by a response variable, a set of predictors, and a
    description of the error distribution.

    A subclass of :class:`ModelBase` is returned. The specific subclass depends on the machine learning task
    at hand (if it's binomial classification, then an H2OBinomialModel is returned, if it's regression then a
    H2ORegressionModel is returned). The default print-out of the models is shown, but further GLM-specific
    information can be queried out of the object. Upon completion of the GLM, the resulting object has
    coefficients, normalized coefficients, residual/null deviance, aic, and a host of model metrics including
    MSE, AUC (for logistic regression), degrees of freedom, and confusion matrices.
    """

    algo = "glm"
    supervised_learning = True
    _options_ = {'model_extensions': ['h2o.model.extensions.ScoringHistoryGLM',
                                      'h2o.model.extensions.StandardCoef',
                                      'h2o.model.extensions.VariableImportance']}

    @deprecated_params({'Lambda': 'lambda_'})
    def __init__(self,
                 model_id=None,  # type: Optional[Union[None, str, H2OEstimator]]
                 training_frame=None,  # type: Optional[Union[None, str, H2OFrame]]
                 validation_frame=None,  # type: Optional[Union[None, str, H2OFrame]]
                 nfolds=0,  # type: int
                 checkpoint=None,  # type: Optional[Union[None, str, H2OEstimator]]
                 export_checkpoints_dir=None,  # type: Optional[str]
                 seed=-1,  # type: int
                 keep_cross_validation_models=True,  # type: bool
                 keep_cross_validation_predictions=False,  # type: bool
                 keep_cross_validation_fold_assignment=False,  # type: bool
                 fold_assignment="auto",  # type: Literal["auto", "random", "modulo", "stratified"]
                 fold_column=None,  # type: Optional[str]
                 response_column=None,  # type: Optional[str]
                 ignored_columns=None,  # type: Optional[List[str]]
                 random_columns=None,  # type: Optional[List[int]]
                 ignore_const_cols=True,  # type: bool
                 score_each_iteration=False,  # type: bool
                 score_iteration_interval=-1,  # type: int
                 offset_column=None,  # type: Optional[str]
                 weights_column=None,  # type: Optional[str]
                 family="auto",  # type: Literal["auto", "gaussian", "binomial", "fractionalbinomial", "quasibinomial", "ordinal", "multinomial", "poisson", "gamma", "tweedie", "negativebinomial"]
                 rand_family=None,  # type: Optional[List[Literal["[gaussian]"]]]
                 tweedie_variance_power=0.0,  # type: float
                 tweedie_link_power=1.0,  # type: float
                 theta=1e-10,  # type: float
                 solver="auto",  # type: Literal["auto", "irlsm", "l_bfgs", "coordinate_descent_naive", "coordinate_descent", "gradient_descent_lh", "gradient_descent_sqerr"]
                 alpha=None,  # type: Optional[List[float]]
                 lambda_=None,  # type: Optional[List[float]]
                 lambda_search=False,  # type: bool
                 early_stopping=True,  # type: bool
                 nlambdas=-1,  # type: int
                 standardize=True,  # type: bool
                 missing_values_handling="mean_imputation",  # type: Literal["mean_imputation", "skip", "plug_values"]
                 plug_values=None,  # type: Optional[Union[None, str, H2OFrame]]
                 compute_p_values=False,  # type: bool
                 dispersion_parameter_method="pearson",  # type: Literal["deviance", "pearson", "ml"]
                 init_dispersion_parameter=1.0,  # type: float
                 remove_collinear_columns=False,  # type: bool
                 intercept=True,  # type: bool
                 non_negative=False,  # type: bool
                 max_iterations=-1,  # type: int
                 objective_epsilon=-1.0,  # type: float
                 beta_epsilon=0.0001,  # type: float
                 gradient_epsilon=-1.0,  # type: float
                 link="family_default",  # type: Literal["family_default", "identity", "logit", "log", "inverse", "tweedie", "ologit"]
                 rand_link=None,  # type: Optional[List[Literal["[identity]", "[family_default]"]]]
                 startval=None,  # type: Optional[List[float]]
                 calc_like=False,  # type: bool
                 HGLM=False,  # type: bool
                 prior=-1.0,  # type: float
                 cold_start=False,  # type: bool
                 lambda_min_ratio=-1.0,  # type: float
                 beta_constraints=None,  # type: Optional[Union[None, str, H2OFrame]]
                 max_active_predictors=-1,  # type: int
                 interactions=None,  # type: Optional[List[str]]
                 interaction_pairs=None,  # type: Optional[List[tuple]]
                 obj_reg=-1.0,  # type: float
                 stopping_rounds=0,  # type: int
                 stopping_metric="auto",  # type: Literal["auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "aucpr", "lift_top_group", "misclassification", "mean_per_class_error", "custom", "custom_increasing"]
                 stopping_tolerance=0.001,  # type: float
                 balance_classes=False,  # type: bool
                 class_sampling_factors=None,  # type: Optional[List[float]]
                 max_after_balance_size=5.0,  # type: float
                 max_confusion_matrix_size=20,  # type: int
                 max_runtime_secs=0.0,  # type: float
                 custom_metric_func=None,  # type: Optional[str]
                 generate_scoring_history=False,  # type: bool
                 auc_type="auto",  # type: Literal["auto", "none", "macro_ovr", "weighted_ovr", "macro_ovo", "weighted_ovo"]
                 dispersion_epsilon=0.0001,  # type: float
                 tweedie_epsilon=8e-17,  # type: float
                 max_iterations_dispersion=3000,  # type: int
                 build_null_model=False,  # type: bool
                 fix_dispersion_parameter=False,  # type: bool
                 generate_variable_inflation_factors=False,  # type: bool
                 fix_tweedie_variance_power=True,  # type: bool
                 dispersion_learning_rate=0.5,  # type: float
                 ):
        """
        :param model_id: Destination id for this model; auto-generated if not specified.
               Defaults to ``None``.
        :type model_id: Union[None, str, H2OEstimator], optional
        :param training_frame: Id of the training data frame.
               Defaults to ``None``.
        :type training_frame: Union[None, str, H2OFrame], optional
        :param validation_frame: Id of the validation data frame.
               Defaults to ``None``.
        :type validation_frame: Union[None, str, H2OFrame], optional
        :param nfolds: Number of folds for K-fold cross-validation (0 to disable or >= 2).
               Defaults to ``0``.
        :type nfolds: int
        :param checkpoint: Model checkpoint to resume training with.
               Defaults to ``None``.
        :type checkpoint: Union[None, str, H2OEstimator], optional
        :param export_checkpoints_dir: Automatically export generated models to this directory.
               Defaults to ``None``.
        :type export_checkpoints_dir: str, optional
        :param seed: Seed for pseudo random number generator (if applicable)
               Defaults to ``-1``.
        :type seed: int
        :param keep_cross_validation_models: Whether to keep the cross-validation models.
               Defaults to ``True``.
        :type keep_cross_validation_models: bool
        :param keep_cross_validation_predictions: Whether to keep the predictions of the cross-validation models.
               Defaults to ``False``.
        :type keep_cross_validation_predictions: bool
        :param keep_cross_validation_fold_assignment: Whether to keep the cross-validation fold assignment.
               Defaults to ``False``.
        :type keep_cross_validation_fold_assignment: bool
        :param fold_assignment: Cross-validation fold assignment scheme, if fold_column is not specified. The
               'Stratified' option will stratify the folds based on the response variable, for classification problems.
               Defaults to ``"auto"``.
        :type fold_assignment: Literal["auto", "random", "modulo", "stratified"]
        :param fold_column: Column with cross-validation fold index assignment per observation.
               Defaults to ``None``.
        :type fold_column: str, optional
        :param response_column: Response variable column.
               Defaults to ``None``.
        :type response_column: str, optional
        :param ignored_columns: Names of columns to ignore for training.
               Defaults to ``None``.
        :type ignored_columns: List[str], optional
        :param random_columns: random columns indices for HGLM.
               Defaults to ``None``.
        :type random_columns: List[int], optional
        :param ignore_const_cols: Ignore constant columns.
               Defaults to ``True``.
        :type ignore_const_cols: bool
        :param score_each_iteration: Whether to score during each iteration of model training.
               Defaults to ``False``.
        :type score_each_iteration: bool
        :param score_iteration_interval: Perform scoring for every score_iteration_interval iterations
               Defaults to ``-1``.
        :type score_iteration_interval: int
        :param offset_column: Offset column. This will be added to the combination of columns before applying the link
               function.
               Defaults to ``None``.
        :type offset_column: str, optional
        :param weights_column: Column with observation weights. Giving some observation a weight of zero is equivalent
               to excluding it from the dataset; giving an observation a relative weight of 2 is equivalent to repeating
               that row twice. Negative weights are not allowed. Note: Weights are per-row observation weights and do
               not increase the size of the data frame. This is typically the number of times a row is repeated, but
               non-integer values are supported as well. During training, rows with higher weights matter more, due to
               the larger loss function pre-factor. If you set weight = 0 for a row, the returned prediction frame at
               that row is zero and this is incorrect. To get an accurate prediction, remove all rows with weight == 0.
               Defaults to ``None``.
        :type weights_column: str, optional
        :param family: Family. Use binomial for classification with logistic regression, others are for regression
               problems.
               Defaults to ``"auto"``.
        :type family: Literal["auto", "gaussian", "binomial", "fractionalbinomial", "quasibinomial", "ordinal", "multinomial",
               "poisson", "gamma", "tweedie", "negativebinomial"]
        :param rand_family: Random Component Family array.  One for each random component. Only support gaussian for
               now.
               Defaults to ``None``.
        :type rand_family: List[Literal["[gaussian]"]], optional
        :param tweedie_variance_power: Tweedie variance power
               Defaults to ``0.0``.
        :type tweedie_variance_power: float
        :param tweedie_link_power: Tweedie link power
               Defaults to ``1.0``.
        :type tweedie_link_power: float
        :param theta: Theta
               Defaults to ``1e-10``.
        :type theta: float
        :param solver: AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on
               problems with small number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for
               datasets with many columns.
               Defaults to ``"auto"``.
        :type solver: Literal["auto", "irlsm", "l_bfgs", "coordinate_descent_naive", "coordinate_descent",
               "gradient_descent_lh", "gradient_descent_sqerr"]
        :param alpha: Distribution of regularization between the L1 (Lasso) and L2 (Ridge) penalties. A value of 1 for
               alpha represents Lasso regression, a value of 0 produces Ridge regression, and anything in between
               specifies the amount of mixing between the two. Default value of alpha is 0 when SOLVER = 'L-BFGS'; 0.5
               otherwise.
               Defaults to ``None``.
        :type alpha: List[float], optional
        :param lambda_: Regularization strength
               Defaults to ``None``.
        :type lambda_: List[float], optional
        :param lambda_search: Use lambda search starting at lambda max, given lambda is then interpreted as lambda min
               Defaults to ``False``.
        :type lambda_search: bool
        :param early_stopping: Stop early when there is no more relative improvement on train or validation (if
               provided)
               Defaults to ``True``.
        :type early_stopping: bool
        :param nlambdas: Number of lambdas to be used in a search. Default indicates: If alpha is zero, with lambda
               search set to True, the value of nlamdas is set to 30 (fewer lambdas are needed for ridge regression)
               otherwise it is set to 100.
               Defaults to ``-1``.
        :type nlambdas: int
        :param standardize: Standardize numeric columns to have zero mean and unit variance
               Defaults to ``True``.
        :type standardize: bool
        :param missing_values_handling: Handling of missing values. Either MeanImputation, Skip or PlugValues.
               Defaults to ``"mean_imputation"``.
        :type missing_values_handling: Literal["mean_imputation", "skip", "plug_values"]
        :param plug_values: Plug Values (a single row frame containing values that will be used to impute missing values
               of the training/validation frame, use with conjunction missing_values_handling = PlugValues)
               Defaults to ``None``.
        :type plug_values: Union[None, str, H2OFrame], optional
        :param compute_p_values: Request p-values computation, p-values work only with IRLSM solver and no
               regularization
               Defaults to ``False``.
        :type compute_p_values: bool
        :param dispersion_parameter_method: Method used to estimate the dispersion parameter for Tweedie, Gamma and
               Negative Binomial only.
               Defaults to ``"pearson"``.
        :type dispersion_parameter_method: Literal["deviance", "pearson", "ml"]
        :param init_dispersion_parameter: Only used for Tweedie, Gamma and Negative Binomial GLM.  Store the initial
               value of dispersion parameter.  If fix_dispersion_parameter is set, this value will be used in the
               calculation of p-values.Default to 1.0.
               Defaults to ``1.0``.
        :type init_dispersion_parameter: float
        :param remove_collinear_columns: In case of linearly dependent columns, remove some of the dependent columns
               Defaults to ``False``.
        :type remove_collinear_columns: bool
        :param intercept: Include constant term in the model
               Defaults to ``True``.
        :type intercept: bool
        :param non_negative: Restrict coefficients (not intercept) to be non-negative
               Defaults to ``False``.
        :type non_negative: bool
        :param max_iterations: Maximum number of iterations
               Defaults to ``-1``.
        :type max_iterations: int
        :param objective_epsilon: Converge if  objective value changes less than this. Default (of -1.0) indicates: If
               lambda_search is set to True the value of objective_epsilon is set to .0001. If the lambda_search is set
               to False and lambda is equal to zero, the value of objective_epsilon is set to .000001, for any other
               value of lambda the default value of objective_epsilon is set to .0001.
               Defaults to ``-1.0``.
        :type objective_epsilon: float
        :param beta_epsilon: Converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to
               IRLSM solver
               Defaults to ``0.0001``.
        :type beta_epsilon: float
        :param gradient_epsilon: Converge if  objective changes less (using L-infinity norm) than this, ONLY applies to
               L-BFGS solver. Default (of -1.0) indicates: If lambda_search is set to False and lambda is equal to zero,
               the default value of gradient_epsilon is equal to .000001, otherwise the default value is .0001. If
               lambda_search is set to True, the conditional values above are 1E-8 and 1E-6 respectively.
               Defaults to ``-1.0``.
        :type gradient_epsilon: float
        :param link: Link function.
               Defaults to ``"family_default"``.
        :type link: Literal["family_default", "identity", "logit", "log", "inverse", "tweedie", "ologit"]
        :param rand_link: Link function array for random component in HGLM.
               Defaults to ``None``.
        :type rand_link: List[Literal["[identity]", "[family_default]"]], optional
        :param startval: double array to initialize fixed and random coefficients for HGLM, coefficients for GLM.
               Defaults to ``None``.
        :type startval: List[float], optional
        :param calc_like: if true, will return likelihood function value for HGLM.
               Defaults to ``False``.
        :type calc_like: bool
        :param HGLM: If set to true, will return HGLM model.  Otherwise, normal GLM model will be returned
               Defaults to ``False``.
        :type HGLM: bool
        :param prior: Prior probability for y==1. To be used only for logistic regression iff the data has been sampled
               and the mean of response does not reflect reality.
               Defaults to ``-1.0``.
        :type prior: float
        :param cold_start: Only applicable to multiple alpha/lambda values.  If false, build the next model for next set
               of alpha/lambda values starting from the values provided by current model.  If true will start GLM model
               from scratch.
               Defaults to ``False``.
        :type cold_start: bool
        :param lambda_min_ratio: Minimum lambda used in lambda search, specified as a ratio of lambda_max (the smallest
               lambda that drives all coefficients to zero). Default indicates: if the number of observations is greater
               than the number of variables, then lambda_min_ratio is set to 0.0001; if the number of observations is
               less than the number of variables, then lambda_min_ratio is set to 0.01.
               Defaults to ``-1.0``.
        :type lambda_min_ratio: float
        :param beta_constraints: Beta constraints
               Defaults to ``None``.
        :type beta_constraints: Union[None, str, H2OFrame], optional
        :param max_active_predictors: Maximum number of active predictors during computation. Use as a stopping
               criterion to prevent expensive model building with many predictors. Default indicates: If the IRLSM
               solver is used, the value of max_active_predictors is set to 5000 otherwise it is set to 100000000.
               Defaults to ``-1``.
        :type max_active_predictors: int
        :param interactions: A list of predictor column indices to interact. All pairwise combinations will be computed
               for the list.
               Defaults to ``None``.
        :type interactions: List[str], optional
        :param interaction_pairs: A list of pairwise (first order) column interactions.
               Defaults to ``None``.
        :type interaction_pairs: List[tuple], optional
        :param obj_reg: Likelihood divider in objective value computation, default (of -1.0) will set it to 1/nobs
               Defaults to ``-1.0``.
        :type obj_reg: float
        :param stopping_rounds: Early stopping based on convergence of stopping_metric. Stop if simple moving average of
               length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)
               Defaults to ``0``.
        :type stopping_rounds: int
        :param stopping_metric: Metric to use for early stopping (AUTO: logloss for classification, deviance for
               regression and anonomaly_score for Isolation Forest). Note that custom and custom_increasing can only be
               used in GBM and DRF with the Python client.
               Defaults to ``"auto"``.
        :type stopping_metric: Literal["auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "aucpr", "lift_top_group",
               "misclassification", "mean_per_class_error", "custom", "custom_increasing"]
        :param stopping_tolerance: Relative tolerance for metric-based stopping criterion (stop if relative improvement
               is not at least this much)
               Defaults to ``0.001``.
        :type stopping_tolerance: float
        :param balance_classes: Balance training data class counts via over/under-sampling (for imbalanced data).
               Defaults to ``False``.
        :type balance_classes: bool
        :param class_sampling_factors: Desired over/under-sampling ratios per class (in lexicographic order). If not
               specified, sampling factors will be automatically computed to obtain class balance during training.
               Requires balance_classes.
               Defaults to ``None``.
        :type class_sampling_factors: List[float], optional
        :param max_after_balance_size: Maximum relative size of the training data after balancing class counts (can be
               less than 1.0). Requires balance_classes.
               Defaults to ``5.0``.
        :type max_after_balance_size: float
        :param max_confusion_matrix_size: [Deprecated] Maximum size (# classes) for confusion matrices to be printed in
               the Logs
               Defaults to ``20``.
        :type max_confusion_matrix_size: int
        :param max_runtime_secs: Maximum allowed runtime in seconds for model training. Use 0 to disable.
               Defaults to ``0.0``.
        :type max_runtime_secs: float
        :param custom_metric_func: Reference to custom evaluation function, format: `language:keyName=funcName`
               Defaults to ``None``.
        :type custom_metric_func: str, optional
        :param generate_scoring_history: If set to true, will generate scoring history for GLM.  This may significantly
               slow down the algo.
               Defaults to ``False``.
        :type generate_scoring_history: bool
        :param auc_type: Set default multinomial AUC type.
               Defaults to ``"auto"``.
        :type auc_type: Literal["auto", "none", "macro_ovr", "weighted_ovr", "macro_ovo", "weighted_ovo"]
        :param dispersion_epsilon: If changes in dispersion parameter estimation or loglikelihood value is smaller than
               dispersion_epsilon, will break out of the dispersion parameter estimation loop using maximum likelihood.
               Defaults to ``0.0001``.
        :type dispersion_epsilon: float
        :param tweedie_epsilon: In estimating tweedie dispersion parameter using maximum likelihood, this is used to
               choose the lower and upper indices in the approximating of the infinite series summation.
               Defaults to ``8e-17``.
        :type tweedie_epsilon: float
        :param max_iterations_dispersion: Control the maximum number of iterations in the dispersion parameter
               estimation loop using maximum likelihood.
               Defaults to ``3000``.
        :type max_iterations_dispersion: int
        :param build_null_model: If set, will build a model with only the intercept.  Default to false.
               Defaults to ``False``.
        :type build_null_model: bool
        :param fix_dispersion_parameter: Only used for Tweedie, Gamma and Negative Binomial GLM.  If set, will use the
               dispsersion parameter in init_dispersion_parameter as the standard error and use it to calculate the
               p-values. Default to false.
               Defaults to ``False``.
        :type fix_dispersion_parameter: bool
        :param generate_variable_inflation_factors: if true, will generate variable inflation factors for numerical
               predictors.  Default to false.
               Defaults to ``False``.
        :type generate_variable_inflation_factors: bool
        :param fix_tweedie_variance_power: If true, will fix tweedie variance power value to the value set in
               tweedie_variance_power.
               Defaults to ``True``.
        :type fix_tweedie_variance_power: bool
        :param dispersion_learning_rate: Dispersion learning rate is only valid for tweedie family dispersion parameter
               estimation using ml. It must be > 0.  This controls how much the dispersion parameter estimate is to be
               changed when the calculated loglikelihood actually decreases with the new dispersion.  In this case,
               instead of setting new dispersion = dispersion - change, we set new dispersion = dispersion +
               dispersion_learning_rate * change. Defaults to 0.5.
               Defaults to ``0.5``.
        :type dispersion_learning_rate: float
        """
        super(H2OGeneralizedLinearEstimator, self).__init__()
        self._parms = {}
        self._id = self._parms['model_id'] = model_id
        self.training_frame = training_frame
        self.validation_frame = validation_frame
        self.nfolds = nfolds
        self.checkpoint = checkpoint
        self.export_checkpoints_dir = export_checkpoints_dir
        self.seed = seed
        self.keep_cross_validation_models = keep_cross_validation_models
        self.keep_cross_validation_predictions = keep_cross_validation_predictions
        self.keep_cross_validation_fold_assignment = keep_cross_validation_fold_assignment
        self.fold_assignment = fold_assignment
        self.fold_column = fold_column
        self.response_column = response_column
        self.ignored_columns = ignored_columns
        self.random_columns = random_columns
        self.ignore_const_cols = ignore_const_cols
        self.score_each_iteration = score_each_iteration
        self.score_iteration_interval = score_iteration_interval
        self.offset_column = offset_column
        self.weights_column = weights_column
        self.family = family
        self.rand_family = rand_family
        self.tweedie_variance_power = tweedie_variance_power
        self.tweedie_link_power = tweedie_link_power
        self.theta = theta
        self.solver = solver
        self.alpha = alpha
        self.lambda_ = lambda_
        self.lambda_search = lambda_search
        self.early_stopping = early_stopping
        self.nlambdas = nlambdas
        self.standardize = standardize
        self.missing_values_handling = missing_values_handling
        self.plug_values = plug_values
        self.compute_p_values = compute_p_values
        self.dispersion_parameter_method = dispersion_parameter_method
        self.init_dispersion_parameter = init_dispersion_parameter
        self.remove_collinear_columns = remove_collinear_columns
        self.intercept = intercept
        self.non_negative = non_negative
        self.max_iterations = max_iterations
        self.objective_epsilon = objective_epsilon
        self.beta_epsilon = beta_epsilon
        self.gradient_epsilon = gradient_epsilon
        self.link = link
        self.rand_link = rand_link
        self.startval = startval
        self.calc_like = calc_like
        self.HGLM = HGLM
        self.prior = prior
        self.cold_start = cold_start
        self.lambda_min_ratio = lambda_min_ratio
        self.beta_constraints = beta_constraints
        self.max_active_predictors = max_active_predictors
        self.interactions = interactions
        self.interaction_pairs = interaction_pairs
        self.obj_reg = obj_reg
        self.stopping_rounds = stopping_rounds
        self.stopping_metric = stopping_metric
        self.stopping_tolerance = stopping_tolerance
        self.balance_classes = balance_classes
        self.class_sampling_factors = class_sampling_factors
        self.max_after_balance_size = max_after_balance_size
        self.max_confusion_matrix_size = max_confusion_matrix_size
        self.max_runtime_secs = max_runtime_secs
        self.custom_metric_func = custom_metric_func
        self.generate_scoring_history = generate_scoring_history
        self.auc_type = auc_type
        self.dispersion_epsilon = dispersion_epsilon
        self.tweedie_epsilon = tweedie_epsilon
        self.max_iterations_dispersion = max_iterations_dispersion
        self.build_null_model = build_null_model
        self.fix_dispersion_parameter = fix_dispersion_parameter
        self.generate_variable_inflation_factors = generate_variable_inflation_factors
        self.fix_tweedie_variance_power = fix_tweedie_variance_power
        self.dispersion_learning_rate = dispersion_learning_rate

    @property
    def training_frame(self):
        """
        Id of the training data frame.

        Type: ``Union[None, str, H2OFrame]``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8],
        ...                                 seed=1234)
        >>> cars_glm = H2OGeneralizedLinearEstimator(seed=1234,
        ...                                          family='binomial')
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.auc(train=True)
        """
        return self._parms.get("training_frame")

    @training_frame.setter
    def training_frame(self, training_frame):
        self._parms["training_frame"] = H2OFrame._validate(training_frame, 'training_frame')

    @property
    def validation_frame(self):
        """
        Id of the validation data frame.

        Type: ``Union[None, str, H2OFrame]``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8], seed=1234)
        >>> cars_glm = H2OGeneralizedLinearEstimator(seed=1234,
        ...                                          family='binomial')
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.auc(valid=True)
        """
        return self._parms.get("validation_frame")

    @validation_frame.setter
    def validation_frame(self, validation_frame):
        self._parms["validation_frame"] = H2OFrame._validate(validation_frame, 'validation_frame')

    @property
    def nfolds(self):
        """
        Number of folds for K-fold cross-validation (0 to disable or >= 2).

        Type: ``int``, defaults to ``0``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> folds = 5
        >>> cars_glm = H2OGeneralizedLinearEstimator(nfolds=folds,
        ...                                          seed=1234,
        ...                                          family='binomial')
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=cars)
        >>> cars_glm.auc(xval=True)
        """
        return self._parms.get("nfolds")

    @nfolds.setter
    def nfolds(self, nfolds):
        assert_is_type(nfolds, None, int)
        self._parms["nfolds"] = nfolds

    @property
    def checkpoint(self):
        """
        Model checkpoint to resume training with.

        Type: ``Union[None, str, H2OEstimator]``.
        """
        return self._parms.get("checkpoint")

    @checkpoint.setter
    def checkpoint(self, checkpoint):
        assert_is_type(checkpoint, None, str, H2OEstimator)
        self._parms["checkpoint"] = checkpoint

    @property
    def export_checkpoints_dir(self):
        """
        Automatically export generated models to this directory.

        Type: ``str``.

        :examples:

        >>> import tempfile
        >>> from os import listdir
        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> predictors = ["displacement","power","weight","year"]
        >>> response = "acceleration"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> checkpoints = tempfile.mkdtemp()
        >>> cars_glm = H2OGeneralizedLinearEstimator(export_checkpoints_dir=checkpoints,
        ...                                          seed=1234)
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.mse()
        >>> len(listdir(checkpoints_dir))
        """
        return self._parms.get("export_checkpoints_dir")

    @export_checkpoints_dir.setter
    def export_checkpoints_dir(self, export_checkpoints_dir):
        assert_is_type(export_checkpoints_dir, None, str)
        self._parms["export_checkpoints_dir"] = export_checkpoints_dir

    @property
    def seed(self):
        """
        Seed for pseudo random number generator (if applicable)

        Type: ``int``, defaults to ``-1``.

        :examples:

        >>> airlines= h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/airlines/allyears2k_headers.zip")
        >>> airlines["Year"] = airlines["Year"].asfactor()
        >>> airlines["Month"] = airlines["Month"].asfactor()
        >>> airlines["DayOfWeek"] = airlines["DayOfWeek"].asfactor()
        >>> airlines["Cancelled"] = airlines["Cancelled"].asfactor()
        >>> airlines['FlightNum'] = airlines['FlightNum'].asfactor()
        >>> predictors = ["Origin", "Dest", "Year", "UniqueCarrier",
        ...               "DayOfWeek", "Month", "Distance", "FlightNum"]
        >>> response = "IsDepDelayed"
        >>> train, valid = airlines.split_frame(ratios=[.8], seed=1234)
        >>> glm_w_seed = H2OGeneralizedLinearEstimator(family='binomial',
        ...                                            seed=1234)
        >>> glm_w_seed.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> print(glm_w_seed_1.auc(valid=True))
        """
        return self._parms.get("seed")

    @seed.setter
    def seed(self, seed):
        assert_is_type(seed, None, int)
        self._parms["seed"] = seed

    @property
    def keep_cross_validation_models(self):
        """
        Whether to keep the cross-validation models.

        Type: ``bool``, defaults to ``True``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8], seed=1234)
        >>> cars_glm = H2OGeneralizedLinearEstimator(keep_cross_validation_models=True,
        ...                                          nfolds=5,
        ...                                          seed=1234,
        ...                                          family="binomial")
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train)
        >>> cars_glm_cv_models = cars_glm.cross_validation_models()
        >>> print(cars_glm.cross_validation_models())
        """
        return self._parms.get("keep_cross_validation_models")

    @keep_cross_validation_models.setter
    def keep_cross_validation_models(self, keep_cross_validation_models):
        assert_is_type(keep_cross_validation_models, None, bool)
        self._parms["keep_cross_validation_models"] = keep_cross_validation_models

    @property
    def keep_cross_validation_predictions(self):
        """
        Whether to keep the predictions of the cross-validation models.

        Type: ``bool``, defaults to ``False``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8], seed=1234)
        >>> cars_glm = H2OGeneralizedLinearEstimator(keep_cross_validation_predictions=True,
        ...                                          nfolds=5,
        ...                                          seed=1234,
        ...                                          family="binomial")
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train)
        >>> cars_glm.cross_validation_predictions()
        """
        return self._parms.get("keep_cross_validation_predictions")

    @keep_cross_validation_predictions.setter
    def keep_cross_validation_predictions(self, keep_cross_validation_predictions):
        assert_is_type(keep_cross_validation_predictions, None, bool)
        self._parms["keep_cross_validation_predictions"] = keep_cross_validation_predictions

    @property
    def keep_cross_validation_fold_assignment(self):
        """
        Whether to keep the cross-validation fold assignment.

        Type: ``bool``, defaults to ``False``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8], seed=1234)
        >>> cars_glm = H2OGeneralizedLinearEstimator(keep_cross_validation_fold_assignment=True,
        ...                                          nfolds=5,
        ...                                          seed=1234,
        ...                                          family="binomial")
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train)
        >>> cars_glm.cross_validation_fold_assignment()
        """
        return self._parms.get("keep_cross_validation_fold_assignment")

    @keep_cross_validation_fold_assignment.setter
    def keep_cross_validation_fold_assignment(self, keep_cross_validation_fold_assignment):
        assert_is_type(keep_cross_validation_fold_assignment, None, bool)
        self._parms["keep_cross_validation_fold_assignment"] = keep_cross_validation_fold_assignment

    @property
    def fold_assignment(self):
        """
        Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will stratify
        the folds based on the response variable, for classification problems.

        Type: ``Literal["auto", "random", "modulo", "stratified"]``, defaults to ``"auto"``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> assignment_type = "Random"
        >>> cars_gml = H2OGeneralizedLinearEstimator(fold_assignment=assignment_type,
        ...                                          nfolds=5,
        ...                                          family='binomial',
        ...                                          seed=1234)
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=cars)
        >>> cars_glm.auc(train=True)
        """
        return self._parms.get("fold_assignment")

    @fold_assignment.setter
    def fold_assignment(self, fold_assignment):
        assert_is_type(fold_assignment, None, Enum("auto", "random", "modulo", "stratified"))
        self._parms["fold_assignment"] = fold_assignment

    @property
    def fold_column(self):
        """
        Column with cross-validation fold index assignment per observation.

        Type: ``str``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> fold_numbers = cars.kfold_column(n_folds=5, seed=1234)
        >>> fold_numbers.set_names(["fold_numbers"])
        >>> cars = cars.cbind(fold_numbers)
        >>> print(cars['fold_numbers'])
        >>>  cars_glm = H2OGeneralizedLinearEstimator(seed=1234,
        ...                                           family="binomial")
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=cars,
        ...                fold_column="fold_numbers")
        >>> cars_glm.auc(xval=True)
        """
        return self._parms.get("fold_column")

    @fold_column.setter
    def fold_column(self, fold_column):
        assert_is_type(fold_column, None, str)
        self._parms["fold_column"] = fold_column

    @property
    def response_column(self):
        """
        Response variable column.

        Type: ``str``.
        """
        return self._parms.get("response_column")

    @response_column.setter
    def response_column(self, response_column):
        assert_is_type(response_column, None, str)
        self._parms["response_column"] = response_column

    @property
    def ignored_columns(self):
        """
        Names of columns to ignore for training.

        Type: ``List[str]``.
        """
        return self._parms.get("ignored_columns")

    @ignored_columns.setter
    def ignored_columns(self, ignored_columns):
        assert_is_type(ignored_columns, None, [str])
        self._parms["ignored_columns"] = ignored_columns

    @property
    def random_columns(self):
        """
        random columns indices for HGLM.

        Type: ``List[int]``.
        """
        return self._parms.get("random_columns")

    @random_columns.setter
    def random_columns(self, random_columns):
        assert_is_type(random_columns, None, [int])
        self._parms["random_columns"] = random_columns

    @property
    def ignore_const_cols(self):
        """
        Ignore constant columns.

        Type: ``bool``, defaults to ``True``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> cars["const_1"] = 6
        >>> cars["const_2"] = 7
        >>> train, valid = cars.split_frame(ratios=[.8], seed=1234)
        >>> cars_glm = H2OGeneralizedLinearEstimator(seed=1234,
        ...                                          ignore_const_cols=True,
        ...                                          family="binomial")
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.auc(valid=True)
        """
        return self._parms.get("ignore_const_cols")

    @ignore_const_cols.setter
    def ignore_const_cols(self, ignore_const_cols):
        assert_is_type(ignore_const_cols, None, bool)
        self._parms["ignore_const_cols"] = ignore_const_cols

    @property
    def score_each_iteration(self):
        """
        Whether to score during each iteration of model training.

        Type: ``bool``, defaults to ``False``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8], seed=1234)
        >>> cars_glm = H2OGeneralizedLinearEstimator(score_each_iteration=True,
        ...                                          seed=1234,
        ...                                          family='binomial')
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.scoring_history()
        """
        return self._parms.get("score_each_iteration")

    @score_each_iteration.setter
    def score_each_iteration(self, score_each_iteration):
        assert_is_type(score_each_iteration, None, bool)
        self._parms["score_each_iteration"] = score_each_iteration

    @property
    def score_iteration_interval(self):
        """
        Perform scoring for every score_iteration_interval iterations

        Type: ``int``, defaults to ``-1``.
        """
        return self._parms.get("score_iteration_interval")

    @score_iteration_interval.setter
    def score_iteration_interval(self, score_iteration_interval):
        assert_is_type(score_iteration_interval, None, int)
        self._parms["score_iteration_interval"] = score_iteration_interval

    @property
    def offset_column(self):
        """
        Offset column. This will be added to the combination of columns before applying the link function.

        Type: ``str``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> boston["offset"] = boston["medv"].log()
        >>> train, valid = boston.split_frame(ratios=[.8], seed=1234)
        >>> boston_glm = H2OGeneralizedLinearEstimator(offset_column="offset",
        ...                                            seed=1234)
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> boston_glm.mse(valid=True)
        """
        return self._parms.get("offset_column")

    @offset_column.setter
    def offset_column(self, offset_column):
        assert_is_type(offset_column, None, str)
        self._parms["offset_column"] = offset_column

    @property
    def weights_column(self):
        """
        Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from the
        dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
        weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the data
        frame. This is typically the number of times a row is repeated, but non-integer values are supported as well.
        During training, rows with higher weights matter more, due to the larger loss function pre-factor. If you set
        weight = 0 for a row, the returned prediction frame at that row is zero and this is incorrect. To get an
        accurate prediction, remove all rows with weight == 0.

        Type: ``str``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8], seed=1234)
        >>> cars_glm = H2OGeneralizedLinearEstimator(seed=1234,
        ...                                          family='binomial')
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid,
        ...                weights_column="weight")
        >>> cars_glm.auc(valid=True)
        """
        return self._parms.get("weights_column")

    @weights_column.setter
    def weights_column(self, weights_column):
        assert_is_type(weights_column, None, str)
        self._parms["weights_column"] = weights_column

    @property
    def family(self):
        """
        Family. Use binomial for classification with logistic regression, others are for regression problems.

        Type: ``Literal["auto", "gaussian", "binomial", "fractionalbinomial", "quasibinomial", "ordinal", "multinomial",
        "poisson", "gamma", "tweedie", "negativebinomial"]``, defaults to ``"auto"``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> cars_glm = H2OGeneralizedLinearEstimator(family='binomial')
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.auc(valid = True)
        """
        return self._parms.get("family")

    @family.setter
    def family(self, family):
        assert_is_type(family, None, Enum("auto", "gaussian", "binomial", "fractionalbinomial", "quasibinomial", "ordinal", "multinomial", "poisson", "gamma", "tweedie", "negativebinomial"))
        self._parms["family"] = family

    @property
    def rand_family(self):
        """
        Random Component Family array.  One for each random component. Only support gaussian for now.

        Type: ``List[Literal["[gaussian]"]]``.
        """
        return self._parms.get("rand_family")

    @rand_family.setter
    def rand_family(self, rand_family):
        assert_is_type(rand_family, None, [Enum("[gaussian]")])
        self._parms["rand_family"] = rand_family

    @property
    def tweedie_variance_power(self):
        """
        Tweedie variance power

        Type: ``float``, defaults to ``0.0``.

        :examples:

        >>> auto = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/glm_test/auto.csv")
        >>> predictors = auto.names
        >>> predictors.remove('y')
        >>> response = "y"
        >>> train, valid = auto.split_frame(ratios=[.8])
        >>> auto_glm = H2OGeneralizedLinearEstimator(family='tweedie',
        ...                                          tweedie_variance_power=1)
        >>> auto_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> print(auto_glm.mse(valid=True))
        """
        return self._parms.get("tweedie_variance_power")

    @tweedie_variance_power.setter
    def tweedie_variance_power(self, tweedie_variance_power):
        assert_is_type(tweedie_variance_power, None, numeric)
        self._parms["tweedie_variance_power"] = tweedie_variance_power

    @property
    def tweedie_link_power(self):
        """
        Tweedie link power

        Type: ``float``, defaults to ``1.0``.

        :examples:

        >>> auto = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/glm_test/auto.csv")
        >>> predictors = auto.names
        >>> predictors.remove('y')
        >>> response = "y"
        >>> train, valid = auto.split_frame(ratios=[.8])
        >>> auto_glm = H2OGeneralizedLinearEstimator(family='tweedie',
        ...                                          tweedie_link_power=1)
        >>> auto_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> print(auto_glm.mse(valid=True))
        """
        return self._parms.get("tweedie_link_power")

    @tweedie_link_power.setter
    def tweedie_link_power(self, tweedie_link_power):
        assert_is_type(tweedie_link_power, None, numeric)
        self._parms["tweedie_link_power"] = tweedie_link_power

    @property
    def theta(self):
        """
        Theta

        Type: ``float``, defaults to ``1e-10``.

        :examples:

        >>> h2o_df = h2o.import_file("http://h2o-public-test-data.s3.amazonaws.com/smalldata/glm_test/Motor_insurance_sweden.txt")
        >>> predictors = ["Payment", "Insured", "Kilometres", "Zone", "Bonus", "Make"]
        >>> response = "Claims"
        >>> negativebinomial_fit = H2OGeneralizedLinearEstimator(family="negativebinomial",
        ...                                                      link="identity",
        ...                                                      theta=0.5)
        >>> negativebinomial_fit.train(x=predictors,
        ...                            y=response,
        ...                            training_frame=h2o_df)
        >>> negativebinomial_fit.scoring_history()
        """
        return self._parms.get("theta")

    @theta.setter
    def theta(self, theta):
        assert_is_type(theta, None, numeric)
        self._parms["theta"] = theta

    @property
    def solver(self):
        """
        AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on problems with small
        number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for datasets with many columns.

        Type: ``Literal["auto", "irlsm", "l_bfgs", "coordinate_descent_naive", "coordinate_descent",
        "gradient_descent_lh", "gradient_descent_sqerr"]``, defaults to ``"auto"``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> boston_glm = H2OGeneralizedLinearEstimator(solver='irlsm')
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> print(boston_glm.mse(valid=True))
        """
        return self._parms.get("solver")

    @solver.setter
    def solver(self, solver):
        assert_is_type(solver, None, Enum("auto", "irlsm", "l_bfgs", "coordinate_descent_naive", "coordinate_descent", "gradient_descent_lh", "gradient_descent_sqerr"))
        self._parms["solver"] = solver

    @property
    def alpha(self):
        """
        Distribution of regularization between the L1 (Lasso) and L2 (Ridge) penalties. A value of 1 for alpha
        represents Lasso regression, a value of 0 produces Ridge regression, and anything in between specifies the
        amount of mixing between the two. Default value of alpha is 0 when SOLVER = 'L-BFGS'; 0.5 otherwise.

        Type: ``List[float]``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> boston_glm = H2OGeneralizedLinearEstimator(alpha=.25)
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> print(boston_glm.mse(valid=True))
        """
        return self._parms.get("alpha")

    @alpha.setter
    def alpha(self, alpha):
        # For `alpha` and `lambda` the server reports type float[], while in practice simple floats are also ok
        assert_is_type(alpha, None, numeric, [numeric])
        self._parms["alpha"] = alpha

    @property
    def lambda_(self):
        """
        Regularization strength

        Type: ``List[float]``.

        :examples:

        >>> airlines= h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/airlines/allyears2k_headers.zip")
        >>> airlines["Year"] = airlines["Year"].asfactor()
        >>> airlines["Month"] = airlines["Month"].asfactor()
        >>> airlines["DayOfWeek"] = airlines["DayOfWeek"].asfactor()
        >>> airlines["Cancelled"] = airlines["Cancelled"].asfactor()
        >>> airlines['FlightNum'] = airlines['FlightNum'].asfactor()
        >>> predictors = ["Origin", "Dest", "Year", "UniqueCarrier",
        ...               "DayOfWeek", "Month", "Distance", "FlightNum"]
        >>> response = "IsDepDelayed"
        >>> train, valid = airlines.split_frame(ratios=[.8])
        >>> airlines_glm = H2OGeneralizedLinearEstimator(family='binomial',
        ...                                              lambda_=.0001)
        >>> airlines_glm.train(x=predictors,
        ...                    y=response
        ...                    trainig_frame=train,
        ...                    validation_frame=valid)
        >>> print(airlines_glm.auc(valid=True))
        """
        return self._parms.get("lambda")

    @lambda_.setter
    def lambda_(self, lambda_):
        assert_is_type(lambda_, None, numeric, [numeric])
        self._parms["lambda"] = lambda_

    @property
    def lambda_search(self):
        """
        Use lambda search starting at lambda max, given lambda is then interpreted as lambda min

        Type: ``bool``, defaults to ``False``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> boston_glm = H2OGeneralizedLinearEstimator(lambda_search=True)
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> print(boston_glm.mse(valid=True))
        """
        return self._parms.get("lambda_search")

    @lambda_search.setter
    def lambda_search(self, lambda_search):
        assert_is_type(lambda_search, None, bool)
        self._parms["lambda_search"] = lambda_search

    @property
    def early_stopping(self):
        """
        Stop early when there is no more relative improvement on train or validation (if provided)

        Type: ``bool``, defaults to ``True``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> cars_glm = H2OGeneralizedLinearEstimator(family='binomial',
        ...                                          early_stopping=True)
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.auc(valid=True)
        """
        return self._parms.get("early_stopping")

    @early_stopping.setter
    def early_stopping(self, early_stopping):
        assert_is_type(early_stopping, None, bool)
        self._parms["early_stopping"] = early_stopping

    @property
    def nlambdas(self):
        """
        Number of lambdas to be used in a search. Default indicates: If alpha is zero, with lambda search set to True,
        the value of nlamdas is set to 30 (fewer lambdas are needed for ridge regression) otherwise it is set to 100.

        Type: ``int``, defaults to ``-1``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> boston_glm = H2OGeneralizedLinearEstimator(lambda_search=True,
        ...                                            nlambdas=50)
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> print(boston_glm.mse(valid=True))
        """
        return self._parms.get("nlambdas")

    @nlambdas.setter
    def nlambdas(self, nlambdas):
        assert_is_type(nlambdas, None, int)
        self._parms["nlambdas"] = nlambdas

    @property
    def standardize(self):
        """
        Standardize numeric columns to have zero mean and unit variance

        Type: ``bool``, defaults to ``True``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> boston_glm = H2OGeneralizedLinearEstimator(standardize=True)
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> boston_glm.mse()
        """
        return self._parms.get("standardize")

    @standardize.setter
    def standardize(self, standardize):
        assert_is_type(standardize, None, bool)
        self._parms["standardize"] = standardize

    @property
    def missing_values_handling(self):
        """
        Handling of missing values. Either MeanImputation, Skip or PlugValues.

        Type: ``Literal["mean_imputation", "skip", "plug_values"]``, defaults to ``"mean_imputation"``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> boston.insert_missing_values()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> boston_glm = H2OGeneralizedLinearEstimator(missing_values_handling="skip")
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> boston_glm.mse()
        """
        return self._parms.get("missing_values_handling")

    @missing_values_handling.setter
    def missing_values_handling(self, missing_values_handling):
        assert_is_type(missing_values_handling, None, Enum("mean_imputation", "skip", "plug_values"))
        self._parms["missing_values_handling"] = missing_values_handling

    @property
    def plug_values(self):
        """
        Plug Values (a single row frame containing values that will be used to impute missing values of the
        training/validation frame, use with conjunction missing_values_handling = PlugValues)

        Type: ``Union[None, str, H2OFrame]``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars = cars.drop(0)
        >>> means = cars.mean()
        >>> means = H2OFrame._expr(ExprNode("mean", cars, True, 0))
        >>> glm_means = H2OGeneralizedLinearEstimator(seed=42)
        >>> glm_means.train(training_frame=cars, y="cylinders")
        >>> glm_plugs1 = H2OGeneralizedLinearEstimator(seed=42,
        ...                                            missing_values_handling="PlugValues",
        ...                                            plug_values=means)
        >>> glm_plugs1.train(training_frame=cars, y="cylinders")
        >>> glm_means.coef() == glm_plugs1.coef()
        >>> not_means = 0.1 + (means * 0.5)
        >>> glm_plugs2 = H2OGeneralizedLinearEstimator(seed=42,
        ...                                            missing_values_handling="PlugValues",
        ...                                            plug_values=not_means)
        >>> glm_plugs2.train(training_frame=cars, y="cylinders")
        >>> glm_means.coef() != glm_plugs2.coef()
        """
        return self._parms.get("plug_values")

    @plug_values.setter
    def plug_values(self, plug_values):
        self._parms["plug_values"] = H2OFrame._validate(plug_values, 'plug_values')

    @property
    def compute_p_values(self):
        """
        Request p-values computation, p-values work only with IRLSM solver and no regularization

        Type: ``bool``, defaults to ``False``.

        :examples:

        >>> airlines= h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/airlines/allyears2k_headers.zip")
        >>> airlines["Year"] = airlines["Year"].asfactor()
        >>> airlines["Month"] = airlines["Month"].asfactor()
        >>> airlines["DayOfWeek"] = airlines["DayOfWeek"].asfactor()
        >>> airlines["Cancelled"] = airlines["Cancelled"].asfactor()
        >>> airlines['FlightNum'] = airlines['FlightNum'].asfactor()
        >>> predictors = ["Origin", "Dest", "Year", "UniqueCarrier",
        ...               "DayOfWeek", "Month", "Distance", "FlightNum"]
        >>> response = "IsDepDelayed"
        >>> train, valid= airlines.split_frame(ratios=[.8])
        >>> airlines_glm = H2OGeneralizedLinearEstimator(family='binomial',
        ...                                              lambda_=0,
        ...                                              remove_collinear_columns=True,
        ...                                              compute_p_values=True)
        >>> airlines_glm.train(x=predictors,
        ...                    y=response,
        ...                    training_frame=train,
        ...                    validation_frame=valid)
        >>> airlines_glm.mse()
        """
        return self._parms.get("compute_p_values")

    @compute_p_values.setter
    def compute_p_values(self, compute_p_values):
        assert_is_type(compute_p_values, None, bool)
        self._parms["compute_p_values"] = compute_p_values

    @property
    def dispersion_parameter_method(self):
        """
        Method used to estimate the dispersion parameter for Tweedie, Gamma and Negative Binomial only.

        Type: ``Literal["deviance", "pearson", "ml"]``, defaults to ``"pearson"``.
        """
        return self._parms.get("dispersion_parameter_method")

    @dispersion_parameter_method.setter
    def dispersion_parameter_method(self, dispersion_parameter_method):
        assert_is_type(dispersion_parameter_method, None, Enum("deviance", "pearson", "ml"))
        self._parms["dispersion_parameter_method"] = dispersion_parameter_method

    @property
    def init_dispersion_parameter(self):
        """
        Only used for Tweedie, Gamma and Negative Binomial GLM.  Store the initial value of dispersion parameter.  If
        fix_dispersion_parameter is set, this value will be used in the calculation of p-values.Default to 1.0.

        Type: ``float``, defaults to ``1.0``.
        """
        return self._parms.get("init_dispersion_parameter")

    @init_dispersion_parameter.setter
    def init_dispersion_parameter(self, init_dispersion_parameter):
        assert_is_type(init_dispersion_parameter, None, numeric)
        self._parms["init_dispersion_parameter"] = init_dispersion_parameter

    @property
    def remove_collinear_columns(self):
        """
        In case of linearly dependent columns, remove some of the dependent columns

        Type: ``bool``, defaults to ``False``.

        :examples:

        >>> airlines= h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/airlines/allyears2k_headers.zip")
        >>> airlines["Year"] = airlines["Year"].asfactor()
        >>> airlines["Month"] = airlines["Month"].asfactor()
        >>> airlines["DayOfWeek"] = airlines["DayOfWeek"].asfactor()
        >>> airlines["Cancelled"] = airlines["Cancelled"].asfactor()
        >>> airlines['FlightNum'] = airlines['FlightNum'].asfactor()
        >>> predictors = ["Origin", "Dest", "Year", "UniqueCarrier",
        ...               "DayOfWeek", "Month", "Distance", "FlightNum"]
        >>> response = "IsDepDelayed"
        >>> train, valid = airlines.split_frame(ratios=[.8])
        >>> airlines_glm = H2OGeneralizedLinearEstimator(family='binomial',
        ...                                              lambda_=0,
        ...                                              remove_collinear_columns=True)
        >>> airlines_glm.train(x=predictors,
        ...                    y=response,
        ...                    training_frame=train,
        ...                    validation_frame=valid)
        >>> airlines_glm.auc()
        """
        return self._parms.get("remove_collinear_columns")

    @remove_collinear_columns.setter
    def remove_collinear_columns(self, remove_collinear_columns):
        assert_is_type(remove_collinear_columns, None, bool)
        self._parms["remove_collinear_columns"] = remove_collinear_columns

    @property
    def intercept(self):
        """
        Include constant term in the model

        Type: ``bool``, defaults to ``True``.

        :examples:

        >>> iris = h2o.import_file("http://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_wheader.csv")
        >>> iris['class'] = iris['class'].asfactor()
        >>> predictors = iris.columns[:-1]
        >>> response = 'class'
        >>> train, valid = iris.split_frame(ratios=[.8])
        >>> iris_glm = H2OGeneralizedLinearEstimator(family='multinomial',
        ...                                          intercept=True)
        >>> iris_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> iris_glm.logloss(valid=True)
        """
        return self._parms.get("intercept")

    @intercept.setter
    def intercept(self, intercept):
        assert_is_type(intercept, None, bool)
        self._parms["intercept"] = intercept

    @property
    def non_negative(self):
        """
        Restrict coefficients (not intercept) to be non-negative

        Type: ``bool``, defaults to ``False``.

        :examples:

        >>> airlines = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/airlines/allyears2k_headers.zip")
        >>> airlines["Year"] = airlines["Year"].asfactor()
        >>> airlines["Month"] = airlines["Month"].asfactor()
        >>> airlines["DayOfWeek"] = airlines["DayOfWeek"].asfactor()
        >>> airlines["Cancelled"] = airlines["Cancelled"].asfactor()
        >>> airlines['FlightNum'] = airlines['FlightNum'].asfactor()
        >>> predictors = ["Origin", "Dest", "Year", "UniqueCarrier",
        ...               "DayOfWeek", "Month", "Distance", "FlightNum"]
        >>> response = "IsDepDelayed"
        >>> train, valid= airlines.split_frame(ratios=[.8])
        >>> airlines_glm = H2OGeneralizedLinearEstimator(family='binomial',
        ...                                              non_negative=True)
        >>> airlines_glm.train(x=predictors,
        ...                    y=response,
        ...                    training_frame=train,
        ...                    validation_frame=valid)
        >>> airlines_glm.auc()
        """
        return self._parms.get("non_negative")

    @non_negative.setter
    def non_negative(self, non_negative):
        assert_is_type(non_negative, None, bool)
        self._parms["non_negative"] = non_negative

    @property
    def max_iterations(self):
        """
        Maximum number of iterations

        Type: ``int``, defaults to ``-1``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> cars_glm = H2OGeneralizedLinearEstimator(family='binomial',
        ...                                          max_iterations=50)
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.mse()
        """
        return self._parms.get("max_iterations")

    @max_iterations.setter
    def max_iterations(self, max_iterations):
        assert_is_type(max_iterations, None, int)
        self._parms["max_iterations"] = max_iterations

    @property
    def objective_epsilon(self):
        """
        Converge if  objective value changes less than this. Default (of -1.0) indicates: If lambda_search is set to
        True the value of objective_epsilon is set to .0001. If the lambda_search is set to False and lambda is equal to
        zero, the value of objective_epsilon is set to .000001, for any other value of lambda the default value of
        objective_epsilon is set to .0001.

        Type: ``float``, defaults to ``-1.0``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> boston_glm = H2OGeneralizedLinearEstimator(objective_epsilon=1e-3)
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> boston_glm.mse()
        """
        return self._parms.get("objective_epsilon")

    @objective_epsilon.setter
    def objective_epsilon(self, objective_epsilon):
        assert_is_type(objective_epsilon, None, numeric)
        self._parms["objective_epsilon"] = objective_epsilon

    @property
    def beta_epsilon(self):
        """
        Converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to IRLSM solver

        Type: ``float``, defaults to ``0.0001``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> predictors = ["displacement","power","weight","year"]
        >>> response = "acceleration"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> cars_glm = H2OGeneralizedLinearEstimator(beta_epsilon=1e-3)
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.mse()
        """
        return self._parms.get("beta_epsilon")

    @beta_epsilon.setter
    def beta_epsilon(self, beta_epsilon):
        assert_is_type(beta_epsilon, None, numeric)
        self._parms["beta_epsilon"] = beta_epsilon

    @property
    def gradient_epsilon(self):
        """
        Converge if  objective changes less (using L-infinity norm) than this, ONLY applies to L-BFGS solver. Default
        (of -1.0) indicates: If lambda_search is set to False and lambda is equal to zero, the default value of
        gradient_epsilon is equal to .000001, otherwise the default value is .0001. If lambda_search is set to True, the
        conditional values above are 1E-8 and 1E-6 respectively.

        Type: ``float``, defaults to ``-1.0``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> boston_glm = H2OGeneralizedLinearEstimator(gradient_epsilon=1e-3)
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> boston_glm.mse()
        """
        return self._parms.get("gradient_epsilon")

    @gradient_epsilon.setter
    def gradient_epsilon(self, gradient_epsilon):
        assert_is_type(gradient_epsilon, None, numeric)
        self._parms["gradient_epsilon"] = gradient_epsilon

    @property
    def link(self):
        """
        Link function.

        Type: ``Literal["family_default", "identity", "logit", "log", "inverse", "tweedie", "ologit"]``, defaults to
        ``"family_default"``.

        :examples:

        >>> iris = h2o.import_file("http://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_wheader.csv")
        >>> iris['class'] = iris['class'].asfactor()
        >>> predictors = iris.columns[:-1]
        >>> response = 'class'
        >>> train, valid = iris.split_frame(ratios=[.8])
        >>> iris_glm = H2OGeneralizedLinearEstimator(family='multinomial',
        ...                                          link='family_default')
        >>> iris_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> iris_glm.logloss()
        """
        return self._parms.get("link")

    @link.setter
    def link(self, link):
        assert_is_type(link, None, Enum("family_default", "identity", "logit", "log", "inverse", "tweedie", "ologit"))
        self._parms["link"] = link

    @property
    def rand_link(self):
        """
        Link function array for random component in HGLM.

        Type: ``List[Literal["[identity]", "[family_default]"]]``.
        """
        return self._parms.get("rand_link")

    @rand_link.setter
    def rand_link(self, rand_link):
        assert_is_type(rand_link, None, [Enum("[identity]", "[family_default]")])
        self._parms["rand_link"] = rand_link

    @property
    def startval(self):
        """
        double array to initialize fixed and random coefficients for HGLM, coefficients for GLM.

        Type: ``List[float]``.
        """
        return self._parms.get("startval")

    @startval.setter
    def startval(self, startval):
        assert_is_type(startval, None, [numeric])
        self._parms["startval"] = startval

    @property
    def calc_like(self):
        """
        if true, will return likelihood function value for HGLM.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("calc_like")

    @calc_like.setter
    def calc_like(self, calc_like):
        assert_is_type(calc_like, None, bool)
        self._parms["calc_like"] = calc_like

    @property
    def HGLM(self):
        """
        If set to true, will return HGLM model.  Otherwise, normal GLM model will be returned

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("HGLM")

    @HGLM.setter
    def HGLM(self, HGLM):
        assert_is_type(HGLM, None, bool)
        self._parms["HGLM"] = HGLM

    @property
    def prior(self):
        """
        Prior probability for y==1. To be used only for logistic regression iff the data has been sampled and the mean
        of response does not reflect reality.

        Type: ``float``, defaults to ``-1.0``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> cars_glm1 = H2OGeneralizedLinearEstimator(family='binomial', prior=0.5)
        >>> cars_glm1.train(x=predictors,
        ...                 y=response,
        ...                 training_frame=train,
        ...                 validation_frame=valid)
        >>> cars_glm1.mse()
        """
        return self._parms.get("prior")

    @prior.setter
    def prior(self, prior):
        assert_is_type(prior, None, numeric)
        self._parms["prior"] = prior

    @property
    def cold_start(self):
        """
        Only applicable to multiple alpha/lambda values.  If false, build the next model for next set of alpha/lambda
        values starting from the values provided by current model.  If true will start GLM model from scratch.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("cold_start")

    @cold_start.setter
    def cold_start(self, cold_start):
        assert_is_type(cold_start, None, bool)
        self._parms["cold_start"] = cold_start

    @property
    def lambda_min_ratio(self):
        """
        Minimum lambda used in lambda search, specified as a ratio of lambda_max (the smallest lambda that drives all
        coefficients to zero). Default indicates: if the number of observations is greater than the number of variables,
        then lambda_min_ratio is set to 0.0001; if the number of observations is less than the number of variables, then
        lambda_min_ratio is set to 0.01.

        Type: ``float``, defaults to ``-1.0``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> boston_glm = H2OGeneralizedLinearEstimator(lambda_min_ratio=.0001)
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> boston_glm.mse()
        """
        return self._parms.get("lambda_min_ratio")

    @lambda_min_ratio.setter
    def lambda_min_ratio(self, lambda_min_ratio):
        assert_is_type(lambda_min_ratio, None, numeric)
        self._parms["lambda_min_ratio"] = lambda_min_ratio

    @property
    def beta_constraints(self):
        """
        Beta constraints

        Type: ``Union[None, str, H2OFrame]``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> predictors = ["displacement","power","weight","year"]
        >>> response = "acceleration"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> n = len(predictors)
        >>> constraints = h2o.H2OFrame({'names':predictors,
        ...                             'lower_bounds': [-1000]*n,
        ...                             'upper_bounds': [1000]*n,
        ...                             'beta_given': [1]*n,
        ...                             'rho': [0.2]*n})
        >>> cars_glm = H2OGeneralizedLinearEstimator(standardize=True,
        ...                                          beta_constraints=constraints)
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.mse()
        """
        return self._parms.get("beta_constraints")

    @beta_constraints.setter
    def beta_constraints(self, beta_constraints):
        # beta_constraints can be specified as a H2OFrame or python dict
        assert_is_type(beta_constraints, None, dict, H2OFrame)
        if type(beta_constraints) is H2OFrame:
            self._parms["beta_constraints"]=beta_constraints
        if type(beta_constraints) is dict:
            colnames = beta_constraints.keys()
            col_names = []
            upper_bounds = []
            lower_bounds = []
            for key in colnames:
                one_col_bounds = beta_constraints.get(key)
                col_names.append(key)
                upper_bounds.append(one_col_bounds.get('upper_bound'))
                lower_bounds.append(one_col_bounds.get('lower_bound'))
            constraints = h2o.H2OFrame(dict([("names",col_names), ("lower_bounds", lower_bounds), ("upper_bounds", upper_bounds)]))
            self._parms["beta_constraints"] = constraints[["names", "lower_bounds", "upper_bounds"]]

    @property
    def max_active_predictors(self):
        """
        Maximum number of active predictors during computation. Use as a stopping criterion to prevent expensive model
        building with many predictors. Default indicates: If the IRLSM solver is used, the value of
        max_active_predictors is set to 5000 otherwise it is set to 100000000.

        Type: ``int``, defaults to ``-1``.

        :examples:

        >>> higgs= h2o.import_file("https://h2o-public-test-data.s3.amazonaws.com/smalldata/testng/higgs_train_5k.csv")
        >>> predictors = higgs.names
        >>> predictors.remove('response')
        >>> response = "response"
        >>> train, valid = higgs.split_frame(ratios=[.8])
        >>> higgs_glm = H2OGeneralizedLinearEstimator(family='binomial',
        ...                                           max_active_predictors=200)
        >>> higgs_glm.train(x=predictors,
        ...                 y=response,
        ...                 training_frame=train,
        ...                 validation_frame=valid)
        >>> higgs_glm.auc()
        """
        return self._parms.get("max_active_predictors")

    @max_active_predictors.setter
    def max_active_predictors(self, max_active_predictors):
        assert_is_type(max_active_predictors, None, int)
        self._parms["max_active_predictors"] = max_active_predictors

    @property
    def interactions(self):
        """
        A list of predictor column indices to interact. All pairwise combinations will be computed for the list.

        Type: ``List[str]``.

        :examples:

        >>> boston = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/BostonHousing.csv")
        >>> predictors = boston.columns[:-1]
        >>> response = "medv"
        >>> boston['chas'] = boston['chas'].asfactor()
        >>> train, valid = boston.split_frame(ratios=[.8])
        >>> interactions_list = ['crim', 'dis']
        >>> boston_glm = H2OGeneralizedLinearEstimator(interactions=interactions_list) 
        >>> boston_glm.train(x=predictors,
        ...                  y=response,
        ...                  training_frame=train,
        ...                  validation_frame=valid)
        >>> boston_glm.mse()
        """
        return self._parms.get("interactions")

    @interactions.setter
    def interactions(self, interactions):
        assert_is_type(interactions, None, [str])
        self._parms["interactions"] = interactions

    @property
    def interaction_pairs(self):
        """
        A list of pairwise (first order) column interactions.

        Type: ``List[tuple]``.

        :examples:

        >>> df = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/airlines/allyears2k_headers.zip")
        >>> XY = [df.names[i-1] for i in [1,2,3,4,6,8,9,13,17,18,19,31]]
        >>> interactions = [XY[i-1] for i in [5,7,9]]
        >>> m = H2OGeneralizedLinearEstimator(lambda_search=True,
        ...                                   family="binomial",
        ...                                   interactions=interactions)
        >>> m.train(x=XY[:len(XY)], y=XY[-1],training_frame=df)
        >>> m._model_json['output']['coefficients_table']
        >>> coef_m = m._model_json['output']['coefficients_table']
        >>> interaction_pairs = [("CRSDepTime", "UniqueCarrier"),
        ...                      ("CRSDepTime", "Origin"),
        ...                      ("UniqueCarrier", "Origin")]
        >>> mexp = H2OGeneralizedLinearEstimator(lambda_search=True,
        ...                                      family="binomial",
        ...                                      interaction_pairs=interaction_pairs)
        >>> mexp.train(x=XY[:len(XY)], y=XY[-1],training_frame=df)
        >>> mexp._model_json['output']['coefficients_table']
        """
        return self._parms.get("interaction_pairs")

    @interaction_pairs.setter
    def interaction_pairs(self, interaction_pairs):
        assert_is_type(interaction_pairs, None, [tuple])
        self._parms["interaction_pairs"] = interaction_pairs

    @property
    def obj_reg(self):
        """
        Likelihood divider in objective value computation, default (of -1.0) will set it to 1/nobs

        Type: ``float``, defaults to ``-1.0``.

        :examples:

        >>> df = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/bigdata/laptop/glm_ordinal_logit/ordinal_multinomial_training_set.csv")
        >>> df["C11"] = df["C11"].asfactor()
        >>> ordinal_fit = H2OGeneralizedLinearEstimator(family="ordinal",
        ...                                             alpha=1.0,
        ...                                             lambda_=0.000000001,
        ...                                             obj_reg=0.00001,
        ...                                             max_iterations=1000,
        ...                                             beta_epsilon=1e-8,
        ...                                             objective_epsilon=1e-10)
        >>> ordinal_fit.train(x=list(range(0,10)),
        ...                   y="C11",
        ...                   training_frame=df)
        >>> ordinal_fit.mse()
        """
        return self._parms.get("obj_reg")

    @obj_reg.setter
    def obj_reg(self, obj_reg):
        assert_is_type(obj_reg, None, numeric)
        self._parms["obj_reg"] = obj_reg

    @property
    def stopping_rounds(self):
        """
        Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
        stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)

        Type: ``int``, defaults to ``0``.
        """
        return self._parms.get("stopping_rounds")

    @stopping_rounds.setter
    def stopping_rounds(self, stopping_rounds):
        assert_is_type(stopping_rounds, None, int)
        self._parms["stopping_rounds"] = stopping_rounds

    @property
    def stopping_metric(self):
        """
        Metric to use for early stopping (AUTO: logloss for classification, deviance for regression and anonomaly_score
        for Isolation Forest). Note that custom and custom_increasing can only be used in GBM and DRF with the Python
        client.

        Type: ``Literal["auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "aucpr", "lift_top_group",
        "misclassification", "mean_per_class_error", "custom", "custom_increasing"]``, defaults to ``"auto"``.
        """
        return self._parms.get("stopping_metric")

    @stopping_metric.setter
    def stopping_metric(self, stopping_metric):
        assert_is_type(stopping_metric, None, Enum("auto", "deviance", "logloss", "mse", "rmse", "mae", "rmsle", "auc", "aucpr", "lift_top_group", "misclassification", "mean_per_class_error", "custom", "custom_increasing"))
        self._parms["stopping_metric"] = stopping_metric

    @property
    def stopping_tolerance(self):
        """
        Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much)

        Type: ``float``, defaults to ``0.001``.
        """
        return self._parms.get("stopping_tolerance")

    @stopping_tolerance.setter
    def stopping_tolerance(self, stopping_tolerance):
        assert_is_type(stopping_tolerance, None, numeric)
        self._parms["stopping_tolerance"] = stopping_tolerance

    @property
    def balance_classes(self):
        """
        Balance training data class counts via over/under-sampling (for imbalanced data).

        Type: ``bool``, defaults to ``False``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> predictors = ["displacement","power","weight","year"]
        >>> response = "acceleration"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> cars_glm = H2OGeneralizedLinearEstimator(balance_classes=True,
        ...                                          seed=1234)
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.mse()
        """
        return self._parms.get("balance_classes")

    @balance_classes.setter
    def balance_classes(self, balance_classes):
        assert_is_type(balance_classes, None, bool)
        self._parms["balance_classes"] = balance_classes

    @property
    def class_sampling_factors(self):
        """
        Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will
        be automatically computed to obtain class balance during training. Requires balance_classes.

        Type: ``List[float]``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> predictors = ["displacement","power","weight","year"]
        >>> response = "acceleration"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> sample_factors = [1., 0.5, 1., 1., 1., 1., 1.]
        >>> cars_glm = H2OGeneralizedLinearEstimator(balance_classes=True,
        ...                                          class_sampling_factors=sample_factors,
        ...                                          seed=1234)
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.mse()
        """
        return self._parms.get("class_sampling_factors")

    @class_sampling_factors.setter
    def class_sampling_factors(self, class_sampling_factors):
        assert_is_type(class_sampling_factors, None, [float])
        self._parms["class_sampling_factors"] = class_sampling_factors

    @property
    def max_after_balance_size(self):
        """
        Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires
        balance_classes.

        Type: ``float``, defaults to ``5.0``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> predictors = ["displacement","power","weight","year"]
        >>> response = "acceleration"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> max = .85
        >>> cars_glm = H2OGeneralizedLinearEstimator(balance_classes=True,
        ...                                          max_after_balance_size=max,
        ...                                          seed=1234)
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.mse()
        """
        return self._parms.get("max_after_balance_size")

    @max_after_balance_size.setter
    def max_after_balance_size(self, max_after_balance_size):
        assert_is_type(max_after_balance_size, None, float)
        self._parms["max_after_balance_size"] = max_after_balance_size

    @property
    def max_confusion_matrix_size(self):
        """
        [Deprecated] Maximum size (# classes) for confusion matrices to be printed in the Logs

        Type: ``int``, defaults to ``20``.
        """
        return self._parms.get("max_confusion_matrix_size")

    @max_confusion_matrix_size.setter
    def max_confusion_matrix_size(self, max_confusion_matrix_size):
        assert_is_type(max_confusion_matrix_size, None, int)
        self._parms["max_confusion_matrix_size"] = max_confusion_matrix_size

    @property
    def max_runtime_secs(self):
        """
        Maximum allowed runtime in seconds for model training. Use 0 to disable.

        Type: ``float``, defaults to ``0.0``.

        :examples:

        >>> cars = h2o.import_file("https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv")
        >>> cars["economy_20mpg"] = cars["economy_20mpg"].asfactor()
        >>> predictors = ["displacement","power","weight","acceleration","year"]
        >>> response = "economy_20mpg"
        >>> train, valid = cars.split_frame(ratios=[.8])
        >>> cars_glm = H2OGeneralizedLinearEstimator(max_runtime_secs=10,
        ...                                          seed=1234) 
        >>> cars_glm.train(x=predictors,
        ...                y=response,
        ...                training_frame=train,
        ...                validation_frame=valid)
        >>> cars_glm.mse()
        """
        return self._parms.get("max_runtime_secs")

    @max_runtime_secs.setter
    def max_runtime_secs(self, max_runtime_secs):
        assert_is_type(max_runtime_secs, None, numeric)
        self._parms["max_runtime_secs"] = max_runtime_secs

    @property
    def custom_metric_func(self):
        """
        Reference to custom evaluation function, format: `language:keyName=funcName`

        Type: ``str``.
        """
        return self._parms.get("custom_metric_func")

    @custom_metric_func.setter
    def custom_metric_func(self, custom_metric_func):
        assert_is_type(custom_metric_func, None, str)
        self._parms["custom_metric_func"] = custom_metric_func

    @property
    def generate_scoring_history(self):
        """
        If set to true, will generate scoring history for GLM.  This may significantly slow down the algo.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("generate_scoring_history")

    @generate_scoring_history.setter
    def generate_scoring_history(self, generate_scoring_history):
        assert_is_type(generate_scoring_history, None, bool)
        self._parms["generate_scoring_history"] = generate_scoring_history

    @property
    def auc_type(self):
        """
        Set default multinomial AUC type.

        Type: ``Literal["auto", "none", "macro_ovr", "weighted_ovr", "macro_ovo", "weighted_ovo"]``, defaults to
        ``"auto"``.
        """
        return self._parms.get("auc_type")

    @auc_type.setter
    def auc_type(self, auc_type):
        assert_is_type(auc_type, None, Enum("auto", "none", "macro_ovr", "weighted_ovr", "macro_ovo", "weighted_ovo"))
        self._parms["auc_type"] = auc_type

    @property
    def dispersion_epsilon(self):
        """
        If changes in dispersion parameter estimation or loglikelihood value is smaller than dispersion_epsilon, will
        break out of the dispersion parameter estimation loop using maximum likelihood.

        Type: ``float``, defaults to ``0.0001``.
        """
        return self._parms.get("dispersion_epsilon")

    @dispersion_epsilon.setter
    def dispersion_epsilon(self, dispersion_epsilon):
        assert_is_type(dispersion_epsilon, None, numeric)
        self._parms["dispersion_epsilon"] = dispersion_epsilon

    @property
    def tweedie_epsilon(self):
        """
        In estimating tweedie dispersion parameter using maximum likelihood, this is used to choose the lower and upper
        indices in the approximating of the infinite series summation.

        Type: ``float``, defaults to ``8e-17``.
        """
        return self._parms.get("tweedie_epsilon")

    @tweedie_epsilon.setter
    def tweedie_epsilon(self, tweedie_epsilon):
        assert_is_type(tweedie_epsilon, None, numeric)
        self._parms["tweedie_epsilon"] = tweedie_epsilon

    @property
    def max_iterations_dispersion(self):
        """
        Control the maximum number of iterations in the dispersion parameter estimation loop using maximum likelihood.

        Type: ``int``, defaults to ``3000``.
        """
        return self._parms.get("max_iterations_dispersion")

    @max_iterations_dispersion.setter
    def max_iterations_dispersion(self, max_iterations_dispersion):
        assert_is_type(max_iterations_dispersion, None, int)
        self._parms["max_iterations_dispersion"] = max_iterations_dispersion

    @property
    def build_null_model(self):
        """
        If set, will build a model with only the intercept.  Default to false.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("build_null_model")

    @build_null_model.setter
    def build_null_model(self, build_null_model):
        assert_is_type(build_null_model, None, bool)
        self._parms["build_null_model"] = build_null_model

    @property
    def fix_dispersion_parameter(self):
        """
        Only used for Tweedie, Gamma and Negative Binomial GLM.  If set, will use the dispsersion parameter in
        init_dispersion_parameter as the standard error and use it to calculate the p-values. Default to false.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("fix_dispersion_parameter")

    @fix_dispersion_parameter.setter
    def fix_dispersion_parameter(self, fix_dispersion_parameter):
        assert_is_type(fix_dispersion_parameter, None, bool)
        self._parms["fix_dispersion_parameter"] = fix_dispersion_parameter

    @property
    def generate_variable_inflation_factors(self):
        """
        if true, will generate variable inflation factors for numerical predictors.  Default to false.

        Type: ``bool``, defaults to ``False``.
        """
        return self._parms.get("generate_variable_inflation_factors")

    @generate_variable_inflation_factors.setter
    def generate_variable_inflation_factors(self, generate_variable_inflation_factors):
        assert_is_type(generate_variable_inflation_factors, None, bool)
        self._parms["generate_variable_inflation_factors"] = generate_variable_inflation_factors

    @property
    def fix_tweedie_variance_power(self):
        """
        If true, will fix tweedie variance power value to the value set in tweedie_variance_power.

        Type: ``bool``, defaults to ``True``.
        """
        return self._parms.get("fix_tweedie_variance_power")

    @fix_tweedie_variance_power.setter
    def fix_tweedie_variance_power(self, fix_tweedie_variance_power):
        assert_is_type(fix_tweedie_variance_power, None, bool)
        self._parms["fix_tweedie_variance_power"] = fix_tweedie_variance_power

    @property
    def dispersion_learning_rate(self):
        """
        Dispersion learning rate is only valid for tweedie family dispersion parameter estimation using ml. It must be >
        0.  This controls how much the dispersion parameter estimate is to be changed when the calculated loglikelihood
        actually decreases with the new dispersion.  In this case, instead of setting new dispersion = dispersion -
        change, we set new dispersion = dispersion + dispersion_learning_rate * change. Defaults to 0.5.

        Type: ``float``, defaults to ``0.5``.
        """
        return self._parms.get("dispersion_learning_rate")

    @dispersion_learning_rate.setter
    def dispersion_learning_rate(self, dispersion_learning_rate):
        assert_is_type(dispersion_learning_rate, None, numeric)
        self._parms["dispersion_learning_rate"] = dispersion_learning_rate

    Lambda = deprecated_property('Lambda', lambda_)

    @staticmethod
    def getAlphaBest(model):
        """
        Extract best alpha value found from glm model.

        :param model: source lambda search model

        :examples:

        >>> d = h2o.import_file("http://s3.amazonaws.com/h2o-public-test-data/smalldata/prostate/prostate.csv")
        >>> m = H2OGeneralizedLinearEstimator(family = 'binomial',
        ...                                   lambda_search = True,
        ...                                   solver = 'COORDINATE_DESCENT')
        >>> m.train(training_frame = d,
        ...         x = [2,3,4,5,6,7,8],
        ...         y = 1)
        >>> bestAlpha = H2OGeneralizedLinearEstimator.getAlphaBest(m)
        >>> print("Best alpha found is {0}".format(bestAlpha))
        """
        return model._model_json["output"]["alpha_best"]

    @staticmethod
    def getLambdaBest(model):
        """
        Extract best lambda value found from glm model.

        :param model: source lambda search model

        :examples:

        >>> d = h2o.import_file("http://s3.amazonaws.com/h2o-public-test-data/smalldata/prostate/prostate.csv")
        >>> m = H2OGeneralizedLinearEstimator(family = 'binomial',
        ...                                   lambda_search = True,
        ...                                   solver = 'COORDINATE_DESCENT')
        >>> m.train(training_frame = d,
        ...         x = [2,3,4,5,6,7,8],
        ...         y = 1)
        >>> bestLambda = H2OGeneralizedLinearEstimator.getLambdaBest(m)
        >>> print("Best lambda found is {0}".format(bestLambda))
        """
        return model._model_json["output"]["lambda_best"]

    @staticmethod
    def getLambdaMax(model):
        """
        Extract the maximum lambda value used during lambda search.

        :param model: source lambda search model

        :examples:

        >>> d = h2o.import_file("http://s3.amazonaws.com/h2o-public-test-data/smalldata/prostate/prostate.csv")
        >>> m = H2OGeneralizedLinearEstimator(family = 'binomial',
        ...                                   lambda_search = True,
        ...                                   solver = 'COORDINATE_DESCENT')
        >>> m.train(training_frame = d,
        ...         x = [2,3,4,5,6,7,8],
        ...         y = 1)
        >>> maxLambda = H2OGeneralizedLinearEstimator.getLambdaMax(m)
        >>> print("Maximum lambda found is {0}".format(maxLambda))
        """
        lambdaMax = model._model_json["output"]["lambda_max"] # will be -1 if lambda_search is disabled
        if lambdaMax >= 0:
            return lambdaMax
        else:
            raise H2OValueError("getLambdaMax(model) can only be called when lambda_search=True.")


    @staticmethod
    def getLambdaMin(model):
        """
        Extract the minimum lambda value calculated during lambda search from glm model.  Note that due to early stop,
        this minimum lambda value may not be used in the actual lambda search.

        :param model: source lambda search model

        :examples:

        >>> d = h2o.import_file("http://s3.amazonaws.com/h2o-public-test-data/smalldata/prostate/prostate.csv")
        >>> m = H2OGeneralizedLinearEstimator(family = 'binomial',
        ...                                   lambda_search = True,
        ...                                   solver = 'COORDINATE_DESCENT')
        >>> m.train(training_frame = d,
        ...         x = [2,3,4,5,6,7,8],
        ...         y = 1)
        >>> minLambda = H2OGeneralizedLinearEstimator.getLambdaMin(m)
        >>> print("Minimum lambda found is {0}".format(minLambda))
        """
        lambdaMin = model._model_json["output"]["lambda_min"] # will be -1 if lambda_search is disabled
        if lambdaMin >= 0:
            return lambdaMin
        else:
            raise H2OValueError("getLambdaMin(model) can only be called when lambda_search=True.")

    @staticmethod
    def getGLMRegularizationPath(model):
        """
        Extract full regularization path explored during lambda search from glm model.

        :param model: source lambda search model

        :examples:

        >>> d = h2o.import_file("http://s3.amazonaws.com/h2o-public-test-data/smalldata/prostate/prostate.csv")
        >>> m = H2OGeneralizedLinearEstimator(family = 'binomial',
        ...                                   lambda_search = True,
        ...                                   solver = 'COORDINATE_DESCENT')
        >>> m.train(training_frame = d,
        ...         x = [2,3,4,5,6,7,8],
        ...         y = 1)
        >>> r = H2OGeneralizedLinearEstimator.getGLMRegularizationPath(m)
        >>> m2 = H2OGeneralizedLinearEstimator.makeGLMModel(model=m,
        ...                                                 coefs=r['coefficients'][10])
        >>> dev1 = r['explained_deviance_train'][10]
        >>> p = m2.model_performance(d)
        >>> dev2 = 1-p.residual_deviance()/p.null_deviance()
        >>> print(dev1, " =?= ", dev2)
        """
        x = h2o.api("GET /3/GetGLMRegPath", data={"model": model._model_json["model_id"]["name"]})
        ns = x.pop("coefficient_names")
        res = {
            "lambdas": x["lambdas"],
            "alphas": x["alphas"],
            "explained_deviance_train": x["explained_deviance_train"],
            "explained_deviance_valid": x["explained_deviance_valid"],
            "coefficients": [dict(zip(ns, y)) for y in x["coefficients"]],
        }
        if "coefficients_std" in x and not(x["coefficients_std"] == None):
            res["coefficients_std"] = [dict(zip(ns, y)) for y in x["coefficients_std"]]
        return res

    @staticmethod
    def makeGLMModel(model, coefs, threshold=.5):
        """
        Create a custom GLM model using the given coefficients.

        Needs to be passed source model trained on the dataset to extract the dataset information from.

        :param model: source model, used for extracting dataset information
        :param coefs: dictionary containing model coefficients
        :param threshold: (optional, only for binomial) decision threshold used for classification

        :examples:

        >>> d = h2o.import_file("http://s3.amazonaws.com/h2o-public-test-data/smalldata/prostate/prostate.csv")
        >>> m = H2OGeneralizedLinearEstimator(family='binomial',
        ...                                   lambda_search=True,
        ...                                   solver='COORDINATE_DESCENT')
        >>> m.train(training_frame=d,
        ...         x=[2,3,4,5,6,7,8],
        ...         y=1)
        >>> r = H2OGeneralizedLinearEstimator.getGLMRegularizationPath(m)
        >>> m2 = H2OGeneralizedLinearEstimator.makeGLMModel(model=m,
        ...                                                 coefs=r['coefficients'][10])
        >>> dev1 = r['explained_deviance_train'][10]
        >>> p = m2.model_performance(d)
        >>> dev2 = 1-p.residual_deviance()/p.null_deviance()
        >>> print(dev1, " =?= ", dev2)
        """
        model_json = h2o.api(
            "POST /3/MakeGLMModel",
            data={"model": model._model_json["model_id"]["name"],
                  "names": list(coefs.keys()),
                  "beta": list(coefs.values()),
                  "threshold": threshold}
        )
        m = H2OGeneralizedLinearEstimator()
        m._resolve_model(model_json["model_id"]["name"], model_json)
        return m
